/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.ui.toolkit.viewers.AbstractTransferViewer;
import org.eclipse.egf.common.ui.toolkit.viewers.TransferTreeViewer;
import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.core.ui.internal.data.UiReferencedFactoryComponentContainer;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.internal.observable.IListViewerObserver;
import org.eclipse.egf.core.ui.internal.viewers.CustomTooltipLabelProvider;
import org.eclipse.egf.core.ui.internal.viewers.DecoratedModelLabelProvider;
import org.eclipse.egf.core.ui.internal.viewers.ObservableReferencedContractElementContentProvider;
import org.eclipse.egf.core.ui.internal.viewers.PossibleContractElementReferenceTreeContentProvider;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.core.ui.wizard.page.ContextElementValueWizardPage;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextElementReferenceWizardPage
extends AbstractModelElementWizardPage {
    private static final int TREE_VIEWER_STYLE = 2820;
    protected static final Logger __logger = Logger.getLogger((String)ContextElementReferenceWizardPage.class.getPackage().getName());
    private final int TRANSFER_BUTTONS = 24;
    private final int TRANSFER_TREE_STYLE = 88;
    protected AbstractTransferViewer _treeTransferViewer;
    private ILabelProvider _decoratedLabelProvider;

    public ContextElementReferenceWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public ContextElementReferenceWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected void createPageArea(Composite parent_p) {
        this._decoratedLabelProvider = new CustomTooltipLabelProvider(new DecoratedModelLabelProvider());
        this.createTransferViewer(parent_p);
    }

    private void createTransferViewer(Composite parent_p) {
        this._treeTransferViewer = new TransferTreeViewer(parent_p, 88, 2820, 2820);
        this.initializeHandlers(this._treeTransferViewer);
        AbstractTreeViewer rightViewer = (AbstractTreeViewer)this._treeTransferViewer.getRightViewer();
        ViewerSorter defaultViewerSorter = new ViewerSorter();
        rightViewer.setSorter(defaultViewerSorter);
        this._treeTransferViewer.getLeftViewer().setSorter(defaultViewerSorter);
        rightViewer.setAutoExpandLevel(-1);
        ContractElement referencedContractElement = this.handleRightViewerInitialization();
        HashSet<ContractElement> referencedContractElements = new HashSet<ContractElement>(0);
        if (referencedContractElement != null) {
            referencedContractElements.add(referencedContractElement);
        }
        this.handleSiblingContract(referencedContractElements);
        this.handleSiblingContextElements(referencedContractElements);
        this.handleLeftViewerInitialization(referencedContractElements);
        parent_p.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Composite control = (Composite)ContextElementReferenceWizardPage.this._treeTransferViewer.getControl();
                control.layout();
            }
        });
    }

    private void handleSiblingContract(Collection<ContractElement> referencedContractElements_p) {
        FactoryComponent fc = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)this.getParent());
        Contract contract = ModelHelper.getContract((FactoryComponent)fc);
        referencedContractElements_p.addAll(DataHelper.getReferencedContractElementsFor((Contract)contract));
    }

    private void handleSiblingContextElements(Collection<ContractElement> referencedContractElements_p) {
        Context context = (Context)this.getParent();
        referencedContractElements_p.addAll(DataHelper.getReferencedContractElementsFor((Context)context));
    }

    protected void initializeHandlers(AbstractTransferViewer transferViewer_p) {
        TypedSelectionChangedHandler handler = new TypedSelectionChangedHandler(){

            protected boolean handleInitialCondition() {
                return ContextElementReferenceWizardPage.this.getContextElement().getContractElementReference() == null;
            }
        };
        transferViewer_p.setSelectionChangedHandler((SelectionChangedHandler)handler, 8);
        handler = new TypedSelectionChangedHandler(){

            protected boolean handleInitialCondition() {
                return ContextElementReferenceWizardPage.this.getContextElement().getContractElementReference() != null;
            }
        };
        transferViewer_p.setSelectionChangedHandler((SelectionChangedHandler)handler, 16);
    }

    protected IContentProvider handleLeftViewerInitialization(Collection<ContractElement> referencedContractElementList_p) {
        this._treeTransferViewer.setLeftLabelProvider(this._decoratedLabelProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)((TreeViewer)this._treeTransferViewer.getLeftViewer()));
        PossibleContractElementReferenceTreeContentProvider possibleContractElementReferenceTreeContentProvider = new PossibleContractElementReferenceTreeContentProvider(referencedContractElementList_p);
        this._treeTransferViewer.setLeftContentProvider((IContentProvider)possibleContractElementReferenceTreeContentProvider);
        this._treeTransferViewer.setLeftInput((Object)this.getParent());
        return possibleContractElementReferenceTreeContentProvider;
    }

    protected ContractElement handleRightViewerInitialization() {
        this._treeTransferViewer.setRightLabelProvider(this._decoratedLabelProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)((TreeViewer)this._treeTransferViewer.getRightViewer()));
        ObservableReferencedContractElementContentProvider observableContentProvider = new ObservableReferencedContractElementContentProvider();
        this._treeTransferViewer.setRightContentProvider((IContentProvider)observableContentProvider);
        ContractElement referencedContractElement = DataHelper.getReferencedContractElementFor((ContextElement)this.getContextElement());
        ContractElement[] referencedContractElementArray = null;
        referencedContractElementArray = referencedContractElement != null ? new ContractElement[]{referencedContractElement} : new ContractElement[]{};
        UiReferencedFactoryComponentContainer initialInput = new UiReferencedFactoryComponentContainer(referencedContractElementArray);
        this._treeTransferViewer.setRightInput((Object)initialInput);
        ContractElementListObserver contractElementListObserver = new ContractElementListObserver();
        observableContentProvider.addListViewerObserver(contractElementListObserver);
        return referencedContractElement;
    }

    protected boolean getCompleteStatus() {
        return false;
    }

    protected String getPageTitle() {
        return Messages.ContextElementWizardPage_Title;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_CONTEXT_ELEMENT_REFERENCE_WIZARD_PAGE;
    }

    protected ContextElement getContextElement() {
        return (ContextElement)this.getModelElement();
    }

    public boolean canFlipToNextPage() {
        boolean canFlipToNextPage;
        ContextElement contextElement = this.getContextElement();
        ContractElement referencedContractElement = DataHelper.getReferencedContractElementFor((ContextElement)contextElement);
        boolean bl = canFlipToNextPage = referencedContractElement != null;
        if (canFlipToNextPage) {
            contextElement.setContextType(null);
            contextElement.setKey(null);
        }
        return canFlipToNextPage;
    }

    public IWizardPage getNextPage() {
        IWizard wizard = this.getWizard();
        ContextElementValueWizardPage nextPage = (ContextElementValueWizardPage)wizard.getPage("contextElementValuePage");
        ContractElement referencedContractElement = DataHelper.getReferencedContractElementFor((ContextElement)this.getContextElement());
        nextPage.updateContextElementType(referencedContractElement.getContractType().getTypeHolderClassName());
        return nextPage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ContractElementListObserver
    implements IListViewerObserver {
        ContractElementListObserver() {
        }

        @Override
        public void elementAdded(List<Object> elements_p) {
            ContractElement referencedContractElement = (ContractElement)elements_p.get(0);
            ContractElementReference contractElementReference = ModelHelper.createContractElementReferenceBasedOn((ContractElement)referencedContractElement);
            ContextElementReferenceWizardPage.this.getContextElement().setContractElementReference(contractElementReference);
            ContextElementReferenceWizardPage.this.updateButtons();
        }

        @Override
        public void elementRemoved(List<Object> elements_p) {
            ContractElement referencedContractElement;
            ContextElement contextElement = ContextElementReferenceWizardPage.this.getContextElement();
            ContractElement referencedContractElementToRemove = (ContractElement)elements_p.get(0);
            if (referencedContractElementToRemove == (referencedContractElement = DataHelper.getReferencedContractElementFor((ContextElement)contextElement))) {
                contextElement.setContractElementReference(null);
                contextElement.setContractReferenceId(null);
            } else {
                StringBuilder loggerMessage = new StringBuilder("ContractElementListObserver.elementRemoved(..) _ ");
                loggerMessage.append("Failed to remove the ContractElementReference for context element:");
                loggerMessage.append(contextElement.getId());
                __logger.warn((Object)loggerMessage.toString());
            }
            ContextElementReferenceWizardPage.this.updateButtons();
        }

        @Override
        public void elementUpdated(List<Object> elements_p) {
            ContextElementReferenceWizardPage.this.updateButtons();
        }
    }

    abstract class TypedSelectionChangedHandler
    extends SelectionChangedHandler {
        TypedSelectionChangedHandler() {
        }

        protected boolean doHandleSelection(ISelection selection_p) {
            boolean result = this.handleInitialCondition();
            if (selection_p instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)selection_p;
                Iterator selectedObjects = selection.iterator();
                while (selectedObjects.hasNext() && result) {
                    Object selectedObject = selectedObjects.next();
                    result = selectedObject instanceof ContractElement;
                }
            }
            return result;
        }

        protected abstract boolean handleInitialCondition();
    }
}

