/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.egf.common.ui.field.JavaClassFieldEditor;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.ValidatingStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.egf.common.ui.toolkit.validators.NotEmptyStringValidator;
import org.eclipse.egf.core.ui.internal.databinding.JavaTypeHolder;
import org.eclipse.egf.core.ui.internal.databinding.UpdateWizardPage;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.core.ui.wizard.page.ContextElementValueWizardPage;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.Type;
import org.eclipse.egf.model.contract.type.ITypeHolder;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class ContextElementKeyWizardPage
extends AbstractModelElementWizardPage {
    private JavaClassFieldEditor _contextElementKeyTypeFieldEditor;
    private ValidatingStringFieldEditor _contextElementKeyFieldEditor;

    public ContextElementKeyWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public ContextElementKeyWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected void createPageArea(Composite parent_p) {
        this.createKeyFieldEditor(parent_p);
        this.createKeyTypeFieldEditor(parent_p);
        this.handlePageLayout(parent_p);
    }

    protected void handlePageLayout(Composite parent_p) {
        FieldEditorHelper.layoutFieldEditor((Composite)parent_p, (FieldEditor)this._contextElementKeyFieldEditor, (int)3);
    }

    private void createKeyTypeFieldEditor(Composite parent_p) {
        this._contextElementKeyTypeFieldEditor = FieldEditorHelper.createJavaClassFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.ContextElementKeyWizardPage_Type_Title, (String)Messages.ContextElementKeyWizardPage_OpenTypeDialog_Title, (ClassLoader)this.getHostingProjectClassLoader(), (Bundle)this.getHostingBundle(), ITypeHolder.class, (boolean)this.isReadOnly());
        Text className = this._contextElementKeyTypeFieldEditor.getTextControl(parent_p);
        ContextElement contextElement = (ContextElement)this.getModelElement();
        Type contextType = contextElement.getContextType();
        String typeHolderClassName = contextType != null ? contextType.getTypeHolderClassName() : "";
        this.bindTextToAttribute(className, "type", new JavaTypeHolder(typeHolderClassName), (UpdateWizardPage)new JavaTypeHolderChangeListener(this));
        this._contextElementKeyTypeFieldEditor.isValid(true);
    }

    private void createKeyFieldEditor(Composite parent_p) {
        this._contextElementKeyFieldEditor = FieldEditorHelper.createStringFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.ContextElementWizardPage_Key_Title, (String)Messages.ContextElementWizardPage_Key_Tooltip, null, (int)-1, (IValidator)new NotEmptyStringValidator(Messages.ContextElementWizardPage_Key_ErrorMessage), (boolean)this.isReadOnly());
        Text key = this._contextElementKeyFieldEditor.getTextControl();
        key.setFocus();
        this.bindTextToAttribute(key, ModelPackage.Literals.CONTEXT_ELEMENT__KEY, this.getModelElement(), null);
        this._contextElementKeyFieldEditor.isValid(true);
    }

    protected boolean getCompleteStatus() {
        return false;
    }

    public boolean canFlipToNextPage() {
        IFieldEditor[] fieldEditors = new IFieldEditor[]{this._contextElementKeyFieldEditor, this._contextElementKeyTypeFieldEditor};
        boolean canFlipToNextPage = this.handleFieldEditorValidation(fieldEditors);
        if (canFlipToNextPage) {
            this.getContextElement().setContractElementReference(null);
        }
        return canFlipToNextPage;
    }

    protected String getPageTitle() {
        return Messages.ContextElementWizardPage_Title;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_CONTEXT_ELEMENT_TYPE_WIZARD_PAGE;
    }

    protected ContextElement getContextElement() {
        return (ContextElement)this.getModelElement();
    }

    public IWizardPage getNextPage() {
        IWizard wizard = this.getWizard();
        ContextElementValueWizardPage nextPage = (ContextElementValueWizardPage)wizard.getPage("contextElementValuePage");
        nextPage.updateContextElementType(this._contextElementKeyTypeFieldEditor.getStringValue());
        return nextPage;
    }

    class JavaTypeHolderChangeListener
    extends UpdateWizardPage {
        public JavaTypeHolderChangeListener(AbstractModelElementWizardPage wizardPage_p) {
            super(wizardPage_p);
        }

        public void handleValueChange(ValueChangeEvent event_p) {
            String typeClassName = (String)event_p.getObservableValue().getValue();
            ContextElement contextElement = ContextElementKeyWizardPage.this.getContextElement();
            ModelHelper.setContextType((ContextElement)contextElement, (String)typeClassName);
            super.handleValueChange(event_p);
        }
    }
}

