/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.viewers;

import org.eclipse.egf.common.ui.constant.IUiCommonConstants;
import org.eclipse.egf.core.ui.data.ElementAdapterFactory;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class AbstractAdaptedModelElementContentProvider
implements ITreeContentProvider {
    private AdapterFactoryContentProvider _adapterFactoryContentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory());
    private AbstractTreeViewer _viewer;
    private Object _initialInput;

    protected abstract AdapterFactory getAdapterFactory();

    public AdapterFactoryContentProvider getAdapterFactoryContentProvider() {
        return this._adapterFactoryContentProvider;
    }

    public Object[] getChildren(Object parentElement_p) {
        Object[] elements = IUiCommonConstants.NO_ELEMENT;
        if (parentElement_p instanceof NamedModelElementWithId) {
            elements = this._adapterFactoryContentProvider.getChildren(parentElement_p);
        } else {
            IWorkbenchAdapter adapter = ElementAdapterFactory.getWorkbenchAdapter(parentElement_p);
            if (adapter != null) {
                elements = adapter.getChildren(parentElement_p);
            }
        }
        return elements;
    }

    public Object getParent(Object element_p) {
        Object parent = null;
        if (element_p instanceof NamedModelElementWithId) {
            parent = this._adapterFactoryContentProvider.getParent(element_p);
        } else {
            IWorkbenchAdapter adapter = ElementAdapterFactory.getWorkbenchAdapter(element_p);
            if (adapter != null) {
                parent = adapter.getParent(element_p);
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element_p) {
        boolean hasChildren = false;
        if (element_p instanceof NamedModelElementWithId) {
            hasChildren = this._adapterFactoryContentProvider.hasChildren(element_p);
        } else {
            IWorkbenchAdapter adapter = ElementAdapterFactory.getWorkbenchAdapter(element_p);
            if (adapter != null) {
                hasChildren = adapter.getChildren(element_p).length > 0;
            }
        }
        return hasChildren;
    }

    public Object[] getElements(Object inputElement_p) {
        Object[] elements = IUiCommonConstants.NO_ELEMENT;
        if (inputElement_p instanceof NamedModelElementWithId) {
            elements = this._adapterFactoryContentProvider.getElements(inputElement_p);
        } else {
            IWorkbenchAdapter adapter = ElementAdapterFactory.getWorkbenchAdapter(inputElement_p);
            if (adapter != null) {
                elements = adapter.getChildren(inputElement_p);
            }
        }
        return elements;
    }

    public void dispose() {
        this._adapterFactoryContentProvider.dispose();
    }

    public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        if (this._viewer == null) {
            this._viewer = (AbstractTreeViewer)viewer_p;
            this._initialInput = newInput_p;
        } else if (oldInput_p == this._initialInput && newInput_p != null) {
            this._initialInput = newInput_p;
        }
        this._adapterFactoryContentProvider.inputChanged(viewer_p, oldInput_p, newInput_p);
    }

    protected AbstractTreeViewer getViewer() {
        return this._viewer;
    }

    protected Object getInitialInput() {
        return this._initialInput;
    }
}

