/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.mapping.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.common.helper.EcoreHelper;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.mapping.data.MappingElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreMappingRoot;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcorePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingServices {
    private String _mappingRelativeFilePath;
    private Ecore2EcoreMappingRoot _ecore2ecore;

    public MappingServices(String mappingRelativeFilePath_p) {
        this._mappingRelativeFilePath = mappingRelativeFilePath_p;
    }

    public List<MappingElement> getMappingElements(EModelElement modelElement_p) {
        Ecore2EcoreMappingRoot ecore2EcoreMappingRoot = this.getEcore2EcoreMappingRoot();
        List<MappingElement> result = Collections.emptyList();
        if (ecore2EcoreMappingRoot != null) {
            result = this.getMappingElements(modelElement_p, (EList<Mapping>)ecore2EcoreMappingRoot.getNested());
        }
        return result;
    }

    protected List<MappingElement> getMappingElements(EModelElement modelElement_p, EList<Mapping> mappings_p) {
        ArrayList<MappingElement> result = new ArrayList<MappingElement>(0);
        for (Mapping currentMapping : mappings_p) {
            List<MappingElement> mappingElements;
            MappingElement mappingElement = this.getMappingElements(modelElement_p, currentMapping);
            List<MappingElement> list = mappingElements = mappingElement != null ? Collections.singletonList(mappingElement) : null;
            if (mappingElements == null) {
                mappingElements = this.getMappingElements(modelElement_p, (EList<Mapping>)currentMapping.getNested());
            }
            if (mappingElements == null || mappingElements.isEmpty()) continue;
            result.addAll(mappingElements);
        }
        return result;
    }

    protected MappingElement getMappingElements(EModelElement modelElement_p, Mapping mapping_p) {
        EList outputs;
        MappingElement result = null;
        EList inputs = mapping_p.getInputs();
        result = this.getMappingElements(modelElement_p, (EList<EObject>)inputs, (EList<EObject>)(outputs = mapping_p.getOutputs()));
        if (result == null) {
            result = this.getMappingElements(modelElement_p, (EList<EObject>)outputs, (EList<EObject>)inputs);
        }
        return result;
    }

    protected MappingElement getMappingElements(EModelElement modelElement_p, EList<EObject> sources_p, EList<EObject> targets_p) {
        MappingElement result = null;
        Iterator inputs = sources_p.iterator();
        while (inputs.hasNext() && result == null) {
            EObject currentSource = (EObject)inputs.next();
            if (!EcoreHelper.equals((EObject)currentSource, (EObject)modelElement_p)) continue;
            result = new MappingElement();
            result.addSources((Collection<EObject>)sources_p);
            result.addTargets((Collection<EObject>)targets_p);
        }
        return result;
    }

    protected Ecore2EcoreMappingRoot getEcore2EcoreMappingRoot() {
        if (this._ecore2ecore == null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI ecore2ecoreURI = FileHelper.getFileFullUri((String)this._mappingRelativeFilePath);
            Resource resource = resourceSet.getResource(ecore2ecoreURI, true);
            this._ecore2ecore = (Ecore2EcoreMappingRoot)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)Ecore2EcorePackage.eINSTANCE.getEcore2EcoreMappingRoot());
            EPackage inputEPackage = this._ecore2ecore.getInputEPackage();
            this.initializeEPackage(inputEPackage, inputEPackage.eResource(), (ResourceSet)resourceSet);
            EPackage outputEPackage = this._ecore2ecore.getOutputEPackage();
            this.initializeEPackage(outputEPackage, outputEPackage.eResource(), (ResourceSet)resourceSet);
        }
        return this._ecore2ecore;
    }

    private void initializeEPackage(EPackage package_p, Resource resource_p, ResourceSet resourceSet_p) {
        URI eResourceURI = resource_p.getURI();
        EPackage staticPackageInstance = EcoreHelper.getStaticPackage((EPackage)package_p);
        if (staticPackageInstance != null) {
            resourceSet_p.getPackageRegistry().put((Object)eResourceURI.toString(), (Object)staticPackageInstance);
            resource_p.unload();
            resourceSet_p.getResources().remove((Object)resource_p);
        }
    }
}

