/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.pattern.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.descriptor.GenericDescriptor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentDescriptor;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.pattern.reader.IPatternExtensionReader;
import org.eclipse.egf.pde.reader.CreateDescriptorOperation;
import org.eclipse.egf.pde.reader.PdeAbstractReader;
import org.eclipse.egf.pde.reader.WorkspaceFactoryComponentReader;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class WorkspacePatternExtensionReader
extends PdeAbstractReader
implements IPatternExtensionReader {
    public IDescriptor getPatternLibrary(String libraryFullId_p) {
        IDescriptor result = null;
        Collection projectsList = EgfPdeActivator.getDefault().getPluginProjects();
        Iterator projects = projectsList.iterator();
        while (projects.hasNext() && result == null) {
            IDescriptor descriptor = this.readPatternExtension((IProject)projects.next(), libraryFullId_p);
            if (descriptor == null) continue;
            result = descriptor;
        }
        return result;
    }

    public IDescriptor getPatternLibraries() {
        GenericDescriptor result = new GenericDescriptor();
        Collection projects = EgfPdeActivator.getDefault().getPluginProjects();
        for (IProject project : projects) {
            IDescriptor descriptor = this.readPatternExtension(project, null);
            if (descriptor == null) continue;
            result.addChild(descriptor);
        }
        return result;
    }

    public IDescriptor getPatternLibraries(String fcId_p) {
        return this.getPatternLibraries(EgfPdeActivator.getDefault().getProjectForFactoryComponent(fcId_p));
    }

    public IDescriptor getPatternLibraries(IProject project_p) {
        IDescriptor result = this.readPatternExtension(project_p, null);
        if (result == null) {
            result = new GenericDescriptor();
        }
        return result;
    }

    public IDescriptor readPatternExtension(IProject project_p, String libraryFullId_p) {
        IDescriptor result = null;
        if (project_p == null) {
            return result;
        }
        IFile file = EgfPdeActivator.getDefault().getFile(project_p);
        if (file != null) {
            result = this.readDescriptor(new CreatePatternExtensionDescriptorOperation(file, libraryFullId_p));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CreatePatternExtensionDescriptorOperation
    extends CreateDescriptorOperation {
        private String _libraryFullId;
        private IProject _project;

        public CreatePatternExtensionDescriptorOperation(IFile modelFile_p, String libraryFullId_p) {
            super(modelFile_p);
            this._libraryFullId = libraryFullId_p;
            this._project = modelFile_p.getProject();
        }

        protected IDescriptor createDescriptor(IPluginModelBase model_p) {
            GenericDescriptor descriptor = null;
            if (this._libraryFullId == null) {
                IPluginElement[] pluginElements = this.getExtensionWithNodeName(model_p, "org.eclipse.egf.pattern.pattern", "library");
                List<GenericDescriptor> descriptors = this.createDescriptors(pluginElements);
                if (!descriptors.isEmpty()) {
                    descriptor = new GenericDescriptor();
                    descriptor.addChildren(descriptors);
                }
            } else {
                List<GenericDescriptor> descriptors;
                IPluginElement pluginElement = this.getExtensionWithId(model_p, "org.eclipse.egf.pattern.pattern", this._libraryFullId);
                if (pluginElement != null && !(descriptors = this.createDescriptors(new IPluginElement[]{pluginElement})).isEmpty()) {
                    descriptor = descriptors.get(0);
                }
            }
            return descriptor;
        }

        protected List<GenericDescriptor> createDescriptors(IPluginElement[] elements_p) {
            ArrayList<GenericDescriptor> result = new ArrayList<GenericDescriptor>(0);
            IPluginElement[] iPluginElementArray = elements_p;
            int n = elements_p.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginElement element = iPluginElementArray[n2];
                GenericDescriptor newDescriptor = new GenericDescriptor();
                this.fillDescriptor(newDescriptor, element);
                result.add(newDescriptor);
                ++n2;
            }
            return result;
        }

        protected void fillDescriptor(GenericDescriptor descriptor_p, IPluginElement element_p) {
            descriptor_p.setValue("id", (Object)this.getPluginAttributeValue(element_p, "id"));
            String pluginId = this.resolvePluginId(element_p);
            descriptor_p.setValue("pluginId", (Object)pluginId);
            WorkspaceFactoryComponentReader reader = WorkspaceFactoryComponentReader.getDefault();
            IFactoryComponentDescriptor fcDescriptor = reader.readFactoryComponent(this._project);
            if (fcDescriptor != null) {
                descriptor_p.setValue("fcName", (Object)fcDescriptor.getName());
            }
            String elementType = element_p.getName();
            descriptor_p.setValue("patternExtType", (Object)elementType);
            descriptor_p.setValue("fromWorkspace", (Object)Boolean.TRUE);
            descriptor_p.setValue("wsProject", (Object)this._project);
            descriptor_p.setValue("name", (Object)this.getPluginAttributeValue(element_p, "name"));
            if ("library".equals(elementType)) {
                descriptor_p.setValue("productionOrchestration", (Object)this.getPluginAttributeValue(element_p, "productionOrchestration"));
                descriptor_p.setValue("runtimeOrchestration", (Object)this.getPluginAttributeValue(element_p, "runtimeOrchestration"));
                descriptor_p.addChildren(this.createDescriptors(this.getChildren(element_p)));
            } else if ("pattern".equals(elementType)) {
                descriptor_p.setValue("model", (Object)this.getPluginAttributeValue(element_p, "model"));
            }
        }

        private String resolvePluginId(IPluginElement element_p) {
            String result = null;
            IResource underlyingResource = element_p.getPluginModel().getUnderlyingResource();
            if (underlyingResource != null) {
                IPath fullPath = underlyingResource.getFullPath();
                result = fullPath.segment(0);
            }
            return result;
        }
    }
}

