/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.refactoring.move;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.PatternViewpoint;
import org.eclipse.egf.pattern.ui.editor.PatternEditorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveInfo {
    private Set<AbstractPatternElement> _elementsToMove;
    private NamedModelElementWithId _destinationElement;

    private void ensureElementsToMoveStructure(int initialSize_p) {
        if (this._elementsToMove == null) {
            this._elementsToMove = new HashSet<AbstractPatternElement>(initialSize_p);
        }
    }

    public Collection<AbstractPatternElement> getElementsToMove() {
        this.ensureElementsToMoveStructure(0);
        return this._elementsToMove;
    }

    public AbstractPatternElement getFirstElementToMove() {
        AbstractPatternElement result = null;
        this.ensureElementsToMoveStructure(0);
        if (!this._elementsToMove.isEmpty()) {
            result = this._elementsToMove.iterator().next();
        }
        return result;
    }

    public void addElementsToMove(Collection<AbstractPatternElement> elementsToMove_p) {
        Assert.isNotNull(elementsToMove_p);
        Assert.isTrue((!elementsToMove_p.isEmpty() ? 1 : 0) != 0);
        this.ensureElementsToMoveStructure(elementsToMove_p.size());
        this._elementsToMove.addAll(elementsToMove_p);
    }

    public void addElementToMove(AbstractPatternElement element_p) {
        Assert.isNotNull((Object)element_p);
        this.ensureElementsToMoveStructure(1);
        this._elementsToMove.add(element_p);
    }

    protected boolean isRelevantElementToMove(AbstractPatternElement element_p) {
        boolean result = true;
        if (this._destinationElement == null) {
            return result;
        }
        boolean bl = result = this._destinationElement != element_p.eContainer() && this._destinationElement != element_p;
        if (result && element_p instanceof PatternModel) {
            PatternModel patternModel = (PatternModel)element_p;
            result = PatternEditorHelper.isPatternEditorOpen((PatternModel)patternModel) == null;
        }
        return result;
    }

    public boolean isMoveAcceptable() {
        boolean result = true;
        if (this._destinationElement instanceof PatternViewpoint) {
            for (AbstractPatternElement patternElement : this._elementsToMove) {
                if (!(patternElement instanceof PatternModel)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public void retainRelevantElementsToMove() {
        Assert.isNotNull((Object)this._destinationElement);
        Assert.isNotNull(this._elementsToMove);
        Assert.isTrue((!this._elementsToMove.isEmpty() ? 1 : 0) != 0);
        HashSet<AbstractPatternElement> clonedElements = new HashSet<AbstractPatternElement>(this._elementsToMove.size());
        clonedElements.addAll(this._elementsToMove);
        for (AbstractPatternElement abstractPatternElement : clonedElements) {
            if (this.isRelevantElementToMove(abstractPatternElement)) continue;
            this._elementsToMove.remove(abstractPatternElement);
        }
    }

    public boolean checkDestinationType() {
        return this._destinationElement instanceof PatternLibrary || this._destinationElement instanceof PatternViewpoint;
    }

    public NamedModelElementWithId getDestinationElement() {
        return this._destinationElement;
    }

    public void setDestinationElement(NamedModelElementWithId destinationElement_p) {
        this._destinationElement = destinationElement_p;
    }
}

