/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.refactoring.internal.move.change;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.PatternHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.pattern.ecore.AbstractPatternGenerator;
import org.eclipse.egf.pattern.ecore.AnnotationHandler;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.production.GeneratedContentProducer;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.pattern.plugin.command.PatternConditionExtensionFactory;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommandRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EOperation;

public class RefactoringPatternHandler
extends PatternHandler {
    public void refactorFullId(String newPatternFullId_p, boolean updateExtensions_p) throws Exception {
        if (newPatternFullId_p == null) {
            return;
        }
        PatternHandler.PatternData patternData = this.getPatternData();
        String newShortId = (String)PatternHelper.deresolveId((String)newPatternFullId_p).getValue();
        String oldFullId = patternData.getPattern().getId();
        if (!newShortId.equals(patternData.getPattern().getShortId())) {
            throw new IllegalArgumentException("Pattern short id cannot be changed ! Only containing libraries can be modified.");
        }
        patternData.getPattern().setId(newPatternFullId_p);
        if (updateExtensions_p) {
            IPluginChangesCommandRunner pluginChangesCommandRunner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
            ArrayList<IPluginChangesCommand> updateExtensionsCommands = new ArrayList<IPluginChangesCommand>(3);
            updateExtensionsCommands.add(PatternConditionExtensionFactory.updatePatternConditionExtension((String)oldFullId, (String)newPatternFullId_p));
            pluginChangesCommandRunner.performChangesOnPlugin(patternData.getPluginId(), updateExtensionsCommands);
        }
    }

    public void refactorContainingFactoryComponent(String previousFcId_p, String destinationFcId_p) throws Exception {
        if (previousFcId_p == null || destinationFcId_p == null || previousFcId_p.equals(destinationFcId_p)) {
            return;
        }
        PatternHandler.PatternData patternData = this.getPatternData();
        String previousPluginId = patternData.getPluginId();
        String newPluginId = EgfPdeActivator.getDefault().getPluginIdForFactoryComponent(destinationFcId_p);
        String userTemplatesRelativePath = (String)TemplateHelper.getPatternTemplatesFolderRelativePaths((String)patternData.getPattern().getShortId(), (String)previousPluginId).getKey();
        IFolder userTemplatesFolder = FileHelper.getPlatformFolder((String)userTemplatesRelativePath);
        boolean userTemplatesFolderMoved = true;
        if (userTemplatesFolder.exists()) {
            Path newPath = new Path(String.valueOf('/') + (String)TemplateHelper.getPatternTemplatesFolderRelativePaths((String)patternData.getPattern().getShortId(), (String)newPluginId).getKey());
            userTemplatesFolderMoved = FileHelper.moveResource((IResource)userTemplatesFolder, (IPath)newPath);
        }
        if (!userTemplatesFolderMoved) {
            return;
        }
        String conditionClassRelativePath = GeneratedContentProducer.getConditionFileRelativePath((PatternHandler.PatternData)patternData);
        IFile conditionClassFile = FileHelper.getPlatformFile((String)conditionClassRelativePath);
        boolean conditionClassMoved = true;
        if (conditionClassFile.exists()) {
            IPath conditionClassDestinationPath = new Path(String.valueOf('/') + newPluginId).append(conditionClassFile.getFullPath().removeFirstSegments(1));
            ProjectHelper.createFolder((String)conditionClassDestinationPath.removeLastSegments(1).removeFirstSegments(1).removeFileExtension().toString(), (IProject)ProjectHelper.getProject((String)newPluginId), (IProgressMonitor)new NullProgressMonitor());
            conditionClassMoved = FileHelper.moveResource((IResource)conditionClassFile, (IPath)conditionClassDestinationPath);
        }
        if (!conditionClassMoved) {
            return;
        }
        IPluginChangesCommand unsetPatternConditionExtensionCommand = PatternConditionExtensionFactory.unsetPatternConditionExtension((String)patternData.getPattern().getId());
        IPluginChangesCommandRunner pluginChangesCommandRunner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
        pluginChangesCommandRunner.performChangesOnPlugin(previousPluginId, Collections.singletonList(unsetPatternConditionExtensionCommand));
        String patternFileRelativePath = patternData.getRealRelativePath();
        IFile patternFile = FileHelper.getPlatformFile((String)patternFileRelativePath);
        boolean patternFileMoved = true;
        IPath newPatternPath = new Path("/").append(AbstractPatternGenerator.getPatternModelRelativePath((String)newPluginId, (String)patternData.getPattern().getShortId()));
        ProjectHelper.createFolder((String)newPatternPath.removeLastSegments(1).removeFirstSegments(1).toString(), (IProject)ProjectHelper.getProject((String)newPluginId), (IProgressMonitor)new NullProgressMonitor());
        if (patternFile.exists()) {
            patternFileMoved = FileHelper.moveResource((IResource)patternFile, (IPath)newPatternPath);
        }
        if (!patternFileMoved) {
            return;
        }
        String expectedPath = String.valueOf('/') + destinationFcId_p + '/' + newPatternPath.removeFirstSegments(1).toString();
        this.load(expectedPath);
        this.recomputeOperationsPaths(previousFcId_p, destinationFcId_p);
    }

    protected boolean recomputeOperationsPaths(String previousFcId_p, String newFcId_p) {
        PatternHandler.PatternData patternData = this.getPatternData();
        AnnotationHandler annotationHandler = new AnnotationHandler();
        String patternShortId = patternData.getPattern().getShortId();
        EList operations = patternData.getPattern().getEOperations();
        for (EOperation operation : operations) {
            if (!annotationHandler.hasPatternCode(operation)) continue;
            String name = operation.getName();
            String uid = annotationHandler.getUid(operation);
            String previousTemplatePath = TemplateHelper.getTemplateRelativePath((String)patternShortId, (String)previousFcId_p, (String)name, (String)uid);
            String newTemplatePath = TemplateHelper.getTemplateRelativePath((String)patternShortId, (String)newFcId_p, (String)name, (String)uid);
            if (previousTemplatePath == null || newTemplatePath == null) continue;
            List orderedActions = annotationHandler.getOrderedActionsFor(operation);
            annotationHandler.replaceParameter(previousTemplatePath, newTemplatePath, orderedActions);
            annotationHandler.recomputeAnnotationFromActions(operation, orderedActions);
        }
        return true;
    }

    protected void updatePatternModel(PatternModel patternModel_p, PatternHandler.PatternData patternData_p) {
        if (patternData_p == null || patternModel_p == null) {
            return;
        }
        patternModel_p.setPath(patternData_p.getFileRelativePath());
    }
}

