/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.plugin.gen.task;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.common.listener.DefaultResourceListener;
import org.eclipse.egf.common.progress.IProgressRunnable;
import org.eclipse.egf.common.progress.ProgressReporter;
import org.eclipse.egf.core.task.AbstractTask;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.plugin.gen.task.Messages;

public class CreatePluginTask
extends AbstractTask {
    protected static final String CONTEXT_ELEMENT_CREATE_FC = "createAsFactoryComponent";
    protected static final String CONTEXT_ELEMENT_PROJECT_NAME = "projectName";
    protected volatile boolean _manifestCreated;

    protected boolean doExecute(IProgressMonitor progressMonitor_p) {
        this._manifestCreated = false;
        final boolean[] result = new boolean[1];
        final String projectName = (String)this.getContextElementValue(CONTEXT_ELEMENT_PROJECT_NAME);
        if (projectName == null) {
            return result[0];
        }
        Boolean createAsFC = (Boolean)this.getContextElementValue(CONTEXT_ELEMENT_CREATE_FC);
        boolean makeItAFC = false;
        if (createAsFC != null) {
            makeItAFC = createAsFC;
        }
        ProjectHelper.ProjectExistenceStatus projectExistence = ProjectHelper.ensureProjectExists((String)projectName);
        IProject project = ProjectHelper.getProject((String)projectName);
        FactoryComponent existingFC = EgfPdeActivator.getDefault().getFactoryComponent(project);
        if (makeItAFC && existingFC == null && ProjectHelper.ProjectExistenceStatus.CREATED.equals((Object)projectExistence)) {
            new DefaultResourceListener(){

                protected void handleResourceChanged(IResourceChangeEvent event_p, IResource watchedResource_p) {
                    if (result[0]) {
                        this.dispose();
                        CreatePluginTask.this.asyncConvertToFc(projectName);
                    }
                }
            }.setResourceToWatch((IResource)project.getFile("/META-INF/MANIFEST.MF"));
        }
        if (ProjectHelper.ProjectExistenceStatus.CREATION_FAILED.equals((Object)projectExistence)) {
            return result[0];
        }
        if (ProjectHelper.ProjectExistenceStatus.CREATED.equals((Object)projectExistence)) {
            new DefaultResourceListener(){

                protected void handleResourceChanged(IResourceChangeEvent event_p, IResource watchedResource_p) {
                    this.dispose();
                    CreatePluginTask.this._manifestCreated = true;
                }
            }.setResourceToWatch((IResource)project.getFile("/META-INF/MANIFEST.MF"));
            result[0] = EgfPdeActivator.getDefault().convertToPlugin(projectName);
        } else {
            result[0] = ProjectHelper.ProjectExistenceStatus.ALREADY_EXISTS.equals((Object)projectExistence);
            this._manifestCreated = true;
            if (makeItAFC && existingFC == null) {
                this.asyncConvertToFc(projectName);
            }
        }
        while (!this._manifestCreated) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return result[0];
    }

    protected void asyncConvertToFc(final String projectName_p) {
        IProgressRunnable convertToFc = new IProgressRunnable(){

            public String getReportingTitle() {
                return StringHelper.formatMessage((String)Messages.CreatePluginTask_ConvertToFcProgressMessage, (Object[])new Object[]{projectName_p});
            }

            public boolean run(IProgressMonitor progressMonitor_p) {
                EgfPdeActivator.getDefault().convertToFactoryComponent(projectName_p);
                return true;
            }
        };
        ProgressReporter.asyncExec((IProgressRunnable)convertToFc);
    }
}

