/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.GerritCredentials;
import org.eclipse.egerrit.internal.core.GerritFactory;
import org.eclipse.egerrit.internal.core.GerritHttpClient;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritRepository {
    private static Logger logger = LoggerFactory.getLogger(GerritRepository.class);
    public static final Version NO_VERSION = new Version(0, 0, 0);
    private final String fScheme;
    private final String fHostname;
    private final int fPort;
    private final String fPath;
    private final HttpHost fHost;
    private GerritCredentials fCredentials = null;
    private boolean fAcceptSelfSignedCerts;
    private Version fVersion = null;
    private GerritHttpClient fHttpClient = null;
    private GerritServerInformation serverInfo = null;
    private int fStatus;
    private static final String VERSION_REQUEST = "/config/server/version";
    private static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    public static final int SSL_PROBLEM = -1;
    public static final int SSL_INVALID_ROOT_CERTIFICATE = -2;
    private static final Pattern MAJOR_MINOR_MICRO_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?");
    private static final Pattern MAJOR_MINOR_QUALIFIER_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)-(\\w+).*");
    private static final Pattern MAJOR_MINOR_MICRO_QUALIFIER_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+).(\\d+)-(\\w+).*");

    public GerritRepository(String scheme, String host, int port, String path) {
        this.fScheme = scheme;
        this.fHostname = host;
        this.fPort = port;
        this.fHost = this.fHostname != null && !this.fHostname.isEmpty() ? new HttpHost(this.fHostname, this.fPort, this.fScheme) : null;
        this.fPath = path;
    }

    public GerritRepository(String urlString) throws EGerritException {
        try {
            URL url = new URL(urlString);
            this.fScheme = url.getProtocol();
            this.fHostname = url.getHost();
            this.fPort = url.getPort();
            this.fHost = new HttpHost(this.fHostname, this.fPort, this.fScheme);
            this.fPath = url.getPath();
        }
        catch (MalformedURLException e) {
            throw new EGerritException(e.getLocalizedMessage());
        }
    }

    public GerritRepository acceptSelfSignedCerts(boolean accept) {
        this.fAcceptSelfSignedCerts = accept;
        return this;
    }

    public GerritRepository setCredentials(GerritCredentials credentials) {
        this.fCredentials = credentials;
        this.fHttpClient = null;
        return this;
    }

    public Version getVersion() {
        if (this.fVersion == null) {
            this.fVersion = this.queryVersion();
        }
        return this.fVersion;
    }

    public String getScheme() {
        return this.fScheme;
    }

    public HttpHost getHost() {
        return this.fHost;
    }

    public String getPath() {
        return this.fPath;
    }

    public String getHostname() {
        return this.fHost != null ? this.fHost.getHostName() : "";
    }

    public int getPort() {
        return this.fHost != null ? this.fHost.getPort() : -1;
    }

    public GerritCredentials getCredentials() {
        return this.fCredentials;
    }

    public boolean connect() {
        this.fVersion = null;
        this.fHttpClient = this.getHttpClient();
        if (this.fHttpClient != null) {
            this.fVersion = this.queryVersion();
        }
        return this.fVersion != null;
    }

    public GerritHttpClient getHttpClient() {
        if (this.fHttpClient == null) {
            GerritHttpClient client = new GerritHttpClient(this, this.fCredentials);
            if (client.authenticate()) {
                this.fHttpClient = client;
            }
            this.fStatus = client.getStatus();
        }
        return this.fHttpClient;
    }

    public URIBuilder getURIBuilder(boolean requiresAuthentication) {
        StringBuilder sb = new StringBuilder(this.fPath);
        if (requiresAuthentication) {
            sb.append("/a");
        }
        String path = sb.toString();
        URIBuilder builder = new URIBuilder().setScheme(this.fScheme).setHost(this.fHostname).setPath(path);
        if (this.fPort > 0) {
            builder.setPort(this.fPort);
        }
        return builder;
    }

    public GerritServerInformation getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(GerritServerInformation serverInfo) {
        this.serverInfo = serverInfo;
    }

    public Version queryVersion() {
        Version version = null;
        try {
            URIBuilder builder = this.getURIBuilder(false);
            String path = builder.getPath() + VERSION_REQUEST;
            URI uri = builder.setPath(path).build();
            HttpGet request = new HttpGet(uri);
            logger.debug("Request: " + uri.toString());
            ResponseHandler<String> rh = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws IOException {
                    StatusLine statusLine = response.getStatusLine();
                    logger.debug("Result : " + statusLine.toString());
                    int status = statusLine.getStatusCode();
                    if (status < 200 || status >= 300) {
                        throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        throw new ClientProtocolException("Response has no content");
                    }
                    int prefixLength = GerritRepository.JSON_NON_EXECUTABLE_PREFIX.length();
                    String rawResult = EntityUtils.toString((HttpEntity)entity);
                    logger.debug("Server version information is: '" + rawResult + "'");
                    return rawResult.substring(prefixLength + 1, rawResult.length() - 2);
                }
            };
            GerritHttpClient gerritClient = this.getHttpClient();
            if (gerritClient != null) {
                String result = this.getHttpClient().execute((HttpUriRequest)request, rh);
                version = this.parseVersion(result);
            }
        }
        catch (HttpResponseException httpException) {
            if (httpException.getStatusCode() == 404) {
                version = NO_VERSION;
            }
            if (httpException.getStatusCode() != 404) {
                EGerritCorePlugin.logError(httpException.getLocalizedMessage(), httpException);
            }
        }
        catch (SSLHandshakeException e) {
            this.fStatus = -1;
            if (e.getCause().getClass().getName().equals("sun.security.validator.ValidatorException")) {
                this.fStatus = -2;
            }
            EGerritCorePlugin.logError(e.getLocalizedMessage(), e);
        }
        catch (IOException | URISyntaxException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage(), e);
        }
        return version;
    }

    private Version parseVersion(String rawVersion) {
        Matcher matcher = MAJOR_MINOR_MICRO_VERSION_PATTERN.matcher(rawVersion);
        if (matcher.matches()) {
            return new Version(rawVersion);
        }
        matcher = MAJOR_MINOR_QUALIFIER_VERSION_PATTERN.matcher(rawVersion);
        if (matcher.matches()) {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), 0, matcher.group(3));
        }
        matcher = MAJOR_MINOR_MICRO_QUALIFIER_VERSION_PATTERN.matcher(rawVersion);
        if (matcher.matches()) {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4));
        }
        return Version.emptyVersion;
    }

    public GerritClient instantiateGerrit() {
        GerritClient gerrit = null;
        try {
            gerrit = GerritFactory.create(this);
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError(String.valueOf(this.formatGerritVersion()) + e.getLocalizedMessage(), e);
        }
        return gerrit;
    }

    public String formatGerritVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append("Gerrit server: " + (this.serverInfo != null ? this.serverInfo.getServerURI() : "Unknown"));
        sb.append("\nVersion: ");
        String gerritVersion = this.fVersion != null ? this.fVersion.toString() : "Unknown";
        sb.append(gerritVersion);
        sb.append("\n");
        return sb.toString();
    }

    public int getStatus() {
        return this.fStatus;
    }
}

