/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.FilesDialog;
import org.eclipse.egerrit.internal.ui.utils.ActiveWorkspaceRevision;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class OpenFileSelectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ActiveWorkspaceRevision activeRevision = ActiveWorkspaceRevision.getInstance();
        RevisionInfo revInfo = activeRevision.getActiveRevision();
        if (revInfo != null) {
            FilesDialog dialog;
            FileEditorInput fileInput = null;
            IEditorInput editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
            if (editorInput == null && (dialog = FilesDialog.openedDialog()) != null) {
                if (event.getCommand().getId().equals("org.eclipse.egerrit.internal.ui.SelectPreviousFile")) {
                    dialog.selectPreviousFile();
                } else {
                    dialog.selectNextFile();
                }
                return null;
            }
            if (editorInput != null && editorInput instanceof FileEditorInput) {
                fileInput = (FileEditorInput)editorInput;
            }
            FilesDialog filesDialog = new FilesDialog(revInfo, activeRevision.getGerritClient(), fileInput);
            filesDialog.open();
        } else {
            UIUtils.displayInformation(null, Messages.OpenFileProblem, Messages.OpenFileProblemMessage);
        }
        return null;
    }
}

