/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.tabs;

import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.value.SelfValueProperty;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.AddReviewerCommand;
import org.eclipse.egerrit.internal.core.command.DeleteReviewerCommand;
import org.eclipse.egerrit.internal.core.command.SetTopicCommand;
import org.eclipse.egerrit.internal.core.command.SuggestReviewersCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.AddReviewerInput;
import org.eclipse.egerrit.internal.core.rest.AddReviewerResult;
import org.eclipse.egerrit.internal.core.rest.TopicInput;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RelatedChangeAndCommitInfo;
import org.eclipse.egerrit.internal.model.ReviewerInfo;
import org.eclipse.egerrit.internal.model.SuggestReviewerInfo;
import org.eclipse.egerrit.internal.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.egerrit.internal.ui.EGerritUIPlugin;
import org.eclipse.egerrit.internal.ui.editors.ModelLoader;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.editors.model.ChangeDetailEditorInput;
import org.eclipse.egerrit.internal.ui.table.UIConflictsWithTable;
import org.eclipse.egerrit.internal.ui.table.UIRelatedChangesTable;
import org.eclipse.egerrit.internal.ui.table.UIReviewersTable;
import org.eclipse.egerrit.internal.ui.table.UISameTopicTable;
import org.eclipse.egerrit.internal.ui.table.provider.ReviewersTableLabelProvider;
import org.eclipse.egerrit.internal.ui.tabs.ObservableCollector;
import org.eclipse.egerrit.internal.ui.utils.DataConverter;
import org.eclipse.egerrit.internal.ui.utils.LinkDashboard;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class DetailsTabView {
    private final String TITLE = Messages.SummaryTabView_0;
    private static Color RED;
    private final SimpleDateFormat formatTimeOut = new SimpleDateFormat("MMM d, yyyy  hh:mm a");
    private Link genProjectData;
    private Link genBranchData;
    private Text genTopicData;
    private Label genStrategyData;
    private Label genMessageData;
    private Label genUpdatedData;
    private TableViewer tableReviewersViewer;
    private Label genVoteData;
    private Text incBranchesData;
    private Text includedInTagsData;
    private TableViewer tableSameTopicViewer;
    private TableViewer tableRelatedChangesViewer;
    private TableViewer tableConflictsWithViewer;
    private ChangeInfo fChangeInfo;
    private GerritClient fGerritClient;
    private Label lblStrategy;
    private ModelLoader loader;
    private DataBindingContext bindingContext = new DataBindingContext();
    private ObservableCollector observableCollector;
    private Job activeCompletionJob;
    private Button fButtonPlus;

    public void create(GerritClient gerritClient, TabFolder tabFolder, ChangeInfo changeInfo) {
        this.fChangeInfo = changeInfo;
        this.fGerritClient = gerritClient;
        this.createContols(tabFolder);
        this.loader = ModelLoader.initialize(gerritClient, changeInfo);
        this.loader.loadDetailedInformation();
    }

    private void createContols(TabFolder tabFolder) {
        int HEIGHT_FIRST_ROW = UIUtils.computeFontSize((Composite)tabFolder).y * 8;
        final int SCROLL_AREA_HEIGHT = HEIGHT_FIRST_ROW + 300;
        RED = tabFolder.getDisplay().getSystemColor(3);
        TabItem tabSummary = new TabItem(tabFolder, 0);
        tabSummary.setText(Messages.SummaryTabView_1);
        final ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tabFolder, 512);
        scrolledComposite.setExpandHorizontal(false);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinHeight(SCROLL_AREA_HEIGHT);
        scrolledComposite.setLayout((Layout)new FillLayout());
        tabSummary.setControl((Control)scrolledComposite);
        final Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout(6, false));
        Composite general = this.summaryGeneral(composite);
        GridData generalGridData = new GridData(4, 4, true, false, 2, 1);
        generalGridData.heightHint = HEIGHT_FIRST_ROW;
        general.setLayoutData((Object)generalGridData);
        Composite reviewers = this.summaryReviewers(composite);
        GridData reviewersGridData = new GridData(4, 4, true, true, 4, 1);
        reviewersGridData.heightHint = HEIGHT_FIRST_ROW;
        reviewers.setLayoutData((Object)reviewersGridData);
        Composite includedIn = this.summaryIncluded(composite);
        includedIn.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        Composite sameTopic = this.summarySameTopic(composite);
        GridData sameTopicGridData = new GridData(4, 4, true, true, 3, 2);
        sameTopicGridData.heightHint = 150;
        sameTopic.setLayoutData((Object)sameTopicGridData);
        Composite relatedChanges = this.summaryRelatedChanges(composite);
        relatedChanges.setLayoutData((Object)new GridData(4, 4, true, true, 3, 2));
        Composite conflicts = this.summaryConflicts(composite);
        GridData conflictsGridData = new GridData(4, 4, true, true, 3, 1);
        conflictsGridData.heightHint = 150;
        conflicts.setLayoutData((Object)conflictsGridData);
        scrolledComposite.setContent((Control)composite);
        Listener l = new Listener(){

            public void handleEvent(Event e) {
                Point size = scrolledComposite.getSize();
                Point cUnrestrainedSize = composite.computeSize(-1, -1);
                if (size.y >= cUnrestrainedSize.y && size.x >= cUnrestrainedSize.x) {
                    composite.setSize(size);
                    return;
                }
                Rectangle hostRect = scrolledComposite.getBounds();
                int border = scrolledComposite.getBorderWidth();
                if (scrolledComposite.getVerticalBar().isVisible() || size.y <= SCROLL_AREA_HEIGHT) {
                    hostRect.width -= 2 * border;
                    hostRect.width -= scrolledComposite.getVerticalBar().getSize().x;
                }
                hostRect.height -= 2 * border;
                composite.setSize(Math.max(cUnrestrainedSize.x, hostRect.width), Math.max(cUnrestrainedSize.y, hostRect.height));
            }
        };
        scrolledComposite.addListener(11, l);
    }

    private Composite summaryGeneral(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(Messages.SummaryTabView_2);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4));
        Label lblProject = new Label((Composite)composite, 0);
        lblProject.setText(Messages.SummaryTabView_3);
        lblProject.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.genProjectData = new Link((Composite)composite, 0);
        this.genProjectData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.genProjectData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkDashboard linkDash = new LinkDashboard(DetailsTabView.this.fGerritClient);
                linkDash.invokeRefreshDashboardCommand("project", e.text);
            }
        });
        Label lblBranch = new Label((Composite)composite, 0);
        lblBranch.setText(Messages.SummaryTabView_4);
        lblBranch.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.genBranchData = new Link((Composite)composite, 0);
        this.genBranchData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.genBranchData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkDashboard linkDash = new LinkDashboard(DetailsTabView.this.fGerritClient);
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("branch", e.text);
                parameters.put("project", UIUtils.getLinkText(DetailsTabView.this.genProjectData.getText()));
                linkDash.invokeRefreshDashboardCommand(parameters);
            }
        });
        Label lblTopic = new Label((Composite)composite, 0);
        lblTopic.setText(Messages.SummaryTabView_5);
        lblTopic.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.genTopicData = new Text((Composite)composite, 2048);
        this.genTopicData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.genTopicData.setEnabled(this.isEditingAllowed());
        Button btnSave = new Button((Composite)composite, 0);
        btnSave.setText(Messages.SummaryTabView_6);
        btnSave.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        btnSave.addSelectionListener((SelectionListener)this.buttonSaveListener(this.genTopicData));
        btnSave.setEnabled(this.isEditingAllowed());
        this.lblStrategy = new Label((Composite)composite, 0);
        this.lblStrategy.setText(Messages.SummaryTabView_7);
        GridData lblStrategyGridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lblStrategy.setLayoutData((Object)lblStrategyGridData);
        this.genStrategyData = new Label((Composite)composite, 0);
        GridData gd_genStrategyData = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.genStrategyData.setLayoutData((Object)gd_genStrategyData);
        this.genMessageData = new Label((Composite)composite, 0);
        GridData gd_genMessageData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.genMessageData.setLayoutData((Object)gd_genMessageData);
        this.genMessageData.setForeground(RED);
        Label lblUpdated = new Label((Composite)composite, 0);
        lblUpdated.setText(Messages.SummaryTabView_8);
        lblUpdated.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.genUpdatedData = new Label((Composite)composite, 0);
        this.genUpdatedData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sumGenDataBindings();
        this.observableCollector = new ObservableCollector(this.bindingContext);
        return composite;
    }

    private Composite summaryReviewers(Composite group) {
        Group grpReviewers = new Group(group, 0);
        grpReviewers.setText(Messages.SummaryTabView_9);
        grpReviewers.setLayout((Layout)new GridLayout(3, false));
        Label lblVoteSummary = new Label((Composite)grpReviewers, 0);
        lblVoteSummary.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblVoteSummary.setText(Messages.SummaryTabView_10);
        this.genVoteData = new Label((Composite)grpReviewers, 16384);
        this.genVoteData.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        UIReviewersTable uiReviewersTable = new UIReviewersTable();
        uiReviewersTable.createTableViewerSection((Composite)grpReviewers);
        this.tableReviewersViewer = uiReviewersTable.getViewer();
        this.tableReviewersViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        if (!this.fGerritClient.getRepository().getServerInfo().isAnonymous()) {
            this.tableReviewersViewer.getTable().addMouseListener((MouseListener)this.deleteReviewerListener());
        }
        Label lblUserName = new Label((Composite)grpReviewers, 0);
        lblUserName.setText(Messages.SummaryTabView_11);
        lblUserName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        final Text userName = new Text((Composite)grpReviewers, 2048);
        final AddReviewerContentProposal reviewerProposal = new AddReviewerContentProposal(userName);
        userName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        userName.setToolTipText(Messages.SummaryTabView_12);
        userName.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                if (DetailsTabView.this.shouldIgnoreKeyForCompletion(event.keyCode)) {
                    return;
                }
                if (DetailsTabView.this.handleKeyReleased(userName.getText(), reviewerProposal) && event.keyCode == 13) {
                    DetailsTabView.this.fButtonPlus.notifyListeners(13, new Event());
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fButtonPlus = new Button((Composite)grpReviewers, 0);
        this.fButtonPlus.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fButtonPlus.setText("Add");
        this.fButtonPlus.addSelectionListener((SelectionListener)this.buttonPlusListener(this.fButtonPlus, userName));
        this.sumReviewerDataBindings();
        return grpReviewers;
    }

    private boolean handleKeyReleased(String queryText, AddReviewerContentProposal reviewerProposal) {
        if (queryText.length() < 3) {
            if (queryText.isEmpty()) {
                reviewerProposal.setProposals(new String[0]);
                if (this.activeCompletionJob != null) {
                    this.activeCompletionJob.cancel();
                    this.activeCompletionJob = null;
                }
            }
            return false;
        }
        this.runCompletionJob(queryText, reviewerProposal);
        return true;
    }

    private void runCompletionJob(final String queryText, final AddReviewerContentProposal reviewerProposal) {
        if (this.activeCompletionJob != null) {
            this.activeCompletionJob.cancel();
        }
        this.activeCompletionJob = new Job(Messages.SummaryTabView_20){

            protected IStatus run(IProgressMonitor monitor) {
                SuggestReviewersCommand command = DetailsTabView.this.fGerritClient.suggestReviewers(DetailsTabView.this.fChangeInfo.getId());
                command.setMaxNumberOfResults(10);
                command.setQuery(queryText);
                SuggestReviewerInfo[] res = null;
                try {
                    res = (SuggestReviewerInfo[])command.call();
                }
                catch (EGerritException e) {
                    EGerritCorePlugin.logError((String)(String.valueOf(DetailsTabView.this.fGerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
                }
                if (monitor.isCanceled() || res == null) {
                    return Status.OK_STATUS;
                }
                final ArrayList<String> proposals = new ArrayList<String>(res.length);
                SuggestReviewerInfo[] suggestReviewerInfoArray = res;
                int n = res.length;
                int n2 = 0;
                while (n2 < n) {
                    block9: {
                        String idString;
                        block8: {
                            SuggestReviewerInfo info;
                            block7: {
                                info = suggestReviewerInfoArray[n2];
                                if (info.getAccount() == null) break block7;
                                idString = String.valueOf(info.getAccount().getName()) + " <" + info.getAccount().getEmail() + ">";
                                break block8;
                            }
                            if (info.getGroup() == null) break block9;
                            idString = info.getGroup().getId();
                        }
                        proposals.add(idString);
                    }
                    ++n2;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        reviewerProposal.setProposals(proposals.toArray(new String[proposals.size()]));
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.activeCompletionJob.schedule();
    }

    private boolean shouldIgnoreKeyForCompletion(int keyCode) {
        switch (keyCode) {
            case 2: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: 
            case 0x1000009: 
            case 0x100000A: 
            case 0x100000B: 
            case 0x100000C: 
            case 0x100000D: 
            case 0x100000E: 
            case 0x100000F: 
            case 0x1000010: 
            case 0x1000011: 
            case 0x1000012: 
            case 0x1000013: 
            case 0x1000014: 
            case 0x1000015: 
            case 0x1000016: 
            case 0x1000017: 
            case 0x1000018: 
            case 0x1000019: 
            case 0x100001A: 
            case 0x100001B: 
            case 0x100001C: 
            case 0x100001D: 
            case 0x1000051: 
            case 16777298: 
            case 16777299: 
            case 16777300: 
            case 0x1000055: 
            case 16777302: 
            case 16777303: {
                return true;
            }
        }
        return false;
    }

    private Composite summaryIncluded(Composite group) {
        Group grpIncludedIn = new Group(group, 0);
        grpIncludedIn.setText(Messages.SummaryTabView_13);
        grpIncludedIn.setLayout((Layout)new GridLayout(2, false));
        Label lblBranches = new Label((Composite)grpIncludedIn, 131072);
        lblBranches.setText(Messages.SummaryTabView_14);
        lblBranches.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.incBranchesData = new Text((Composite)grpIncludedIn, 2048);
        this.incBranchesData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTags = new Label((Composite)grpIncludedIn, 131072);
        lblTags.setText(Messages.SummaryTabView_15);
        lblTags.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.includedInTagsData = new Text((Composite)grpIncludedIn, 2048);
        this.includedInTagsData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.sumIncludedDataBindings();
        return grpIncludedIn;
    }

    private Composite summarySameTopic(Composite group) {
        Group grpSameTopic = new Group(group, 0);
        grpSameTopic.setText(Messages.SummaryTabView_16);
        grpSameTopic.setLayout((Layout)new FillLayout());
        UISameTopicTable tableUISameTopic = new UISameTopicTable();
        tableUISameTopic.createTableViewerSection((Composite)grpSameTopic);
        this.tableSameTopicViewer = tableUISameTopic.getViewer();
        this.tableSameTopicViewer.addDoubleClickListener(this.doubleClickSelectionChangeListener());
        this.sumSameTopicDataBindings();
        return grpSameTopic;
    }

    private Composite summaryRelatedChanges(Composite group) {
        Group grpRelatedChanges = new Group(group, 0);
        grpRelatedChanges.setText(Messages.SummaryTabView_17);
        grpRelatedChanges.setLayout((Layout)new FillLayout());
        UIRelatedChangesTable tableUIRelatedChanges = new UIRelatedChangesTable();
        tableUIRelatedChanges.createTableViewerSection((Composite)grpRelatedChanges);
        this.tableRelatedChangesViewer = tableUIRelatedChanges.getViewer();
        this.tableRelatedChangesViewer.addDoubleClickListener(this.doubleClickSelectionChangeListener());
        this.sumRelatedChangesDataBindings();
        return grpRelatedChanges;
    }

    private Composite summaryConflicts(Composite group) {
        Group grpConflictsWith = new Group(group, 0);
        grpConflictsWith.setText(Messages.SummaryTabView_18);
        grpConflictsWith.setLayout((Layout)new FillLayout());
        UIConflictsWithTable tableUIConflictsWith = new UIConflictsWithTable();
        tableUIConflictsWith.createTableViewerSection((Composite)grpConflictsWith);
        this.tableConflictsWithViewer = tableUIConflictsWith.getViewer();
        this.tableConflictsWithViewer.addDoubleClickListener(this.doubleClickSelectionChangeListener());
        this.sumConflictWithDataBindings();
        return grpConflictsWith;
    }

    private IDoubleClickListener doubleClickSelectionChangeListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RelatedChangeAndCommitInfo relChangeInfo;
                StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
                Object element = structuredSelection.getFirstElement();
                String changeId = null;
                String subject = null;
                if (element instanceof ChangeInfo) {
                    ChangeInfo changeInfo = (ChangeInfo)element;
                    changeId = changeInfo.getId();
                    if (changeId == null) {
                        subject = changeInfo.getSubject();
                    }
                } else if (element instanceof RelatedChangeAndCommitInfo && (changeId = (relChangeInfo = (RelatedChangeAndCommitInfo)element).get_change_number()) == null) {
                    subject = relChangeInfo.getCommit().getSubject();
                }
                DetailsTabView.this.createDetailEditor(changeId, subject);
            }
        };
    }

    private void createDetailEditor(String changeId, String subject) {
        ChangeInfo changeInfo = null;
        if (changeId != null) {
            changeInfo = QueryHelpers.lookupPartialChangeInfoFromChangeId(this.fGerritClient, changeId, (IProgressMonitor)new NullProgressMonitor());
        } else if (subject != null) {
            ChangeInfo[] arrayChangeInfo = null;
            try {
                arrayChangeInfo = QueryHelpers.lookupPartialChangeInfoFromSubject(this.fGerritClient, subject, (IProgressMonitor)new NullProgressMonitor());
                if (arrayChangeInfo.length >= 1) {
                    changeInfo = arrayChangeInfo[0];
                }
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        IWorkbench workbench = EGerritUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (window != null) {
            page = workbench.getActiveWorkbenchWindow().getActivePage();
        }
        if (page != null && changeInfo != null) {
            try {
                page.openEditor((IEditorInput)new ChangeDetailEditorInput(this.fGerritClient, changeInfo), "org.eclipse.egerrit.ui.editors.ChangeDetailEditor");
            }
            catch (PartInitException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
            }
        }
    }

    private SelectionAdapter buttonPlusListener(final Button buttonPlus, final Text textWidget) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                String reviewer = textWidget.getText().trim();
                if (!reviewer.isEmpty()) {
                    AddReviewerCommand addReviewerCmd = DetailsTabView.this.fGerritClient.addReviewer(DetailsTabView.this.fChangeInfo.getId());
                    AddReviewerInput addReviewerInput = new AddReviewerInput();
                    addReviewerInput.setReviewer(reviewer);
                    addReviewerCmd.setCommandInput((Object)addReviewerInput);
                    AddReviewerResult reviewerCmdResult = null;
                    reviewerCmdResult = this.addReviewerRequest(addReviewerCmd, addReviewerInput, reviewerCmdResult);
                    if (reviewerCmdResult != null && reviewerCmdResult.getConfirm()) {
                        if (!MessageDialog.openConfirm((Shell)buttonPlus.getParent().getShell(), (String)Messages.SummaryTabView_19, (String)reviewerCmdResult.getError())) {
                            return;
                        }
                        addReviewerInput.setConfirmed(Boolean.valueOf(true));
                        reviewerCmdResult = this.addReviewerRequest(addReviewerCmd, addReviewerInput, reviewerCmdResult);
                    }
                    if (reviewerCmdResult != null) {
                        DetailsTabView.this.fChangeInfo.getComputedReviewers().addAll((Collection)reviewerCmdResult.getReviewers());
                    }
                    DetailsTabView.this.loader.reload();
                    textWidget.setText("");
                }
            }

            private AddReviewerResult addReviewerRequest(AddReviewerCommand addReviewerCmd, AddReviewerInput input, AddReviewerResult reviewerCmdResult) {
                try {
                    reviewerCmdResult = (AddReviewerResult)addReviewerCmd.call();
                }
                catch (EGerritException e3) {
                    if (e3.getCode() == 1) {
                        String message = String.valueOf(input.getReviewer()) + Messages.SummaryTabView_21;
                        UIUtils.displayInformation(null, DetailsTabView.this.TITLE, message);
                    }
                    EGerritCorePlugin.logError((String)(String.valueOf(DetailsTabView.this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
                }
                return reviewerCmdResult;
            }
        };
    }

    private MouseAdapter deleteReviewerListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IStructuredSelection structuredSelection;
                Object element;
                ISelection selection;
                ViewerCell viewerCell = DetailsTabView.this.tableReviewersViewer.getCell(new Point(e.x, e.y));
                if (viewerCell != null && viewerCell.getColumnIndex() == 0 && (selection = DetailsTabView.this.tableReviewersViewer.getSelection()) instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ReviewerInfo) {
                    ReviewerInfo reviewerInfo = (ReviewerInfo)element;
                    if (!MessageDialog.openConfirm((Shell)DetailsTabView.this.tableReviewersViewer.getTable().getShell(), (String)Messages.SummaryTabView_22, (String)(String.valueOf(Messages.SummaryTabView_23) + reviewerInfo.getName() + Messages.SummaryTabView_24))) {
                        return;
                    }
                    DeleteReviewerCommand deleteReviewerCmd = DetailsTabView.this.fGerritClient.deleteReviewer(DetailsTabView.this.fChangeInfo.getId(), String.valueOf(reviewerInfo.get_account_id()));
                    try {
                        deleteReviewerCmd.call();
                        DetailsTabView.this.fChangeInfo.getComputedReviewers().remove((Object)reviewerInfo);
                    }
                    catch (EGerritException e3) {
                        EGerritCorePlugin.logError((String)(String.valueOf(DetailsTabView.this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
                    }
                    DetailsTabView.this.loader.reload();
                }
            }
        };
    }

    private SelectionAdapter buttonSaveListener(final Text topicData) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                String topic = topicData.getText().trim();
                DetailsTabView.this.setTopic(topic);
                LinkDashboard linkDash = new LinkDashboard(DetailsTabView.this.fGerritClient);
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("branch", DetailsTabView.this.fChangeInfo.getBranch());
                parameters.put("project", UIUtils.getLinkText(DetailsTabView.this.genProjectData.getText()));
                linkDash.invokeRefreshDashboardCommand(parameters);
            }
        };
    }

    private void setTopic(String topic) {
        SetTopicCommand command = this.fGerritClient.setTopic(this.fChangeInfo.getChange_id());
        TopicInput topicInput = new TopicInput();
        if (topic != null) {
            topicInput.setTopic(topic);
        } else {
            topicInput.setTopic("");
        }
        command.setCommandInput((Object)topicInput);
        try {
            command.call();
        }
        catch (EGerritException ex) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + ex.getMessage()));
        }
    }

    protected DataBindingContext sumGenDataBindings() {
        IObservableValue projectbytesFChangeInfoObserveValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__PROJECT).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.genProjectData), projectbytesFChangeInfoObserveValue, null, new UpdateValueStrategy().setConverter(DataConverter.linkText()));
        IObservableValue branchFChangeInfoObserveValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__BRANCH).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.genBranchData), branchFChangeInfoObserveValue, null, new UpdateValueStrategy().setConverter(DataConverter.linkText()));
        IObservableValue topicFChangeInfoObserveValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__TOPIC).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.genTopicData), topicFChangeInfoObserveValue, null, null);
        IObservableValue updatedFChangeInfoObserveValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__UPDATED).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.genUpdatedData), updatedFChangeInfoObserveValue, null, new UpdateValueStrategy().setConverter(DataConverter.gerritTimeConverter(this.formatTimeOut)));
        IObservableValue mergeSubmitValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__MERGEABLE_INFO).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.genStrategyData), mergeSubmitValue, null, new UpdateValueStrategy().setConverter(DataConverter.submitTypeConverter(this.fChangeInfo)));
        IObservableValue mergeableMergeableInfoObserveValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__MERGEABLE).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.genMessageData), mergeableMergeableInfoObserveValue, null, new UpdateValueStrategy().setConverter(DataConverter.cannotMergeConverter()));
        UpdateValueStrategy hideWidgetsStrategy = new UpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                Boolean visible = Boolean.TRUE;
                if ("MERGED".equals(value) || "ABANDONED".equals(value)) {
                    visible = Boolean.FALSE;
                    Widget w = ((ISWTObservable)observableValue).getWidget();
                    if (!w.isDisposed() && w instanceof Control) {
                        ((GridData)((Control)w).getLayoutData()).exclude = !((Control)w).isVisible();
                        ((Control)w).getParent().pack(true);
                    }
                }
                IStatus status = super.doSet(observableValue, (Object)visible);
                return status;
            }
        };
        IObservableValue observeChangeInfoStatus = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__STATUS).observe((Object)this.fChangeInfo);
        ISWTObservableValue observeGenDataVisibility = WidgetProperties.visible().observe((Widget)this.genMessageData);
        this.bindingContext.bindValue((IObservableValue)observeGenDataVisibility, observeChangeInfoStatus, null, hideWidgetsStrategy);
        ISWTObservableValue observeGenStrategyDataVisibility = WidgetProperties.visible().observe((Widget)this.genStrategyData);
        this.bindingContext.bindValue((IObservableValue)observeGenStrategyDataVisibility, observeChangeInfoStatus, null, hideWidgetsStrategy);
        ISWTObservableValue observeStrategyLabelVisibility = WidgetProperties.visible().observe((Widget)this.lblStrategy);
        this.bindingContext.bindValue((IObservableValue)observeStrategyLabelVisibility, observeChangeInfoStatus, null, hideWidgetsStrategy);
        return this.bindingContext;
    }

    protected void sumReviewerDataBindings() {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableReviewersViewer.setContentProvider((IContentProvider)contentProvider);
        IObservableMap[] watchedProperties = Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{new SelfValueProperty((Object)"x"), EMFProperties.value((EStructuralFeature)ModelPackage.Literals.REVIEWER_INFO__NAME), EMFProperties.value((EStructuralFeature)ModelPackage.Literals.REVIEWER_INFO__EMAIL)});
        this.tableReviewersViewer.setLabelProvider((IBaseLabelProvider)new ReviewersTableLabelProvider(watchedProperties));
        this.tableReviewersViewer.setInput((Object)EMFProperties.list((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__COMPUTED_REVIEWERS).observe((Object)this.fChangeInfo));
        final IObservableList observedList = EMFObservables.observeList((EObject)this.fChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__COMPUTED_REVIEWERS);
        ComputedValue<String> cv = new ComputedValue<String>(){

            protected String calculate() {
                HashMap<String, Integer> hashMap = this.extractAllVotesSummary((IObservableList<ReviewerInfo>)observedList);
                return this.formatReviewersVote(hashMap);
            }

            private String formatReviewersVote(HashMap<String, Integer> hashMap) {
                TreeMap<String, Integer> sortedMap = new TreeMap<String, Integer>(hashMap);
                StringBuilder sb = new StringBuilder();
                if (!sortedMap.isEmpty()) {
                    Iterator iterSorted = sortedMap.entrySet().iterator();
                    while (iterSorted.hasNext()) {
                        String vote = "";
                        Map.Entry entry = iterSorted.next();
                        if ((Integer)entry.getValue() > 0) {
                            vote = "+";
                        }
                        vote = vote.concat(Integer.toString((Integer)entry.getValue()));
                        sb.append((String)entry.getKey());
                        sb.append(": ");
                        sb.append(vote);
                        sb.append("  ");
                    }
                }
                return sb.toString().trim();
            }

            private HashMap<String, Integer> extractAllVotesSummary(IObservableList<ReviewerInfo> observedList2) {
                EMap allVotes = DetailsTabView.this.fChangeInfo.getLabels();
                HashMap<String, Integer> mostRevelantVotesPerLabel = new HashMap<String, Integer>();
                if (allVotes == null) {
                    return mostRevelantVotesPerLabel;
                }
                for (String aLabel : allVotes.keySet()) {
                    mostRevelantVotesPerLabel.put(aLabel, DetailsTabView.this.fChangeInfo.getMostRelevantVote(aLabel).getValue());
                }
                return mostRevelantVotesPerLabel;
            }
        };
        ISWTObservableValue o = WidgetProperties.text().observe((Widget)this.genVoteData);
        this.bindingContext.bindValue((IObservableValue)o, (IObservableValue)cv, null, null);
    }

    protected void sumIncludedDataBindings() {
        this.hookBranches();
        this.hookTags();
    }

    private void hookTags() {
        FeaturePath fp = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__INCLUDED_IN, ModelPackage.Literals.INCLUDED_IN_INFO__TAGS});
        IEMFListProperty includedTags = EMFProperties.list((FeaturePath)fp);
        final IObservableList observedTags = includedTags.observe((Object)this.fChangeInfo);
        ComputedValue<String> cv = new ComputedValue<String>(){

            protected String calculate() {
                Iterator it = observedTags.iterator();
                String result = "";
                while (it.hasNext()) {
                    Object object = it.next();
                    result = String.valueOf(result) + object.toString() + ", ";
                }
                if (!result.isEmpty()) {
                    int last = result.lastIndexOf(",");
                    result = result.substring(0, last);
                }
                return result;
            }
        };
        ISWTObservableValue o = WidgetProperties.text().observe((Widget)this.includedInTagsData);
        this.bindingContext.bindValue((IObservableValue)o, (IObservableValue)cv, null, null);
    }

    private void hookBranches() {
        FeaturePath fp = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__INCLUDED_IN, ModelPackage.Literals.INCLUDED_IN_INFO__BRANCHES});
        IEMFListProperty includedInBranches = EMFProperties.list((FeaturePath)fp);
        final IObservableList observedBranches = includedInBranches.observe((Object)this.fChangeInfo);
        ComputedValue<String> cv = new ComputedValue<String>(){

            protected String calculate() {
                Iterator it = observedBranches.iterator();
                String result = "";
                while (it.hasNext()) {
                    Object object = it.next();
                    result = String.valueOf(result) + object.toString() + ", ";
                }
                if (!result.isEmpty()) {
                    int last = result.lastIndexOf(",");
                    result = result.substring(0, last);
                }
                return result;
            }
        };
        ISWTObservableValue o = WidgetProperties.text().observe((Widget)this.incBranchesData);
        this.bindingContext.bindValue((IObservableValue)o, (IObservableValue)cv, null, null);
    }

    protected void sumSameTopicDataBindings() {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ModelItemProviderAdapterFactory());
        this.tableSameTopicViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)composedAdapterFactory));
        this.tableSameTopicViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory));
        IObservableList observedList = EMFObservables.observeList((EObject)this.fChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__SAME_TOPIC);
        ViewerSupport.bind((StructuredViewer)this.tableSameTopicViewer, (IObservableList)observedList, (IValueProperty[])new IValueProperty[]{EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__NUMBER), EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__SUBJECT)});
    }

    protected void sumRelatedChangesDataBindings() {
        FeaturePath properties = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__RELATED_CHANGES, ModelPackage.Literals.RELATED_CHANGES_INFO__CHANGES});
        IObservableList relatedChanges = EMFProperties.list((FeaturePath)properties).observe((Object)this.fChangeInfo);
        FeaturePath commitSubject = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.RELATED_CHANGE_AND_COMMIT_INFO__COMMIT, ModelPackage.Literals.COMMIT_INFO__SUBJECT});
        IValueProperty[] valuesPresented = new IValueProperty[]{EMFProperties.value((EStructuralFeature)ModelPackage.Literals.RELATED_CHANGE_AND_COMMIT_INFO__CHANGE_NUMBER), EMFProperties.value((FeaturePath)commitSubject)};
        ViewerSupport.bind((StructuredViewer)this.tableRelatedChangesViewer, (IObservableList)relatedChanges, (IValueProperty[])valuesPresented);
    }

    protected void sumConflictWithDataBindings() {
        IObservableList observedList = EMFObservables.observeList((EObject)this.fChangeInfo, (EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__CONFLICTS_WITH);
        ViewerSupport.bind((StructuredViewer)this.tableConflictsWithViewer, (IObservableList)observedList, (IValueProperty[])new IValueProperty[]{EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__NUMBER), EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__SUBJECT)});
    }

    private boolean isEditingAllowed() {
        return !this.fGerritClient.getRepository().getServerInfo().isAnonymous();
    }

    public void dispose() {
        this.observableCollector.dispose();
        this.bindingContext.dispose();
        this.loader.dispose();
    }

    private class AddReviewerContentProposal {
        private SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(new String[0]);
        private ReviewerContentProposalAdapter contentAdapter;

        public AddReviewerContentProposal(Text control) {
            this.proposalProvider.setFiltering(false);
            this.contentAdapter = new ReviewerContentProposalAdapter(control, (IContentProposalProvider)this.proposalProvider);
        }

        public void setProposals(String[] proposals) {
            this.proposalProvider.setProposals(proposals);
            this.contentAdapter.refreshProposalPopup();
        }

        private class ReviewerContentProposalAdapter
        extends ContentProposalAdapter {
            public ReviewerContentProposalAdapter(Text control, IContentProposalProvider proposalProvider) {
                super((Control)control, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, null, null);
                this.setPropagateKeys(true);
                this.setProposalAcceptanceStyle(2);
            }

            public void refreshProposalPopup() {
                this.closeProposalPopup();
                this.openProposalPopup();
            }
        }
    }
}

