/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByUnboundSubstitutor;

public class ClosureWithoutExpectationHelper
extends AbstractClosureTypeHelper {
    private List<JvmFormalParameter> implicitParameters;
    private final FunctionTypes functionTypes = this.getServices().getFunctionTypes();

    protected ClosureWithoutExpectationHelper(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        super(closure, expectation, state);
    }

    @Override
    protected void computeTypes() {
        FunctionTypeReference incompleteClosureType = this.getFunctionTypeReference(true);
        ITypeAssigner typeAssigner = this.getState().withoutRootExpectation().assignTypes();
        ITypeComputationState closureBodyTypeComputationState = this.getClosureBodyTypeComputationState(typeAssigner, incompleteClosureType);
        ITypeComputationResult expressionResult = closureBodyTypeComputationState.computeTypes(this.getClosure().getExpression());
        FunctionTypeReference resultClosureType = this.processExpressionType(incompleteClosureType, expressionResult);
        this.getExpectation().acceptActualType((LightweightTypeReference)resultClosureType, 0x400000);
    }

    @Override
    public FunctionTypeReference getExpectedClosureType() {
        return this.getFunctionTypeReference(true);
    }

    @Override
    public JvmOperation getOperation() {
        JvmOperation result = this.functionTypes.findImplementingOperation(this.getExpectedClosureType());
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    protected FunctionTypeReference getFunctionTypeReference(boolean isProcedure) {
        XClosure closure = this.getClosure();
        ITypeReferenceOwner referenceOwner = this.getExpectation().getReferenceOwner();
        if (closure.isExplicitSyntax()) {
            int parameters = closure.getDeclaredFormalParameters().size();
            FunctionTypeReference result = this.functionTypes.createRawFunctionTypeRef(referenceOwner, closure, parameters, isProcedure);
            this.initClosureType(result, isProcedure);
            return result;
        }
        FunctionTypeReference result = this.functionTypes.createRawFunctionTypeRef(referenceOwner, closure, 1, isProcedure);
        this.initClosureType(result, isProcedure);
        return result;
    }

    protected void initClosureType(FunctionTypeReference result, boolean isProcedure) {
        ITypeReferenceOwner owner = result.getOwner();
        TypeParameterByUnboundSubstitutor substitutor = new TypeParameterByUnboundSubstitutor(Collections.emptyMap(), owner){

            @Override
            protected UnboundTypeReference createUnboundTypeReference(JvmTypeParameter type) {
                UnboundTypeReference result = ClosureWithoutExpectationHelper.this.getExpectation().createUnboundTypeReference(ClosureWithoutExpectationHelper.this.getClosure(), type);
                return result;
            }
        };
        JvmGenericType type = (JvmGenericType)result.getType();
        EList typeParameters = type.getTypeParameters();
        int max = type.getTypeParameters().size();
        if (!isProcedure) {
            --max;
        }
        int i = 0;
        while (i < max) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)typeParameters.get(i);
            ParameterizedTypeReference parameterType = owner.newParameterizedTypeReference((JvmType)typeParameter);
            LightweightTypeReference substituted = substitutor.substitute(parameterType);
            result.addTypeArgument(substituted);
            ++i;
        }
        if (!isProcedure) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)typeParameters.get(max);
            LightweightTypeReference parameterType = owner.toLightweightTypeReference((JvmType)typeParameter);
            LightweightTypeReference substituted = substitutor.substitute(parameterType);
            result.addTypeArgument(substituted);
        }
    }

    protected ITypeComputationState getClosureBodyTypeComputationState(ITypeAssigner typeAssigner, FunctionTypeReference incompleteClosureType) {
        ITypeComputationState result = this.assignParameters(typeAssigner, incompleteClosureType);
        result.withinScope(this.getClosure());
        return result;
    }

    @Override
    public List<JvmFormalParameter> getParameters() {
        XClosure closure = this.getClosure();
        if (closure.isExplicitSyntax()) {
            return closure.getDeclaredFormalParameters();
        }
        if (this.implicitParameters != null) {
            return this.implicitParameters;
        }
        return closure.getImplicitFormalParameters();
    }

    protected ITypeComputationState assignParameters(ITypeAssigner typeAssigner, FunctionTypeReference incompleteClosureType) {
        List<LightweightTypeReference> operationParameterTypes = incompleteClosureType.getTypeArguments();
        XClosure closure = this.getClosure();
        boolean explicit = closure.isExplicitSyntax();
        if (explicit || !closure.getImplicitFormalParameters().isEmpty()) {
            JvmFormalParameter closureParameter;
            EList<JvmFormalParameter> closureParameters = explicit ? closure.getDeclaredFormalParameters() : closure.getImplicitFormalParameters();
            int paramCount = Math.min(closureParameters.size(), operationParameterTypes.size());
            int i = 0;
            while (i < paramCount) {
                closureParameter = (JvmFormalParameter)closureParameters.get(i);
                LightweightTypeReference operationParameterType = operationParameterTypes.get(i);
                if (explicit && closureParameter.getParameterType() != null) {
                    LightweightTypeReference closureParameterType = typeAssigner.toLightweightTypeReference(closureParameter.getParameterType());
                    new DeferredTypeParameterHintCollector(this.getExpectation().getReferenceOwner()){

                        @Override
                        protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                            LightweightTypeReference wrapped = reference.getWrapperTypeIfPrimitive();
                            typeParameter.acceptHint(wrapped, BoundTypeArgumentSource.RESOLVED, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
                        }
                    }.processPairedReferences(operationParameterType, closureParameterType);
                    typeAssigner.assignType((JvmIdentifiableElement)closureParameter, closureParameterType);
                    incompleteClosureType.addParameterType(closureParameterType);
                } else {
                    typeAssigner.assignType((JvmIdentifiableElement)closureParameter, operationParameterType);
                    incompleteClosureType.addParameterType(operationParameterType);
                }
                ++i;
            }
            i = paramCount;
            while (i < closureParameters.size()) {
                closureParameter = (JvmFormalParameter)closureParameters.get(i);
                JvmTypeReference parameterType = closureParameter.getParameterType();
                if (parameterType != null) {
                    LightweightTypeReference lightweight = typeAssigner.toLightweightTypeReference(parameterType);
                    typeAssigner.assignType((JvmIdentifiableElement)closureParameter, lightweight);
                } else {
                    LightweightTypeReference objectType = typeAssigner.toLightweightTypeReference(this.getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)closureParameter, new JvmTypeReference[0]));
                    typeAssigner.assignType((JvmIdentifiableElement)closureParameter, objectType);
                }
                ++i;
            }
            ITypeComputationState result = typeAssigner.getForkedState();
            return result;
        }
        if (operationParameterTypes.size() != 1) {
            throw new IllegalStateException();
        }
        JvmFormalParameter implicitParameter = TypesFactory.eINSTANCE.createJvmFormalParameter();
        implicitParameter.setName(IFeatureNames.IT.getFirstSegment());
        this.implicitParameters = Collections.singletonList(implicitParameter);
        LightweightTypeReference operationParameterType = operationParameterTypes.get(0);
        typeAssigner.assignType((JvmIdentifiableElement)implicitParameter, operationParameterType);
        incompleteClosureType.addParameterType(operationParameterType);
        ITypeComputationState result = typeAssigner.getForkedState();
        return result;
    }

    protected FunctionTypeReference processExpressionType(FunctionTypeReference incompleteClosureType, ITypeComputationResult expressionResult) {
        LightweightTypeReference expressionResultType = expressionResult.getReturnType();
        if (expressionResultType == null || !expressionResultType.isPrimitiveVoid()) {
            FunctionTypeReference result = this.getFunctionTypeReference(false);
            LightweightTypeReference expectedReturnType = result.getTypeArguments().get(result.getTypeArguments().size() - 1);
            if (expressionResultType != null && !expressionResultType.isAny()) {
                result.setReturnType(expressionResultType);
                this.deferredBindTypeArgument(expectedReturnType, expressionResultType, BoundTypeArgumentSource.INFERRED);
            } else {
                JvmType objectType = this.getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)incompleteClosureType.getType());
                LightweightTypeReference objectTypeReference = objectType != null ? incompleteClosureType.getOwner().newParameterizedTypeReference(objectType) : incompleteClosureType.getOwner().newUnknownTypeReference(Object.class.getName());
                result.setReturnType(objectTypeReference);
                this.deferredBindTypeArgument(expectedReturnType, objectTypeReference, BoundTypeArgumentSource.INFERRED);
            }
            List<LightweightTypeReference> incompleteParameterTypes = incompleteClosureType.getParameterTypes();
            int i = 0;
            while (i < incompleteParameterTypes.size()) {
                result.addParameterType(incompleteParameterTypes.get(i));
                ++i;
            }
            List<LightweightTypeReference> incompleteTypeArguments = incompleteClosureType.getTypeArguments();
            List<LightweightTypeReference> resultTypeArguments = result.getTypeArguments();
            int i2 = 0;
            while (i2 < incompleteTypeArguments.size()) {
                this.deferredBindTypeArgument(resultTypeArguments.get(i2), incompleteTypeArguments.get(i2), BoundTypeArgumentSource.INFERRED);
                ++i2;
            }
            return result;
        }
        incompleteClosureType.setReturnType(expressionResultType);
        return incompleteClosureType;
    }
}

