/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.util.Hashtable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;

public class DebugOptions
implements DebugOptionsListener {
    public static boolean DEBUG = false;
    public static boolean DEBUG_COMMANDS = false;
    public static boolean DEBUG_EVENTS = false;
    static final String DEBUG_FLAG = "org.eclipse.debug.core/debug";
    static final String DEBUG_FLAG_COMMANDS = "org.eclipse.debug.core/debug/commands";
    static final String DEBUG_FLAG_EVENTS = "org.eclipse.debug.core/debug/events";
    private static DebugTrace fgDebugTrace;

    public DebugOptions(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", DebugPlugin.getUniqueIdentifier());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void optionsChanged(org.eclipse.osgi.service.debug.DebugOptions options) {
        fgDebugTrace = options.newDebugTrace(DebugPlugin.getUniqueIdentifier());
        DEBUG = options.getBooleanOption(DEBUG_FLAG, false);
        DEBUG_COMMANDS = DEBUG & options.getBooleanOption(DEBUG_FLAG_COMMANDS, false);
        DEBUG_EVENTS = DEBUG & options.getBooleanOption(DEBUG_FLAG_EVENTS, false);
    }

    public static void trace(String option, String message, Throwable throwable) {
        System.out.println(message);
        if (fgDebugTrace != null) {
            fgDebugTrace.trace(option, message, throwable);
        }
    }

    public static void trace(String message) {
        DebugOptions.trace(null, message, null);
    }
}

