/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jmerge;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jmerge.JControlModel;
import org.eclipse.emf.codegen.jmerge.JPatternDictionary;
import org.eclipse.emf.codegen.jmerge.PropertyMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMInitializer;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMPackage;
import org.eclipse.jdt.core.jdom.IDOMType;

@Deprecated
public class JMerger {
    protected DOMFactory jdomFactory = new DOMFactory();
    protected JControlModel jControlModel;
    protected IDOMCompilationUnit sourceCompilationUnit;
    protected IDOMCompilationUnit targetCompilationUnit;
    protected JPatternDictionary sourcePatternDictionary;
    protected JPatternDictionary targetPatternDictionary;
    protected Map sourceToTargetMap = new HashMap();
    protected Map targetToSourceMap = new HashMap();
    protected Map orderedSourceChildrenMap = new HashMap();
    protected boolean isBlocked;
    protected boolean fixInterfaceBrace;
    protected static final Pattern INTERFACE_BRACE_PATTERN = Pattern.compile("(?:\\n\\r|\\r\\n|\\n|\\r)(\\s*)(?:public|private|protected|static|\\s)*(?:interface|class)\\s*[^\\{\\n\\r]*(\\{)(\\n\\r|\\r\\n|\\n|\\r)", 8);
    protected static Object[] noArguments = new Object[0];

    public JMerger() {
        if ("1.4".compareTo(JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source")) < 0) {
            CodeGenPlugin.INSTANCE.log(CodeGenPlugin.INSTANCE.getString("_UI_JDOMInvalidSourceCompatibility_message"));
        }
    }

    public JMerger(JControlModel jControlModel, IDOMCompilationUnit sourceCompilationUnit, IDOMCompilationUnit targetCompilationUnit) {
        this();
        this.jControlModel = jControlModel;
        this.setSourceCompilationUnit(sourceCompilationUnit);
        this.setTargetCompilationUnit(targetCompilationUnit);
    }

    public void merge() {
        this.pullTargetCompilationUnit();
        if (!this.isBlocked) {
            this.pushSourceCompilationUnit();
            this.sweepTargetCompilationUnit();
            this.sortTargetCompilationUnit();
        }
    }

    public void remerge() {
        this.sourceToTargetMap.clear();
        this.targetToSourceMap.clear();
        this.orderedSourceChildrenMap.clear();
        this.isBlocked = false;
        this.merge();
    }

    public boolean isFixInterfaceBrace() {
        return this.fixInterfaceBrace;
    }

    public void setFixInterfaceBrace(boolean fixInterfaceBrace) {
        this.fixInterfaceBrace = fixInterfaceBrace;
    }

    public JControlModel getControlModel() {
        return this.jControlModel;
    }

    public void setControlModel(JControlModel jControlModel) {
        this.jControlModel = jControlModel;
    }

    public String getSourceCompilationUnitContents() {
        return this.sourceCompilationUnit.getContents();
    }

    public IDOMCompilationUnit getSourceCompilationUnit() {
        return this.sourceCompilationUnit;
    }

    public void setSourceCompilationUnit(IDOMCompilationUnit sourceCompilationUnit) {
        this.sourceCompilationUnit = sourceCompilationUnit;
        this.sourcePatternDictionary = new JPatternDictionary(sourceCompilationUnit, this.jControlModel);
    }

    public String getTargetCompilationUnitContents() {
        String result = this.targetCompilationUnit.getContents();
        if (this.fixInterfaceBrace) {
            Matcher matcher = INTERFACE_BRACE_PATTERN.matcher(result);
            int offset = 0;
            while (matcher.find()) {
                if (this.getControlModel().convertToStandardBraceStyle()) {
                    if (result.charAt(matcher.start(2) - 1) == ' ') continue;
                    result = String.valueOf(result.substring(0, offset + matcher.start(2))) + " {" + result.substring(offset + matcher.end(2), result.length());
                    ++offset;
                    continue;
                }
                result = String.valueOf(result.substring(0, offset + matcher.start(2))) + matcher.group(3) + matcher.group(1) + "{" + result.substring(offset + matcher.end(2), result.length());
                offset += matcher.group(1).length() + matcher.group(3).length();
            }
        }
        return result;
    }

    public IDOMCompilationUnit getTargetCompilationUnit() {
        return this.targetCompilationUnit;
    }

    public void setTargetCompilationUnit(IDOMCompilationUnit targetCompilationUnit) {
        this.targetCompilationUnit = targetCompilationUnit;
        this.targetPatternDictionary = new JPatternDictionary(targetCompilationUnit, this.jControlModel);
    }

    public JPatternDictionary getSourcePatternDictionary() {
        return this.sourcePatternDictionary;
    }

    public void setSourcePatternDictionary(JPatternDictionary sourcePatternDictionary) {
        this.sourcePatternDictionary = sourcePatternDictionary;
    }

    public JPatternDictionary getTargetPatternDictionary() {
        return this.targetPatternDictionary;
    }

    public void setTargetPatternDictionary(JPatternDictionary targetPatternDictionary) {
        this.targetPatternDictionary = targetPatternDictionary;
    }

    public Map getSourceToTargetMap() {
        return this.sourceToTargetMap;
    }

    public void setSourceToTargetMap(Map sourceToTargetMap) {
        this.sourceToTargetMap = sourceToTargetMap;
    }

    public IDOMCompilationUnit createCompilationUnitForURI(String uri) {
        try {
            URL url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException exception) {
                url = new URL("file:" + uri);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return this.jdomFactory.createCompilationUnit(new String(input), url.toString());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IDOMCompilationUnit createCompilationUnitForInputStream(InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return this.jdomFactory.createCompilationUnit(new String(input), "NAME");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IDOMCompilationUnit createCompilationUnitForContents(String contents) {
        return this.jdomFactory.createCompilationUnit(contents, "NAME");
    }

    protected void pullTargetCompilationUnit() {
        if (this.targetCompilationUnit == null) {
            this.setTargetCompilationUnit((IDOMCompilationUnit)this.insertClone((IDOMNode)this.sourceCompilationUnit));
        } else {
            this.map((IDOMNode)this.sourceCompilationUnit, (IDOMNode)this.targetCompilationUnit);
            this.applyPullRules((IDOMNode)this.sourceCompilationUnit, (IDOMNode)this.targetCompilationUnit);
            IDOMNode child = this.targetCompilationUnit.getFirstChild();
            while (child != null) {
                switch (child.getNodeType()) {
                    case 2: {
                        this.pullTargetPackage((IDOMPackage)child);
                        break;
                    }
                    case 3: {
                        this.pullTargetImport((IDOMImport)child);
                        break;
                    }
                    case 4: {
                        IDOMType type = (IDOMType)child;
                        boolean bl = this.isBlocked = this.jControlModel.getBlockPattern() != null && type.getComment() != null && this.jControlModel.getBlockPattern().matcher(type.getComment()).find();
                        if (this.isBlocked) break;
                        this.pullTargetType(type);
                    }
                }
                child = child.getNextNode();
            }
        }
    }

    protected void pullTargetPackage(IDOMPackage targetPackage) {
        IDOMPackage sourcePackage = this.sourcePatternDictionary.getPackage();
        this.map((IDOMNode)sourcePackage, (IDOMNode)targetPackage);
        this.applyPullRules((IDOMNode)sourcePackage, (IDOMNode)targetPackage);
    }

    protected void pullTargetImport(IDOMImport targetImport) {
        IDOMImport sourceImport = (IDOMImport)this.sourcePatternDictionary.getImportMap().get(this.targetPatternDictionary.getQualifiedName((IDOMNode)targetImport));
        this.map((IDOMNode)sourceImport, (IDOMNode)targetImport);
        if (sourceImport != null) {
            this.applyPullRules((IDOMNode)sourceImport, (IDOMNode)targetImport);
        }
    }

    protected void pullTargetType(IDOMType targetType) {
        IDOMType sourceType = (IDOMType)this.sourcePatternDictionary.getTypeMap().get(this.targetPatternDictionary.getQualifiedName((IDOMNode)targetType));
        this.map((IDOMNode)sourceType, (IDOMNode)targetType);
        if (sourceType != null) {
            this.applyPullRules((IDOMNode)sourceType, (IDOMNode)targetType);
        }
        IDOMNode child = targetType.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 7: {
                    this.pullTargetInitializer((IDOMInitializer)child);
                    break;
                }
                case 5: {
                    this.pullTargetField((IDOMField)child);
                    break;
                }
                case 6: {
                    this.pullTargetMethod((IDOMMethod)child);
                    break;
                }
                case 4: {
                    this.pullTargetType((IDOMType)child);
                }
            }
            child = child.getNextNode();
        }
    }

    protected void pullTargetInitializer(IDOMInitializer targetInitializer) {
        IDOMInitializer sourceInitializer = (IDOMInitializer)this.sourcePatternDictionary.getInitializerMap().get(this.targetPatternDictionary.getQualifiedName((IDOMNode)targetInitializer));
        this.map((IDOMNode)sourceInitializer, (IDOMNode)targetInitializer);
        if (sourceInitializer != null) {
            this.applyPullRules((IDOMNode)sourceInitializer, (IDOMNode)targetInitializer);
        }
    }

    protected void pullTargetField(IDOMField targetField) {
        IDOMField sourceField = (IDOMField)this.sourcePatternDictionary.getFieldMap().get(this.targetPatternDictionary.getQualifiedName((IDOMNode)targetField));
        this.map((IDOMNode)sourceField, (IDOMNode)targetField);
        if (sourceField != null) {
            this.applyPullRules((IDOMNode)sourceField, (IDOMNode)targetField);
        }
    }

    protected void pullTargetMethod(IDOMMethod targetMethod) {
        String qualifiedTargetMethodName = this.targetPatternDictionary.getQualifiedName((IDOMNode)targetMethod);
        IDOMMethod sourceMethod = (IDOMMethod)this.sourcePatternDictionary.getMethodMap().get(qualifiedTargetMethodName);
        if (sourceMethod == null && this.jControlModel.getRedirect() != null && targetMethod.getName() != null && targetMethod.getName().endsWith(this.jControlModel.getRedirect())) {
            int index = qualifiedTargetMethodName.indexOf("(");
            qualifiedTargetMethodName = String.valueOf(qualifiedTargetMethodName.substring(0, index - this.jControlModel.getRedirect().length())) + qualifiedTargetMethodName.substring(index);
            sourceMethod = (IDOMMethod)this.sourcePatternDictionary.getMethodMap().get(qualifiedTargetMethodName);
        }
        this.map((IDOMNode)sourceMethod, (IDOMNode)targetMethod);
        if (sourceMethod != null) {
            this.applyPullRules((IDOMNode)sourceMethod, (IDOMNode)targetMethod);
        }
    }

    protected String applyFormatRules(String value) {
        return CodeGenUtil.convertFormat(this.jControlModel.getLeadingTabReplacement(), this.jControlModel.convertToStandardBraceStyle(), value);
    }

    protected void applyPullRules(IDOMNode sourceNode, IDOMNode targetNode) {
        try {
            for (JControlModel.PullRule pullRule : this.jControlModel.getPullRules()) {
                if (!this.sourcePatternDictionary.isMarkedUp(pullRule.getSourceMarkup(), sourceNode) || !this.targetPatternDictionary.isMarkedUp(pullRule.getTargetMarkup(), targetNode) || pullRule.getSourceGetFeature().getFeatureMethod() == null || !pullRule.getSourceGetFeature().getFeatureClass().isInstance(sourceNode) || pullRule.getTargetPutFeature().getFeatureMethod() == null || !pullRule.getTargetPutFeature().getFeatureClass().isInstance(targetNode)) continue;
                Method sourceGetMethod = pullRule.getSourceGetFeature().getFeatureMethod();
                Object value = sourceGetMethod.invoke((Object)sourceNode, noArguments);
                Method targetPutMethod = pullRule.getTargetPutFeature().getFeatureMethod();
                if (!sourceGetMethod.getReturnType().isArray() || targetPutMethod.getParameterTypes()[0].isAssignableFrom(sourceGetMethod.getReturnType())) {
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        stringValue = this.applyFormatRules(stringValue);
                        Pattern sourceTransfer = pullRule.getSourceTransfer();
                        if (sourceTransfer != null) {
                            String oldStringValue = (String)sourceGetMethod.invoke((Object)targetNode, noArguments);
                            Matcher sourceMatcher = sourceTransfer.matcher(stringValue);
                            Matcher targetMatcher = sourceTransfer.matcher(oldStringValue);
                            if (sourceMatcher.groupCount() >= 1 && targetMatcher.groupCount() >= 1) {
                                StringBuffer result = new StringBuffer();
                                int index = 0;
                                while (sourceMatcher.find() && targetMatcher.find()) {
                                    result.append(stringValue.substring(index, sourceMatcher.start(1)));
                                    result.append(targetMatcher.group(1));
                                    index = sourceMatcher.end(1);
                                }
                                if (result.length() == 0) {
                                    stringValue = null;
                                } else {
                                    result.append(stringValue.substring(index));
                                    stringValue = result.toString();
                                }
                            } else {
                                stringValue = null;
                            }
                        }
                        value = stringValue;
                    }
                    if (value == null && !targetPutMethod.getName().equals("setInitializer") && !targetPutMethod.getName().equals("setSuperclass") && !targetPutMethod.getName().equals("setExceptions")) continue;
                    Object oldValue = sourceGetMethod.invoke((Object)targetNode, noArguments);
                    if (value != null ? value.equals(oldValue) : oldValue == null) continue;
                    if (targetPutMethod.getName().equals("setSuperclass") && oldValue != null && value != null && ((String)oldValue).trim().equals(((String)value).trim()) || sourceGetMethod.getName().equals("getReturnType") && this.jControlModel.getBlockPattern() != null && ((IDOMMethod)targetNode).getComment() != null && this.jControlModel.getBlockPattern().matcher(((IDOMMethod)targetNode).getComment()).find()) continue;
                    targetPutMethod.invoke((Object)targetNode, value);
                    if (!targetPutMethod.getName().equals("setBody") || !(sourceNode instanceof IDOMMethod)) continue;
                    IDOMMethod sourceMethod = (IDOMMethod)sourceNode;
                    IDOMMethod targetMethod = (IDOMMethod)targetNode;
                    String[] sourceParameterNames = sourceMethod.getParameterNames();
                    String[] targetParameterTypes = targetMethod.getParameterTypes();
                    targetMethod.setParameters(targetParameterTypes, sourceParameterNames);
                    continue;
                }
                ArrayList<String> additionalStrings = new ArrayList<String>();
                String[] sourceStrings = (String[])value;
                if (sourceStrings != null) {
                    additionalStrings.addAll(Arrays.asList(sourceStrings));
                }
                if (targetPutMethod.getName().equals("addSuperInterface")) {
                    Pattern sourceTransfer = pullRule.getSourceTransfer();
                    if (sourceTransfer != null) {
                        String comment = ((IDOMMember)targetNode).getComment();
                        Matcher matcher = sourceTransfer.matcher(comment);
                        while (matcher.find() && matcher.groupCount() >= 1) {
                            String clientStrings = comment.substring(matcher.start(matcher.groupCount()), matcher.end(matcher.groupCount()));
                            StringTokenizer stringTokenizer = new StringTokenizer(clientStrings, ", \t\n\r\f");
                            while (stringTokenizer.hasMoreTokens()) {
                                String token = stringTokenizer.nextToken();
                                if (additionalStrings.contains(token)) continue;
                                additionalStrings.add(token);
                            }
                        }
                    }
                    IDOMType type = (IDOMType)targetNode;
                    Object[] superInterfaces = additionalStrings.toArray(new String[additionalStrings.size()]);
                    if (!(type.getSuperInterfaces() == null ? superInterfaces.length != 0 : !Arrays.equals(type.getSuperInterfaces(), superInterfaces))) continue;
                    type.setSuperInterfaces(additionalStrings.toArray(new String[additionalStrings.size()]));
                    continue;
                }
                String[] oldStringValues = (String[])sourceGetMethod.invoke((Object)targetNode, noArguments);
                List<String> old = oldStringValues == null ? Collections.EMPTY_LIST : Arrays.asList(oldStringValues);
                for (String string : additionalStrings) {
                    if (old.contains(string)) continue;
                    targetPutMethod.invoke((Object)targetNode, string);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected void pushSourceCompilationUnit() {
        IDOMNode child = this.sourceCompilationUnit.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 2: {
                    this.pushSourcePackage((IDOMPackage)child);
                    break;
                }
                case 3: {
                    this.pushSourceImport((IDOMImport)child);
                    break;
                }
                case 4: {
                    this.pushSourceType((IDOMType)child);
                }
            }
            child = child.getNextNode();
        }
    }

    protected void pushSourcePackage(IDOMPackage sourcePackage) {
        if (!this.sourceToTargetMap.containsKey(sourcePackage)) {
            this.insertClone((IDOMNode)sourcePackage);
        }
    }

    protected void pushSourceImport(IDOMImport sourceImport) {
        if (!this.sourceToTargetMap.containsKey(sourceImport) && !this.targetPatternDictionary.isNoImport(sourceImport)) {
            this.insertClone((IDOMNode)sourceImport);
        }
    }

    protected void pushSourceType(IDOMType sourceType) {
        if (!this.sourceToTargetMap.containsKey(sourceType)) {
            this.insertClone((IDOMNode)sourceType);
        } else {
            IDOMNode child = sourceType.getFirstChild();
            while (child != null) {
                switch (child.getNodeType()) {
                    case 7: {
                        this.pushSourceInitializer((IDOMInitializer)child);
                        break;
                    }
                    case 5: {
                        this.pushSourceField((IDOMField)child);
                        break;
                    }
                    case 6: {
                        this.pushSourceMethod((IDOMMethod)child);
                        break;
                    }
                    case 4: {
                        this.pushSourceType((IDOMType)child);
                    }
                }
                child = child.getNextNode();
            }
        }
    }

    protected void pushSourceInitializer(IDOMInitializer sourceInitializer) {
        if (!this.sourceToTargetMap.containsKey(sourceInitializer)) {
            this.insertClone((IDOMNode)sourceInitializer);
        }
    }

    protected void pushSourceField(IDOMField sourceField) {
        this.applySortRules((IDOMNode)sourceField);
        if (!this.sourceToTargetMap.containsKey(sourceField)) {
            this.insertClone((IDOMNode)sourceField);
        }
    }

    protected void pushSourceMethod(IDOMMethod sourceMethod) {
        if (!this.sourceToTargetMap.containsKey(sourceMethod)) {
            this.insertClone((IDOMNode)sourceMethod);
        }
    }

    public void applySortRules(IDOMNode sourceNode) {
        for (JControlModel.SortRule sortRule : this.jControlModel.getSortRules()) {
            if (!this.sourcePatternDictionary.isMarkedUp(sortRule.getMarkup(), sourceNode) || !sortRule.getSelector().isInstance(sourceNode)) continue;
            IDOMNode parent = sourceNode.getParent();
            ArrayList<IDOMNode> children = (ArrayList<IDOMNode>)this.orderedSourceChildrenMap.get(parent);
            if (children == null) {
                children = new ArrayList<IDOMNode>();
                this.orderedSourceChildrenMap.put(parent, children);
            }
            children.add(sourceNode);
            break;
        }
    }

    protected void sweepTargetCompilationUnit() {
        for (Map.Entry entry : this.targetToSourceMap.entrySet()) {
            if (entry.getValue() != null) continue;
            this.applySweepRules((IDOMNode)entry.getKey());
        }
    }

    protected void applySweepRules(IDOMNode targetNode) {
        for (JControlModel.SweepRule sweepRule : this.jControlModel.getSweepRules()) {
            if (sweepRule.getSelector() == IDOMImport.class && targetNode instanceof IDOMImport) {
                if (!sweepRule.getMarkup().matcher(targetNode.getName()).find()) continue;
                targetNode.remove();
                break;
            }
            if (!this.targetPatternDictionary.isMarkedUp(sweepRule.getMarkup(), targetNode) || !sweepRule.getSelector().isInstance(targetNode)) continue;
            targetNode.remove();
            break;
        }
    }

    protected void sortTargetCompilationUnit() {
        for (List children : this.orderedSourceChildrenMap.values()) {
            if (children.size() <= 2) continue;
            Iterator i = children.iterator();
            IDOMNode sourceNode = (IDOMNode)i.next();
            IDOMNode previousTargetNode = (IDOMNode)this.sourceToTargetMap.get(sourceNode);
            do {
                sourceNode = (IDOMNode)i.next();
                IDOMNode nextTargetNode = (IDOMNode)this.sourceToTargetMap.get(sourceNode);
                boolean reorder = true;
                IDOMNode domNode = nextTargetNode.getPreviousNode();
                while (domNode != null) {
                    if (domNode == previousTargetNode) {
                        reorder = false;
                        break;
                    }
                    domNode = domNode.getPreviousNode();
                }
                if (reorder) {
                    nextTargetNode.remove();
                    if (previousTargetNode.getNextNode() == null) {
                        previousTargetNode.getParent().addChild(nextTargetNode);
                    } else {
                        previousTargetNode.getNextNode().insertSibling(nextTargetNode);
                    }
                }
                previousTargetNode = nextTargetNode;
            } while (i.hasNext());
        }
    }

    protected IDOMNode insertClone(IDOMNode sourceNode) {
        IDOMNode targetSibling;
        IDOMNode targetNode = null;
        switch (sourceNode.getNodeType()) {
            case 1: {
                targetNode = this.jdomFactory.createCompilationUnit(this.applyFormatRules(sourceNode.getContents()), ((IDOMCompilationUnit)sourceNode).getName());
                break;
            }
            case 2: {
                targetNode = this.jdomFactory.createPackage(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 3: {
                targetNode = this.jdomFactory.createImport(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 4: {
                targetNode = this.jdomFactory.createType(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 7: {
                targetNode = this.jdomFactory.createInitializer(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 5: {
                targetNode = this.jdomFactory.createField(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            case 6: {
                targetNode = this.jdomFactory.createMethod(this.applyFormatRules(sourceNode.getContents()));
                break;
            }
            default: {
                targetNode = (IDOMNode)sourceNode.clone();
            }
        }
        if (targetNode != null) {
            this.map(sourceNode, targetNode);
            this.mapChildren(sourceNode, targetNode);
        }
        IDOMNode previousNode = sourceNode.getPreviousNode();
        while (previousNode != null) {
            targetSibling = (IDOMNode)this.sourceToTargetMap.get(previousNode);
            if (targetSibling != null) {
                IDOMNode targetNextSibling = targetSibling.getNextNode();
                if (targetNextSibling == null) {
                    targetSibling.getParent().addChild(targetNode);
                } else {
                    targetNextSibling.insertSibling(targetNode);
                }
                return targetNode;
            }
            previousNode = previousNode.getPreviousNode();
        }
        if (sourceNode.getParent() != null) {
            IDOMNode targetParent = (IDOMNode)this.sourceToTargetMap.get(sourceNode.getParent());
            targetSibling = targetParent.getFirstChild();
            if (targetSibling == null) {
                targetParent.addChild(targetNode);
            } else {
                targetSibling.insertSibling(targetNode);
            }
        }
        return targetNode;
    }

    protected void mapChildren(IDOMNode sourceNode, IDOMNode targetNode) {
        this.map(sourceNode, targetNode);
        IDOMNode sourceChild = sourceNode.getFirstChild();
        IDOMNode targetChild = targetNode.getFirstChild();
        while (sourceChild != null) {
            this.mapChildren(sourceChild, targetChild);
            sourceChild = sourceChild.getNextNode();
            targetChild = targetChild.getNextNode();
        }
    }

    protected void map(IDOMNode sourceNode, IDOMNode targetNode) {
        if (sourceNode != null) {
            this.sourceToTargetMap.put(sourceNode, targetNode);
        }
        this.targetToSourceMap.put(targetNode, sourceNode);
    }

    public Object run(Object object) {
        try {
            String contents = this.execute((IProgressMonitor)new NullProgressMonitor(), (String[])object);
            System.out.println("**********************************************");
            System.out.println(contents);
            return 0;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public String execute(IProgressMonitor progressMonitor, String[] arguments) {
        String mergeXML = arguments[0];
        String sourceURI = arguments[1];
        String targetURI = arguments[2];
        this.jControlModel = new JControlModel(mergeXML);
        this.sourceCompilationUnit = this.createCompilationUnitForURI(sourceURI);
        this.targetCompilationUnit = this.createCompilationUnitForURI(targetURI);
        this.sourcePatternDictionary = new JPatternDictionary(this.sourceCompilationUnit, this.jControlModel);
        this.targetPatternDictionary = new JPatternDictionary(this.targetCompilationUnit, this.jControlModel);
        this.merge();
        return this.targetCompilationUnit.getContents();
    }

    @Deprecated
    public static class PlatformRunnable
    extends PropertyMerger
    implements IPlatformRunnable {
    }
}

