/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryGenericTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeArgumentSignature;

public class BinaryErasureTypeSignature
extends BinaryGenericTypeSignature {
    BinaryErasureTypeSignature(BinaryGenericTypeSignature genericSignature, int arrayDimensions) {
        super(genericSignature.chars, genericSignature.offset + arrayDimensions, genericSignature.length - arrayDimensions);
        this.arrayDimensions = arrayDimensions;
    }

    @Override
    protected void toIdentifier(StringBuilder builder, int fixup) {
        BinaryGenericTypeSignature componentType = this.getArrayComponentType();
        if (componentType != this) {
            componentType.toIdentifier(builder, fixup);
            int dim = this.getArrayDimensions();
            for (int i = 0; i < dim; ++i) {
                builder.append("[]");
            }
        } else {
            int depth = 0;
            boolean wasGenericEnd = false;
            int max = this.offset + this.length - fixup;
            for (int i = this.offset + fixup; i < max; ++i) {
                char c = this.chars.charAt(i);
                if (c == '<') {
                    ++depth;
                    continue;
                }
                if (c == '>') {
                    --depth;
                    wasGenericEnd = true;
                    continue;
                }
                if (depth != 0) continue;
                if (c == '/') {
                    builder.append('.');
                    continue;
                }
                if (c == '.' && wasGenericEnd) {
                    builder.append('$');
                    continue;
                }
                builder.append(c);
            }
        }
    }

    @Override
    public BinaryGenericTypeSignature getArrayComponentType() {
        return new BinaryErasureTypeSignature(this, 0){

            @Override
            public BinaryGenericTypeSignature getArrayComponentType() {
                return this;
            }
        };
    }

    @Override
    public BinaryGenericTypeSignature getTypeErasure() {
        return this;
    }

    @Override
    public List<BinaryTypeArgumentSignature> getTypeArguments() {
        return Collections.emptyList();
    }
}

