/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateMappingException;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingConfigurationException;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class AnnotationMappingMetadataSource
implements MappingMetadataSource {
    private static final String SELF = "";
    private final MavenProject project;
    private final String projectId;
    private final List<PI> pis;
    private static final Splitter PI_SPLITTER = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().limit(2);
    private static final Splitter EXECUTE_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private static final Map<String, String> EXECUTE_OPTIONS = new ImmutableMap.Builder().put((Object)"onConfiguration", (Object)"runOnConfiguration").put((Object)"onIncremental", (Object)"runOnIncremental").build();

    public static AnnotationMappingMetadataSource get(MavenProject project) {
        List<PI> pis = AnnotationMappingMetadataSource.parsePIs(project);
        if (!pis.isEmpty()) {
            return new AnnotationMappingMetadataSource(project, pis);
        }
        return null;
    }

    private AnnotationMappingMetadataSource(MavenProject project, List<PI> pis) {
        this.project = project;
        this.pis = pis;
        this.projectId = project.getModel().getLocation((Object)SELF).getSource().getModelId();
    }

    @Override
    public List<PluginExecutionMetadata> getPluginExecutionMetadata(MojoExecutionKey execution) {
        Xpp3Dom action = this.getAction(execution);
        if (action != null) {
            return Collections.singletonList(this.createMetadata(action));
        }
        return Collections.emptyList();
    }

    private Xpp3Dom getAction(MojoExecutionKey execution) {
        String key = Plugin.constructKey((String)execution.getGroupId(), (String)execution.getArtifactId());
        Plugin plugin = this.getPlugin((PluginContainer)this.project.getBuild(), key);
        Plugin mplugin = this.getPlugin((PluginContainer)this.project.getPluginManagement(), key);
        String executionId = execution.getExecutionId();
        if (executionId != null) {
            Xpp3Dom action;
            Xpp3Dom action2;
            PluginExecution pluginExecution;
            if (plugin != null && (pluginExecution = (PluginExecution)plugin.getExecutionsAsMap().get(executionId)) != null && (action2 = this.getAction((InputLocationTracker)pluginExecution)) != null) {
                return action2;
            }
            if (mplugin != null && (pluginExecution = (PluginExecution)mplugin.getExecutionsAsMap().get(executionId)) != null && (action2 = this.getAction((InputLocationTracker)pluginExecution)) != null) {
                return action2;
            }
            if (plugin != null && (action = this.getAction((InputLocationTracker)plugin)) != null) {
                return action;
            }
            if (mplugin != null && (action = this.getAction((InputLocationTracker)mplugin)) != null) {
                return action;
            }
        }
        return null;
    }

    private Plugin getPlugin(PluginContainer plugins, String key) {
        return plugins == null ? null : (Plugin)plugins.getPluginsAsMap().get(key);
    }

    @Override
    public LifecycleMappingMetadata getLifecycleMappingMetadata(String packagingType) throws DuplicateMappingException {
        return null;
    }

    private Xpp3Dom getAction(InputLocationTracker tracker) {
        InputLocation location = tracker.getLocation((Object)SELF);
        if (location != null && location.getSource() != null && this.projectId.equals(location.getSource().getModelId())) {
            int l = location.getLineNumber();
            int c = location.getColumnNumber();
            for (PI pi : this.pis) {
                if (pi.l != l || pi.c != c) continue;
                return pi.action;
            }
        }
        return null;
    }

    private PluginExecutionMetadata createMetadata(Xpp3Dom action) {
        Xpp3Dom actionDom = new Xpp3Dom("action");
        actionDom.addChild(action);
        PluginExecutionMetadata md = new PluginExecutionMetadata();
        md.setActionDom(actionDom);
        LifecycleMappingMetadataSource source = new LifecycleMappingMetadataSource();
        source.setSource(this.project);
        md.setSource(source);
        md.setFilter(new PluginExecutionFilter());
        return md;
    }

    private static List<PI> parsePIs(MavenProject project) {
        File pom = project.getFile();
        InputSource source = project.getModel().getLocation((Object)SELF).getSource();
        ArrayList<PI> pis = new ArrayList<PI>();
        MXParser parser = new MXParser();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream in = new FileInputStream(pom);){
                parser.setInput((Reader)ReaderFactory.newXmlReader((InputStream)in));
                LinkedList<State> stack = new LinkedList<State>();
                int eventType = parser.getEventType();
                while (eventType != 1) {
                    String text;
                    if (eventType == 2) {
                        stack.push(new State(parser.getLineNumber(), parser.getColumnNumber()));
                    } else if (eventType == 3) {
                        stack.pop();
                    } else if (eventType == 8 && !stack.isEmpty() && (text = parser.getText()).startsWith("m2e ")) {
                        Xpp3Dom dom = AnnotationMappingMetadataSource.parse(text.substring(4));
                        if (dom == null) {
                            SourceLocation location = new SourceLocation(source.getLocation(), source.getModelId(), parser.getLineNumber(), parser.getColumnNumber(), text.length() + 4);
                            throw new LifecycleMappingConfigurationException(Messages.AnnotationMappingMetadataSource_UnsupportedInstructionFormat, location);
                        }
                        State s = (State)stack.peek();
                        PI pi = new PI(s.l, s.c, dom);
                        pis.add(pi);
                    }
                    eventType = parser.nextToken();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XmlPullParserException ex) {
            SourceLocation location = new SourceLocation(source.getLocation(), source.getModelId(), parser.getLineNumber(), parser.getColumnNumber(), 1);
            throw new LifecycleMappingConfigurationException(Messages.AnnotationMappingMetadataSource_ErrorParsingInstruction, location);
        }
        return pis;
    }

    private static Xpp3Dom parse(String pi) {
        List split = PI_SPLITTER.splitToList((CharSequence)pi);
        PluginExecutionAction a = AnnotationMappingMetadataSource.getAction((String)split.get(0));
        if (a == null) {
            return null;
        }
        switch (a) {
            case ignore: {
                return new Xpp3Dom("ignore");
            }
            case configurator: {
                if (split.size() != 2) {
                    return null;
                }
                Xpp3Dom conf = new Xpp3Dom("configurator");
                Xpp3Dom id = new Xpp3Dom("id");
                id.setValue((String)split.get(1));
                conf.addChild(id);
                return conf;
            }
            case execute: {
                Xpp3Dom exec = new Xpp3Dom("execute");
                if (split.size() > 1) {
                    for (String option : EXECUTE_SPLITTER.split((CharSequence)split.get(1))) {
                        String value = EXECUTE_OPTIONS.get(option);
                        if (value == null) {
                            return null;
                        }
                        Xpp3Dom opt = new Xpp3Dom(value);
                        opt.setValue("true");
                        exec.addChild(opt);
                    }
                }
                return exec;
            }
        }
        return null;
    }

    private static PluginExecutionAction getAction(String value) {
        PluginExecutionAction[] pluginExecutionActionArray = PluginExecutionAction.values();
        int n = pluginExecutionActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginExecutionAction a = pluginExecutionActionArray[n2];
            if (value.toLowerCase().equals(a.name())) {
                return a;
            }
            ++n2;
        }
        return null;
    }

    private static class PI {
        final int l;
        final int c;
        final Xpp3Dom action;

        PI(int l, int c, Xpp3Dom action) {
            this.l = l;
            this.c = c;
            this.action = action;
        }
    }

    private static class State {
        final int l;
        final int c;

        State(int l, int c) {
            this.l = l;
            this.c = c;
        }
    }
}

