/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.io.GraphMLMetadata;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.TransformerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphMLWriter<V, E> {
    protected Transformer<V, String> vertex_ids = new Transformer<V, String>(){

        public String transform(V v) {
            return v.toString();
        }
    };
    protected Transformer<E, String> edge_ids = TransformerUtils.nullTransformer();
    protected Map<String, GraphMLMetadata<Hypergraph<V, E>>> graph_data = Collections.emptyMap();
    protected Map<String, GraphMLMetadata<V>> vertex_data = Collections.emptyMap();
    protected Map<String, GraphMLMetadata<E>> edge_data = Collections.emptyMap();
    protected Transformer<V, String> vertex_desc = TransformerUtils.nullTransformer();
    protected Transformer<E, String> edge_desc = TransformerUtils.nullTransformer();
    protected Transformer<Hypergraph<V, E>, String> graph_desc = TransformerUtils.nullTransformer();
    protected boolean directed;
    protected int nest_level = 0;

    public void save(Hypergraph<V, E> graph, Writer w) throws IOException {
        BufferedWriter bw = new BufferedWriter(w);
        bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bw.write("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  \n");
        bw.write("xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml\">\n");
        for (String key : this.graph_data.keySet()) {
            this.writeKeySpecification(key, "graph", this.graph_data.get(key), bw);
        }
        for (String key : this.vertex_data.keySet()) {
            this.writeKeySpecification(key, "node", this.vertex_data.get(key), bw);
        }
        for (String key : this.edge_data.keySet()) {
            this.writeKeySpecification(key, "edge", this.edge_data.get(key), bw);
        }
        bw.write("<graph edgedefault=\"");
        boolean bl = this.directed = !(graph instanceof UndirectedGraph);
        if (this.directed) {
            bw.write("directed\">\n");
        } else {
            bw.write("undirected\">\n");
        }
        String desc = (String)this.graph_desc.transform(graph);
        if (desc != null) {
            bw.write("<desc>" + desc + "</desc>\n");
        }
        for (String key : this.graph_data.keySet()) {
            Transformer t = this.graph_data.get((Object)key).transformer;
            Object value = t.transform(graph);
            if (value == null) continue;
            bw.write(this.format("data", "key", key, value.toString()) + "\n");
        }
        this.writeVertexData(graph, bw);
        this.writeEdgeData(graph, bw);
        bw.write("</graph>\n");
        bw.write("</graphml>\n");
        bw.flush();
        bw.close();
    }

    protected void writeIndentedText(BufferedWriter w, String to_write) throws IOException {
        for (int i = 0; i < this.nest_level; ++i) {
            w.write("  ");
        }
        w.write(to_write);
    }

    protected void writeVertexData(Hypergraph<V, E> graph, BufferedWriter w) throws IOException {
        for (V v : graph.getVertices()) {
            String v_string = String.format("<node id=\"%s\"", this.vertex_ids.transform(v));
            boolean closed = false;
            String desc = (String)this.vertex_desc.transform(v);
            if (desc != null) {
                w.write(v_string + ">\n");
                closed = true;
                w.write("<desc>" + desc + "</desc>\n");
            }
            for (String key : this.vertex_data.keySet()) {
                Object value;
                Transformer t = this.vertex_data.get((Object)key).transformer;
                if (t == null || (value = t.transform(v)) == null) continue;
                if (!closed) {
                    w.write(v_string + ">\n");
                    closed = true;
                }
                w.write(this.format("data", "key", key, value.toString()) + "\n");
            }
            if (!closed) {
                w.write(v_string + "/>\n");
                continue;
            }
            w.write("</node>\n");
        }
    }

    protected void writeEdgeData(Hypergraph<V, E> g, Writer w) throws IOException {
        for (E e : g.getEdges()) {
            String e_string;
            boolean is_hyperedge;
            Collection<V> vertices = g.getIncidentVertices(e);
            String id = (String)this.edge_ids.transform(e);
            boolean bl = is_hyperedge = !(g instanceof Graph);
            if (is_hyperedge) {
                e_string = "<hyperedge ";
                if (id != null) {
                    e_string = e_string + "id=\"" + id + "\" ";
                }
            } else {
                Pair<V> endpoints = new Pair<V>(vertices);
                V v1 = endpoints.getFirst();
                V v2 = endpoints.getSecond();
                e_string = "<edge ";
                if (id != null) {
                    e_string = e_string + "id=\"" + id + "\" ";
                }
                EdgeType edge_type = g.getEdgeType(e);
                if (this.directed && edge_type == EdgeType.UNDIRECTED) {
                    e_string = e_string + "directed=\"false\" ";
                }
                if (!this.directed && edge_type == EdgeType.DIRECTED) {
                    e_string = e_string + "directed=\"true\" ";
                }
                e_string = e_string + "source=\"" + (String)this.vertex_ids.transform(v1) + "\" target=\"" + (String)this.vertex_ids.transform(v2) + "\"";
            }
            boolean closed = false;
            String desc = (String)this.edge_desc.transform(e);
            if (desc != null) {
                w.write(e_string + ">\n");
                closed = true;
                w.write("<desc>" + desc + "</desc>\n");
            }
            for (String key : this.edge_data.keySet()) {
                Transformer t = this.edge_data.get((Object)key).transformer;
                Object value = t.transform(e);
                if (value == null) continue;
                if (!closed) {
                    w.write(e_string + ">\n");
                    closed = true;
                }
                w.write(this.format("data", "key", key, value.toString()) + "\n");
            }
            if (is_hyperedge) {
                for (String v : vertices) {
                    if (!closed) {
                        w.write(e_string + ">\n");
                        closed = true;
                    }
                    w.write("<endpoint node=\"" + (String)this.vertex_ids.transform((Object)v) + "\"/>\n");
                }
            }
            if (!closed) {
                w.write(e_string + "/>\n");
                continue;
            }
            if (is_hyperedge) {
                w.write("</hyperedge>\n");
                continue;
            }
            w.write("</edge>\n");
        }
    }

    protected void writeKeySpecification(String key, String type, GraphMLMetadata<?> ds, BufferedWriter bw) throws IOException {
        String def;
        bw.write("<key id=\"" + key + "\" for=\"" + type + "\"");
        boolean closed = false;
        String desc = ds.description;
        if (desc != null) {
            if (!closed) {
                bw.write(">\n");
                closed = true;
            }
            bw.write("<desc>" + desc + "</desc>\n");
        }
        if ((def = ds.default_value) != null) {
            if (!closed) {
                bw.write(">\n");
                closed = true;
            }
            bw.write("<default>" + def.toString() + "</default>\n");
        }
        if (!closed) {
            bw.write("/>\n");
        } else {
            bw.write("</key>\n");
        }
    }

    protected String format(String type, String attr, String value, String contents) {
        return String.format("<%s %s=\"%s\">%s</%s>", type, attr, value, contents, type);
    }

    public void setVertexIDs(Transformer<V, String> vertex_ids) {
        this.vertex_ids = vertex_ids;
    }

    public void setEdgeIDs(Transformer<E, String> edge_ids) {
        this.edge_ids = edge_ids;
    }

    public void setGraphData(Map<String, GraphMLMetadata<Hypergraph<V, E>>> graph_map) {
        this.graph_data = graph_map;
    }

    public void setVertexData(Map<String, GraphMLMetadata<V>> vertex_map) {
        this.vertex_data = vertex_map;
    }

    public void setEdgeData(Map<String, GraphMLMetadata<E>> edge_map) {
        this.edge_data = edge_map;
    }

    public void addGraphData(String id, String description, String default_value, Transformer<Hypergraph<V, E>, String> graph_transformer) {
        if (((Object)this.graph_data).equals(Collections.EMPTY_MAP)) {
            this.graph_data = new HashMap<String, GraphMLMetadata<Hypergraph<V, E>>>();
        }
        this.graph_data.put(id, new GraphMLMetadata<Hypergraph<V, E>>(description, default_value, graph_transformer));
    }

    public void addVertexData(String id, String description, String default_value, Transformer<V, String> vertex_transformer) {
        if (((Object)this.vertex_data).equals(Collections.EMPTY_MAP)) {
            this.vertex_data = new HashMap<String, GraphMLMetadata<V>>();
        }
        this.vertex_data.put(id, new GraphMLMetadata<V>(description, default_value, vertex_transformer));
    }

    public void addEdgeData(String id, String description, String default_value, Transformer<E, String> edge_transformer) {
        if (((Object)this.edge_data).equals(Collections.EMPTY_MAP)) {
            this.edge_data = new HashMap<String, GraphMLMetadata<E>>();
        }
        this.edge_data.put(id, new GraphMLMetadata<E>(description, default_value, edge_transformer));
    }

    public void setVertexDescriptions(Transformer<V, String> vertex_desc) {
        this.vertex_desc = vertex_desc;
    }

    public void setEdgeDescriptions(Transformer<E, String> edge_desc) {
        this.edge_desc = edge_desc;
    }

    public void setGraphDescriptions(Transformer<Hypergraph<V, E>, String> graph_desc) {
        this.graph_desc = graph_desc;
    }
}

