/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.formalml.xtext.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.efm.ecore.formalml.common.CommonPackage;
import org.eclipse.efm.ecore.formalml.common.NamedElement;
import org.eclipse.efm.ecore.formalml.common.Type;
import org.eclipse.efm.ecore.formalml.datatype.DataType;
import org.eclipse.efm.ecore.formalml.expression.ArithmeticAssociativeExpression;
import org.eclipse.efm.ecore.formalml.expression.ArithmeticUnaryExpression;
import org.eclipse.efm.ecore.formalml.expression.BinaryExpression;
import org.eclipse.efm.ecore.formalml.expression.BitwiseAssociativeExpression;
import org.eclipse.efm.ecore.formalml.expression.BitwiseUnaryExpression;
import org.eclipse.efm.ecore.formalml.expression.Expression;
import org.eclipse.efm.ecore.formalml.expression.LogicalAssociativeExpression;
import org.eclipse.efm.ecore.formalml.expression.LogicalUnaryExpression;
import org.eclipse.efm.ecore.formalml.infrastructure.Behavior;
import org.eclipse.efm.ecore.formalml.infrastructure.Buffer;
import org.eclipse.efm.ecore.formalml.infrastructure.Channel;
import org.eclipse.efm.ecore.formalml.infrastructure.InstanceMachine;
import org.eclipse.efm.ecore.formalml.infrastructure.Machine;
import org.eclipse.efm.ecore.formalml.infrastructure.Parameter;
import org.eclipse.efm.ecore.formalml.infrastructure.ParameterSet;
import org.eclipse.efm.ecore.formalml.infrastructure.Port;
import org.eclipse.efm.ecore.formalml.infrastructure.Procedure;
import org.eclipse.efm.ecore.formalml.infrastructure.PropertyDefinition;
import org.eclipse.efm.ecore.formalml.infrastructure.Routine;
import org.eclipse.efm.ecore.formalml.infrastructure.Signal;
import org.eclipse.efm.ecore.formalml.infrastructure.System;
import org.eclipse.efm.formalml.xtext.typing.FormalMLTypeProvider;
import org.eclipse.efm.formalml.xtext.validation.AbstractFormalMLValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FormalMLValidator
extends AbstractFormalMLValidator {
    @Inject
    @Extension
    private FormalMLTypeProvider _formalMLTypeProvider;
    public static final String DUPLICATE_DECLARATION = "org.eclipse.efm.formalml.xtext.DuplicateDeclaration";
    public static final String INCOMPATIBLE_TYPES = "org.eclipse.efm.formalml.xtext.IncompatibleTypes";
    public static final String NAME_NULL = "org.example.system.name";

    public void checkNoDuplicateDeclarationInBlock(NamedElement decl, Iterable<? extends NamedElement> collection, String clazz) {
        Functions.Function1 _function = it -> !Objects.equal((Object)it, (Object)decl) && Objects.equal((Object)it.getName(), (Object)decl.getName());
        boolean _exists = IterableExtensions.exists(collection, (Functions.Function1)_function);
        if (_exists) {
            String _name = decl.getName();
            String _plus = "Duplicate " + clazz + " '" + _name;
            String _plus_1 = String.valueOf(_plus) + "'";
            EAttribute _namedElement_Name = CommonPackage.eINSTANCE.getNamedElement_Name();
            this.error(_plus_1, (EStructuralFeature)_namedElement_Name, DUPLICATE_DECLARATION, new String[0]);
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(Machine decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _machine = ((Machine)_eContainer_1).getMachine();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_machine, "machine");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(DataType decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _typedef = ((Machine)_eContainer_1).getTypedef();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_typedef, "typedef");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(PropertyDefinition decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _property = ((Machine)_eContainer_1).getProperty();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_property, "property");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(Channel decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _channel = ((Machine)_eContainer_1).getChannel();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_channel, "channel");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(Port decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _port = ((Machine)_eContainer_1).getPort();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_port, "port");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(Signal decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _signal = ((Machine)_eContainer_1).getSignal();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_signal, "signal");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(Buffer decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _buffer = ((Machine)_eContainer_1).getBuffer();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_buffer, "buffer");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(Routine decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _routine = ((Machine)_eContainer_1).getRoutine();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_routine, "routine");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(Procedure decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _procedure = ((Machine)_eContainer_1).getProcedure();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_procedure, "procedure");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(InstanceMachine decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _instance = ((Machine)_eContainer_1).getInstance();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_instance, "instance");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInMachine(Behavior decl) {
        EObject _eContainer = decl.eContainer();
        if (_eContainer instanceof Machine) {
            EObject _eContainer_1 = decl.eContainer();
            EList _behavior = ((Machine)_eContainer_1).getBehavior();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_behavior, "behavior");
        }
    }

    @Check
    public void checkNoDuplicateDeclarationInBehavior(Parameter decl) {
        EList _parameter;
        EObject container = decl.eContainer();
        boolean _matched = false;
        if (container instanceof Behavior) {
            _matched = true;
            _parameter = ((Behavior)container).getParameter();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_parameter, "parameter");
        }
        if (!_matched && container instanceof Routine) {
            _matched = true;
            _parameter = ((Routine)container).getParameter();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_parameter, "parameter");
        }
        if (!_matched && container instanceof ParameterSet) {
            _matched = true;
            _parameter = ((ParameterSet)container).getParameter();
            this.checkNoDuplicateDeclarationInBlock((NamedElement)decl, (Iterable<? extends NamedElement>)_parameter, "parameter");
        }
    }

    @Check
    public void checkClassHierarchy(System system) {
        String _name = system.getName();
        boolean _equals = Objects.equal((Object)_name, null);
        if (_equals) {
            EAttribute _namedElement_Name = CommonPackage.eINSTANCE.getNamedElement_Name();
            String _name_1 = system.getName();
            this.error("system.name == null", (EStructuralFeature)_namedElement_Name, NAME_NULL, new String[]{_name_1});
        }
    }

    @Check
    public void checkCompatibleTypes(BinaryExpression exp) {
        boolean _not;
        Expression _leftOperand = exp.getLeftOperand();
        Type leftType = this._formalMLTypeProvider.typeClassFor(_leftOperand);
        Expression _rigthOperand = exp.getRigthOperand();
        Type rigthType = this._formalMLTypeProvider.typeClassFor(_rigthOperand);
        if (Objects.equal((Object)leftType, null) || Objects.equal((Object)rigthType, null)) {
            return;
        }
        boolean _isConformant = this._formalMLTypeProvider.isConformant(rigthType, leftType);
        boolean bl = _not = !_isConformant;
        if (_not) {
            String _name = leftType.getName();
            String _plus = "Incompatible types. Expected '" + _name;
            String _plus_1 = String.valueOf(_plus) + "' but was '";
            String _name_1 = rigthType.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
        }
    }

    @Check
    public void checkCompatibleTypes(LogicalUnaryExpression exp) {
        boolean _notEquals;
        Expression _operand = exp.getOperand();
        Type operandType = this._formalMLTypeProvider.typeClassFor(_operand);
        boolean bl = _notEquals = !Objects.equal((Object)operandType, null);
        if (_notEquals) {
            boolean _not;
            boolean _isConformant = this._formalMLTypeProvider.isConformant(operandType, (Type)FormalMLTypeProvider.booleanType);
            boolean bl2 = _not = !_isConformant;
            if (_not) {
                String _name = FormalMLTypeProvider.booleanType.getName();
                String _plus = "Incompatible types. Expected '" + _name;
                String _plus_1 = String.valueOf(_plus) + "' but was '";
                String _name_1 = operandType.getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
            }
        }
    }

    @Check
    public void checkCompatibleTypes(LogicalAssociativeExpression exp) {
        EList _operand = exp.getOperand();
        for (Expression operand : _operand) {
            boolean _not;
            boolean _notEquals;
            Type operandType = this._formalMLTypeProvider.typeClassFor(operand);
            boolean bl = _notEquals = !Objects.equal((Object)operandType, null);
            if (!_notEquals) continue;
            boolean _isConformant = this._formalMLTypeProvider.isConformant(operandType, (Type)FormalMLTypeProvider.booleanType);
            boolean bl2 = _not = !_isConformant;
            if (!_not) continue;
            String _name = FormalMLTypeProvider.booleanType.getName();
            String _plus = "Incompatible types. Expected '" + _name;
            String _plus_1 = String.valueOf(_plus) + "' but was '";
            String _name_1 = operandType.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
        }
    }

    @Check
    public void checkCompatibleTypes(ArithmeticUnaryExpression exp) {
        boolean _notEquals;
        Expression _operand = exp.getOperand();
        Type operandType = this._formalMLTypeProvider.typeClassFor(_operand);
        boolean bl = _notEquals = !Objects.equal((Object)operandType, null);
        if (_notEquals) {
            boolean _not;
            boolean _isConformant = this._formalMLTypeProvider.isConformant(operandType, (Type)FormalMLTypeProvider.realType);
            boolean bl2 = _not = !_isConformant;
            if (_not) {
                String _name = FormalMLTypeProvider.realType.getName();
                String _plus = "Incompatible types. Expected '" + _name;
                String _plus_1 = String.valueOf(_plus) + "' but was '";
                String _name_1 = operandType.getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
            }
        }
    }

    @Check
    public void checkCompatibleTypes(ArithmeticAssociativeExpression exp) {
        Type prevType = null;
        EList _operand = exp.getOperand();
        for (Expression operand : _operand) {
            boolean _notEquals_1;
            boolean _notEquals;
            Type operandType = this._formalMLTypeProvider.typeClassFor(operand);
            boolean bl = _notEquals = !Objects.equal((Object)operandType, null);
            if (!_notEquals) continue;
            boolean bl2 = _notEquals_1 = !Objects.equal(prevType, null);
            if (_notEquals_1) {
                boolean _isConformant = this._formalMLTypeProvider.isConformant(prevType, operandType);
                if (_isConformant) {
                    prevType = operandType;
                    continue;
                }
                boolean _isConformant_1 = this._formalMLTypeProvider.isConformant(operandType, prevType);
                if (_isConformant_1) continue;
                String _name = prevType.getName();
                String _plus = "Incompatible types between '" + _name;
                String _plus_1 = String.valueOf(_plus) + "' and '";
                String _name_1 = operandType.getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
                continue;
            }
            prevType = operandType;
        }
    }

    @Check
    public void checkCompatibleTypes(BitwiseUnaryExpression exp) {
        boolean _notEquals;
        Expression _operand = exp.getOperand();
        Type operandType = this._formalMLTypeProvider.typeClassFor(_operand);
        boolean bl = _notEquals = !Objects.equal((Object)operandType, null);
        if (_notEquals) {
            boolean _not;
            boolean _isConformant = this._formalMLTypeProvider.isConformant(operandType, (Type)FormalMLTypeProvider.integerType);
            boolean bl2 = _not = !_isConformant;
            if (_not) {
                String _name = FormalMLTypeProvider.integerType.getName();
                String _plus = "Incompatible types. Expected '" + _name;
                String _plus_1 = String.valueOf(_plus) + "' but was '";
                String _name_1 = operandType.getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
            }
        }
    }

    @Check
    public void checkCompatibleTypes(BitwiseAssociativeExpression exp) {
        EList _operand = exp.getOperand();
        for (Expression operand : _operand) {
            boolean _not;
            boolean _notEquals;
            Type operandType = this._formalMLTypeProvider.typeClassFor(operand);
            boolean bl = _notEquals = !Objects.equal((Object)operandType, null);
            if (!_notEquals) continue;
            boolean _isConformant = this._formalMLTypeProvider.isConformant(operandType, (Type)FormalMLTypeProvider.integerType);
            boolean bl2 = _not = !_isConformant;
            if (!_not) continue;
            String _name = FormalMLTypeProvider.integerType.getName();
            String _plus = "Incompatible types. Expected '" + _name;
            String _plus_1 = String.valueOf(_plus) + "' but was '";
            String _name_1 = operandType.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
        }
    }

    @Check
    public void checkCompatibleTypes(Expression exp) {
        boolean _not;
        Type actualType = this._formalMLTypeProvider.typeClassFor(exp);
        Type expectedType = this._formalMLTypeProvider.expectedTypeClass(exp);
        if (Objects.equal((Object)expectedType, null) || Objects.equal((Object)actualType, null)) {
            return;
        }
        boolean _isConformant = this._formalMLTypeProvider.isConformant(actualType, expectedType);
        boolean bl = _not = !_isConformant;
        if (_not) {
            String _name = expectedType.getName();
            String _plus = "Incompatible types. Expected '" + _name;
            String _plus_1 = String.valueOf(_plus) + "' but was '";
            String _name_1 = actualType.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
        }
    }
}

