/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.view;

import java.util.Arrays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.ui.view.MSCWidget;

public class NGC
implements IGC {
    private GC context;
    private MSCWidget view;
    private Font tempFont = null;
    private Color gradientColor = null;
    private Color backGround = null;
    private Color foreGround = null;
    private int viewY;
    private int viewX;
    private int yx;
    private int xx;
    private boolean drawWithFocus = false;
    private static int vscreenBounds = 0;

    public NGC(MSCWidget scrollView, GC gc) {
        this.context = gc;
        this.view = scrollView;
    }

    @Override
    public void setLineStyle(int style) {
        this.context.setLineStyle(style);
    }

    @Override
    public int getLineStyle() {
        return this.context.getLineStyle();
    }

    @Override
    public int getContentsX() {
        return Math.round((float)this.view.getContentsX() / this.view.getZoomFactor());
    }

    @Override
    public int getContentsY() {
        return Math.round((float)this.view.getContentsY() / this.view.getZoomFactor());
    }

    @Override
    public int getVisibleWidth() {
        return Math.round((float)this.view.getVisibleWidth() / this.view.getZoomFactor());
    }

    @Override
    public int getVisibleHeight() {
        return Math.round((float)this.view.getVisibleHeight() / this.view.getZoomFactor());
    }

    private byte code(int x, int y) {
        byte c = 0;
        this.viewY = vscreenBounds;
        this.viewX = vscreenBounds;
        this.yx = this.view.getVisibleHeight() + vscreenBounds;
        this.xx = this.view.getVisibleWidth() + vscreenBounds;
        if (y > this.yx) {
            c = (byte)(c | 1);
        } else if (y < this.viewY) {
            c = (byte)(c | 2);
        }
        if (x > this.xx) {
            c = (byte)(c | 4);
        } else if (x < this.viewX) {
            c = (byte)(c | 8);
        }
        return c;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        int tempX1 = Math.round((float)x1 * this.view.getZoomFactor());
        int tempY1 = Math.round((float)y1 * this.view.getZoomFactor());
        int tempX2 = Math.round((float)x2 * this.view.getZoomFactor());
        int tempY2 = Math.round((float)y2 * this.view.getZoomFactor());
        tempX1 = this.view.contentsToViewX(tempX1);
        tempY1 = this.view.contentsToViewY(tempY1);
        tempX2 = this.view.contentsToViewX(tempX2);
        tempY2 = this.view.contentsToViewY(tempY2);
        byte code1 = this.code(tempX1, tempY1);
        byte code2 = this.code(tempX2, tempY2);
        boolean draw = false;
        boolean end = false;
        int x = 0;
        int y = 0;
        do {
            byte codex;
            if (code1 == 0 && code2 == 0) {
                draw = true;
                end = true;
                continue;
            }
            if ((code1 & code2) != 0) {
                end = true;
                continue;
            }
            byte by = codex = code1 != 0 ? code1 : code2;
            if ((codex & 1) != 0) {
                x = tempX1 + (tempX2 - tempX1) * (this.yx - tempY1) / (tempY2 - tempY1);
                y = this.yx;
            } else if ((codex & 2) != 0) {
                x = tempX1 + (tempX2 - tempX1) * (this.viewY - tempY1) / (tempY2 - tempY1);
                y = this.viewY;
            } else if ((codex & 4) != 0) {
                y = tempY1 + (tempY2 - tempY1) * (this.xx - tempX1) / (tempX2 - tempX1);
                x = this.xx;
            } else if ((codex & 8) != 0) {
                y = tempY1 + (tempY2 - tempY1) * (this.viewX - tempX1) / (tempX2 - tempX1);
                x = this.viewX;
            }
            if (codex == code1) {
                tempX1 = x;
                tempY1 = y;
                code1 = this.code(tempX1, tempY1);
                continue;
            }
            tempX2 = x;
            tempY2 = y;
            code2 = this.code(tempX2, tempY2);
        } while (!end);
        if (draw) {
            this.context.drawLine(tempX1, tempY1, tempX2, tempY2);
        }
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        int tempY;
        int tempX = Math.round((float)x * this.view.getZoomFactor());
        if (y != this.getContentsY()) {
            tempY = Math.round((float)y * this.view.getZoomFactor());
            tempY = this.view.contentsToViewY(tempY);
        } else {
            tempY = 0;
        }
        int tempWidth = Math.round((float)width * this.view.getZoomFactor());
        int tempHeight = Math.round((float)height * this.view.getZoomFactor());
        tempX = this.view.contentsToViewX(tempX);
        Rectangle rectangle = new Rectangle(tempX, tempY, tempWidth, tempHeight);
        this.transformRectangle(rectangle);
        this.context.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void transformRectangle(Rectangle rectangle) {
        if (rectangle.x < -vscreenBounds) {
            rectangle.width = rectangle.width + rectangle.x + vscreenBounds;
            rectangle.x = -vscreenBounds;
        }
        if (rectangle.y < -vscreenBounds) {
            rectangle.height = rectangle.height + rectangle.y + vscreenBounds;
            rectangle.y = -vscreenBounds;
        }
        if (rectangle.width < -vscreenBounds && rectangle.x + rectangle.width < -vscreenBounds) {
            rectangle.width = -vscreenBounds;
        } else if (rectangle.width + rectangle.x > this.view.getVisibleWidth() + vscreenBounds) {
            rectangle.width = this.view.getVisibleWidth() + vscreenBounds - rectangle.x;
        }
        if (rectangle.height < -vscreenBounds && rectangle.y + rectangle.height < -vscreenBounds) {
            rectangle.height = -vscreenBounds;
        } else if (rectangle.height + rectangle.y > this.view.getVisibleHeight() + vscreenBounds) {
            rectangle.height = this.view.getVisibleHeight() + vscreenBounds - rectangle.y;
        }
    }

    @Override
    public void drawFocus(int x, int y, int width, int height) {
    }

    @Override
    public void fillPolygon(int[] points) {
        int len = points.length / 2 * 2;
        int[] localPoint = new int[len];
        for (int i = 0; i < len; ++i) {
            localPoint[i] = this.view.contentsToViewX(Math.round((float)points[i] * this.view.getZoomFactor()));
            localPoint[++i] = this.view.contentsToViewY(Math.round((float)points[i] * this.view.getZoomFactor()));
        }
        this.context.fillPolygon(localPoint);
    }

    @Override
    public void drawPolygon(int[] points) {
        int len = points.length / 2 * 2;
        int[] localPoint = new int[len];
        for (int i = 0; i < len; ++i) {
            localPoint[i] = this.view.contentsToViewX(Math.round((float)points[i] * this.view.getZoomFactor()));
            localPoint[++i] = this.view.contentsToViewY(Math.round((float)points[i] * this.view.getZoomFactor()));
        }
        this.context.drawPolygon(localPoint);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        int tempY;
        int tempX = Math.round((float)x * this.view.getZoomFactor());
        if (y != this.getContentsY()) {
            tempY = Math.round((float)y * this.view.getZoomFactor());
            tempY = this.view.contentsToViewY(tempY) + 1;
        } else {
            tempY = 1;
        }
        int tempWidth = Math.round((float)width * this.view.getZoomFactor()) - 1;
        int tempHeight = Math.round((float)height * this.view.getZoomFactor()) - 1;
        tempX = this.view.contentsToViewX(tempX) + 1;
        Rectangle rectangle = new Rectangle(tempX, tempY, tempWidth, tempHeight);
        this.transformRectangle(rectangle);
        this.context.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        int tempX = Math.round((float)x * this.view.getZoomFactor());
        int tempY = Math.round((float)y * this.view.getZoomFactor());
        int tempWidth = Math.round((float)width * this.view.getZoomFactor());
        int tempHeight = Math.round((float)height * this.view.getZoomFactor());
        Color tempColor = this.foreGround;
        this.setForeground(this.gradientColor);
        tempX = this.view.contentsToViewX(tempX);
        tempY = this.view.contentsToViewY(tempY);
        if (vertical) {
            tempHeight = tempHeight > 0 ? ++tempHeight : --tempHeight;
            this.context.fillGradientRectangle(tempX, tempY, tempWidth, tempHeight, true);
            this.setForeground(tempColor);
        } else {
            Rectangle rectangle = new Rectangle(tempX, tempY, tempWidth, tempHeight);
            this.transformRectangle(rectangle);
            this.context.fillGradientRectangle(rectangle.x + rectangle.width, rectangle.y, -rectangle.width, rectangle.height + 1, false);
            this.setForeground(tempColor);
        }
    }

    @Override
    public int textExtent(String name) {
        return this.context.textExtent((String)name).x;
    }

    @Override
    public void drawText(String string, int x, int y, boolean trans) {
        int tempX = Math.round((float)x * this.view.getZoomFactor());
        int tempY = Math.round((float)y * this.view.getZoomFactor());
        this.context.drawText(string, this.view.contentsToViewX(tempX), this.view.contentsToViewY(tempY), trans);
        if (this.drawWithFocus) {
            Point r = this.context.textExtent(string);
            this.context.drawFocus(tempX - 1, tempY - 1, r.x + 2, r.y + 2);
        }
    }

    @Override
    public void drawText(String string, int x, int y) {
        int tempX = Math.round((float)x * this.view.getZoomFactor());
        int tempY = Math.round((float)y * this.view.getZoomFactor());
        this.context.drawText(string, this.view.contentsToViewX(tempX), this.view.contentsToViewY(tempY), true);
        if (this.drawWithFocus) {
            Point r = this.context.textExtent(string);
            this.context.drawFocus(tempX - 1, tempY - 1, r.x + 2, r.y + 2);
        }
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        int tempX = Math.round((float)x * this.view.getZoomFactor());
        int tempY = Math.round((float)y * this.view.getZoomFactor());
        int tempWidth = Math.round((float)width * this.view.getZoomFactor());
        int tempHeight = Math.round((float)height * this.view.getZoomFactor());
        this.context.fillOval(this.view.contentsToViewX(tempX), this.view.contentsToViewY(tempY), tempWidth, tempHeight);
    }

    @Override
    public Color getBackground() {
        if (this.backGround != null && !this.backGround.isDisposed()) {
            return this.foreGround;
        }
        return (Color)Activator.getDefault().getCachedResource("COLOR_WHITE");
    }

    @Override
    public Color getForeground() {
        if (this.foreGround != null && !this.foreGround.isDisposed()) {
            return this.foreGround;
        }
        return (Color)Activator.getDefault().getCachedResource("COLOR_BLACK");
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        if (!color.isDisposed()) {
            this.context.setBackground(color);
            this.backGround = color;
        }
    }

    @Override
    public void setForeground(Color color) {
        if (color == null) {
            return;
        }
        if (!color.isDisposed()) {
            this.context.setForeground(color);
            this.foreGround = color;
        }
    }

    @Override
    public void setGradientColor(Color color) {
        if (color == null) {
            return;
        }
        this.gradientColor = color;
    }

    @Override
    public void setLineWidth(int width) {
        this.context.setLineWidth(width);
    }

    @Override
    public int getLineWidth() {
        return this.context.getLineWidth();
    }

    private void localDrawText(String string, int x, int y, boolean trans) {
        Point r = this.context.textExtent(string);
        if (!trans) {
            this.context.fillRectangle(x, y, r.x, r.y);
        }
        this.context.drawText(string, x, y, trans);
        if (this.drawWithFocus && string.length() > 1) {
            this.context.drawFocus(x - 1, y - 1, r.x + 2, r.y + 2);
        }
    }

    @Override
    public void drawTextTruncatedCentred(String name, int oldX, int oldY, int width, int height, boolean trans) {
        Point tx = this.context.textExtent(name);
        Rectangle rectangle = this.createIncorporatingRectangle(oldX, oldY, width, height);
        if (tx.x <= rectangle.width) {
            this.localDrawText(name, rectangle.x + 1 + (rectangle.width - tx.x) / 2, rectangle.y + 1 + (rectangle.height - tx.y) / 2, trans);
        } else {
            String nameToDisplay = this.getNameToDisplay(name, rectangle.width);
            this.localDrawText(nameToDisplay, rectangle.x + 1 + (rectangle.width - this.context.textExtent((String)nameToDisplay).x) / 2, rectangle.y + 1 + (rectangle.height - this.context.textExtent((String)nameToDisplay).y) / 2, trans);
        }
    }

    private Rectangle createIncorporatingRectangle(int oldX, int oldY, int width, int height) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int tempX = Math.round((float)oldX * this.view.getZoomFactor());
        if (oldY != this.getContentsY()) {
            int tempY = Math.round((float)oldY * this.view.getZoomFactor());
            rectangle.y = this.view.contentsToViewY(tempY);
        }
        rectangle.width = Math.round((float)width * this.view.getZoomFactor());
        rectangle.height = Math.round((float)height * this.view.getZoomFactor());
        rectangle.x = this.view.contentsToViewX(tempX);
        return rectangle;
    }

    @Override
    public void drawTextTruncatedLeft(String name, int old_x, int old_y, int width, int height, boolean trans) {
        Point tx = this.context.textExtent(name);
        Rectangle rectangle = this.createIncorporatingRectangle(old_x, old_y, width, height);
        if (tx.x <= rectangle.width) {
            this.localDrawText(name, rectangle.x + 1, rectangle.y + 1 + (rectangle.height - tx.y) / 2, trans);
        } else {
            String nameToDisplay = this.getNameToDisplay(name, rectangle.width);
            this.localDrawText(nameToDisplay, rectangle.x + 1, rectangle.y + 1 + (rectangle.height - tx.y) / 2, trans);
        }
    }

    private String getNameToDisplay(String name, int tempWidth) {
        String nameToDisplay = name;
        for (int i = name.length() - 1; i >= 0 && this.context.textExtent((String)nameToDisplay).x >= tempWidth; --i) {
            nameToDisplay = name.substring(0, i);
        }
        int dotCount = 0;
        for (int i = 1; i <= 3 && nameToDisplay.length() - i > 0; ++i) {
            ++dotCount;
        }
        nameToDisplay = nameToDisplay.substring(0, nameToDisplay.length() - dotCount);
        nameToDisplay = this.addDots(nameToDisplay, dotCount);
        return nameToDisplay;
    }

    private String addDots(String nameToDisplay, int dotCount) {
        char[] chars = new char[dotCount];
        Arrays.fill(chars, '.');
        return nameToDisplay + new String(chars);
    }

    @Override
    public void drawTextTruncated(String name, int old_x, int old_y, int width, int height, boolean trans) {
        int tempX = Math.round((float)old_x * this.view.getZoomFactor());
        int tempY = Math.round((float)old_y * this.view.getZoomFactor());
        int tempWidth = Math.round((float)width * this.view.getZoomFactor());
        int tempHeight = Math.round((float)height * this.view.getZoomFactor());
        int x = this.view.contentsToViewX(tempX);
        int y = this.view.contentsToViewY(tempY);
        if (this.context.textExtent((String)name).x <= tempWidth) {
            this.localDrawText(name, x + 1, y + 1 + tempHeight, trans);
        } else {
            String nameToDisplay = this.getNameToDisplay(name, tempWidth);
            this.localDrawText(nameToDisplay, x + 1, y + 1 + tempHeight, trans);
        }
    }

    @Override
    public void setFont(Font font) {
        if (font != null && font.getFontData().length > 0) {
            FontData fontData = font.getFontData()[0];
            int h = Math.round((float)fontData.getHeight() * this.view.getZoomFactor());
            if (h > 0) {
                fontData.setHeight(h);
            }
            if (this.tempFont != null) {
                this.tempFont.dispose();
            }
            this.tempFont = new Font((Device)Display.getCurrent(), fontData);
            this.context.setFont(this.tempFont);
        }
    }

    public int getFontHeight(Font font) {
        if (font != null) {
            Font toRestore = this.context.getFont();
            this.context.setFont(font);
            int height = this.context.textExtent((String)"lp").y;
            this.context.setFont(toRestore);
            return height;
        }
        return 0;
    }

    @Override
    public int getFontWidth(Font font) {
        if (font != null) {
            Font toRestore = this.context.getFont();
            this.context.setFont(font);
            int width = this.context.getFontMetrics().getAverageCharWidth();
            this.context.setFont(toRestore);
            return width;
        }
        return 0;
    }

    public void dispose() {
        if (this.tempFont != null) {
            this.tempFont.dispose();
        }
        this.tempFont = null;
        if (this.context != null) {
            this.context.dispose();
        }
        this.context = null;
    }

    @Override
    public float getZoom() {
        if (this.view != null) {
            return this.view.getZoomFactor();
        }
        return 1.0f;
    }

    @Override
    public int getLineDotStyle() {
        return 3;
    }

    @Override
    public int getLineDashStyle() {
        return 2;
    }

    @Override
    public int getLineSolidStyle() {
        return 1;
    }
}

