/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.ResourcePropertyHandler;

public final class FilteredSilentEventUtils {
    private static final Map<String, String> OLD_TO_NEW_SILENT_EVENTS = new HashMap<String, String>();

    private FilteredSilentEventUtils() {
    }

    public static boolean hasPreferencesOldFilteredSilentEvents(IPreferenceStore preferenceStore) {
        Set<String> oldPrefKeys = OLD_TO_NEW_SILENT_EVENTS.keySet();
        for (String currPrefKey : oldPrefKeys) {
            if (!preferenceStore.contains(currPrefKey)) continue;
            return true;
        }
        return false;
    }

    public static String getOldFilteredSilentEventsFromPreferences(IPreferenceStore preferenceStore) {
        Map<String, Boolean> filteredSilentEvents = FilteredSilentEventUtils.getDefaultFilteredSilentEvents();
        FilteredSilentEventUtils.addOldFilteredSilentEventsFromPreferences(filteredSilentEvents, preferenceStore);
        return FilteredSilentEventUtils.hashMapToPreferenceString(filteredSilentEvents);
    }

    public static void clearOldFilteredSilentEventsInPreferences(IPreferenceStore preferenceStore) {
        Set<String> oldPrefKeys = OLD_TO_NEW_SILENT_EVENTS.keySet();
        for (String currPrefKey : oldPrefKeys) {
            preferenceStore.setToDefault(currPrefKey);
        }
    }

    public static boolean hasPropertiesOldFilteredSilentEvents(IResource resource, String pageId) {
        Set<String> oldPrefKeys = OLD_TO_NEW_SILENT_EVENTS.keySet();
        for (String currPrefKey : oldPrefKeys) {
            String currPrefValue = ResourcePropertyHandler.getProperty(resource, pageId, currPrefKey);
            if (currPrefValue == null) continue;
            return true;
        }
        return false;
    }

    public static String getOldFilteredSilentEventsFromResource(IResource resource, String pageId) {
        Map<String, Boolean> filteredSilentEvents = FilteredSilentEventUtils.getDefaultFilteredSilentEvents();
        FilteredSilentEventUtils.addOldFilteredSilentEventsFromResource(filteredSilentEvents, resource, pageId);
        return FilteredSilentEventUtils.hashMapToPreferenceString(filteredSilentEvents);
    }

    public static void clearOldFilteredSilentEventsPropertiesInResource(IResource resource, String pageId) {
        Set<String> oldPrefKeys = OLD_TO_NEW_SILENT_EVENTS.keySet();
        for (String currPrefKey : oldPrefKeys) {
            ResourcePropertyHandler.removeProperty(resource, pageId, currPrefKey);
        }
    }

    private static Map<String, Boolean> getDefaultFilteredSilentEvents() {
        String[] keyValuePairs;
        HashMap<String, Boolean> silentEventFilters = new HashMap<String, Boolean>();
        for (String keyValuePair : keyValuePairs = "ACTION=false;ACTION_UNQUALIFIED=false;DEBUG=false;DEBUG_ENCDEC=false;DEBUG_UNQUALIFIED=false;DEFAULTOP=false;DEFAULTOP_ACTIVATE=false;DEFAULTOP_DEACTIVATE=false;DEFAULTOP_EXIT=false;DEFAULTOP_UNQUALIFIED=false;ERROR=false;ERROR_UNQUALIFIED=false;EXECUTOR=false;EXECUTOR_COMPONENT=false;EXECUTOR_CONFIGDATA=false;EXECUTOR_EXTCOMMAND=false;EXECUTOR_LOGOPTIONS=false;EXECUTOR_RUNTIME=false;EXECUTOR_UNQUALIFIED=false;FUNCTION=false;FUNCTION_RND=false;FUNCTION_UNQUALIFIED=false;MATCHING=false;MATCHING_DONE=false;MATCHING_MCSUCCESS=false;MATCHING_MCUNSUCC=false;MATCHING_MMSUCCESS=false;MATCHING_MMUNSUCC=false;MATCHING_PCSUCCESS=false;MATCHING_PCUNSUCC=false;MATCHING_PMSUCCESS=false;MATCHING_PMUNSUCC=false;MATCHING_PROBLEM=false;MATCHING_TIMEOUT=false;MATCHING_UNQUALIFIED=false;PARALLEL=false;PARALLEL_PTC=false;PARALLEL_PORTCONN=false;PARALLEL_PORTMAP=false;PARALLEL_UNQUALIFIED=false;PORTEVENT=false;PORTEVENT_DUALRECV=false;PORTEVENT_DUALSEND=false;PORTEVENT_MCRECV=false;PORTEVENT_MCSEND=false;PORTEVENT_MMRECV=false;PORTEVENT_MMSEND=false;PORTEVENT_MQUEUE=false;PORTEVENT_PCIN=false;PORTEVENT_PCOUT=false;PORTEVENT_PMIN=false;PORTEVENT_PMOUT=false;PORTEVENT_PQUEUE=false;PORTEVENT_STATE=false;PORTEVENT_UNQUALIFIED=false;STATISTICS=false;STATISTICS_VERDICT=false;STATISTICS_UNQUALIFIED=false;TESTCASE=false;TESTCASE_START=false;TESTCASE_FINISH=false;TESTCASE_UNQUALIFIED=false;TIMEROP=false;TIMEROP_GUARD=false;TIMEROP_READ=false;TIMEROP_START=false;TIMEROP_STOP=false;TIMEROP_TIMEOUT=false;TIMEROP_UNQUALIFIED=false;UNKNOWN=false;USER=false;USER_UNQUALIFIED=false;VERDICTOP=false;VERDICTOP_FINAL=false;VERDICTOP_GETVERDICT=false;VERDICTOP_SETVERDICT=false;VERDICTOP_UNQUALIFIED=false;WARNING=false;WARNING_UNQUALIFIED=false".split(";")) {
            String[] currKeyValue = keyValuePair.split("=");
            if (currKeyValue.length != 2) continue;
            silentEventFilters.put(currKeyValue[0], Boolean.valueOf(currKeyValue[1]));
        }
        return silentEventFilters;
    }

    private static void addOldFilteredSilentEventsFromPreferences(Map<String, Boolean> filteredSilentEvents, IPreferenceStore preferenceStore) {
        SortedMap<String, String[]> eventCategories = Constants.EVENT_CATEGORIES;
        Set<String> oldPrefKeys = OLD_TO_NEW_SILENT_EVENTS.keySet();
        for (String currPrefKey : oldPrefKeys) {
            String[] subCategories;
            String currCatName = OLD_TO_NEW_SILENT_EVENTS.get(currPrefKey);
            Boolean currPrefValue = preferenceStore.getBoolean(currPrefKey);
            filteredSilentEvents.put(currCatName, currPrefValue);
            for (String subCategory : subCategories = (String[])eventCategories.get(currCatName)) {
                filteredSilentEvents.put(currCatName.concat("_".concat(subCategory)), currPrefValue);
            }
        }
    }

    private static String hashMapToPreferenceString(Map<String, Boolean> filteredSilentEvents) {
        StringBuilder builder = new StringBuilder();
        String filters = "";
        for (Map.Entry<String, Boolean> entry : filteredSilentEvents.entrySet()) {
            if (builder.length() == 0) {
                builder.setLength(0);
                builder.append(entry.getKey()).append("=").append(entry.getValue());
                continue;
            }
            builder.append(filters).append(";").append(entry.getKey()).append("=").append(entry.getValue());
        }
        filteredSilentEvents.clear();
        return filters;
    }

    private static void addOldFilteredSilentEventsFromResource(Map<String, Boolean> filteredSilentEvents, IResource resource, String pageId) {
        SortedMap<String, String[]> eventCategories = Constants.EVENT_CATEGORIES;
        Set<String> oldPrefKeys = OLD_TO_NEW_SILENT_EVENTS.keySet();
        for (String currPrefKey : oldPrefKeys) {
            String[] subCategories;
            String currCatName = OLD_TO_NEW_SILENT_EVENTS.get(currPrefKey);
            String value = ResourcePropertyHandler.getProperty(resource, pageId, currPrefKey);
            if (value == null) continue;
            Boolean currPrefValue = Boolean.valueOf(value);
            filteredSilentEvents.put(currCatName, currPrefValue);
            for (String subCategory : subCategories = (String[])eventCategories.get(currCatName)) {
                filteredSilentEvents.put(currCatName.concat("_".concat(subCategory)), currPrefValue);
            }
        }
    }

    static {
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_error", "ERROR");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_function", "FUNCTION");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_action", "ACTION");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_user", "USER");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_warning", "WARNING");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_unknown", "UNKNOWN");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_executor", "EXECUTOR");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_timerop", "TIMEROP");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_verdictop", "VERDICTOP");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_deafultop", "DEFAULTOP");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_portevent", "PORTEVENT");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_testcase", "TESTCASE");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_statistics", "STATISTICS");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_parallel", "PARALLEL");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_matching", "MATCHING");
        OLD_TO_NEW_SILENT_EVENTS.put("org.eclipse.titan.log.viewer_filter_silentevent_debug", "DEBUG");
    }
}

