/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.lens.Lens;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class RouteLens {
    Lens lens;
    View view;
    Camera camera;
    ArrayList<DPath> routes;
    ArrayList<GeneralPath> routeSegments;
    double delta;
    static final int DEFAULT_P = 2;
    int param_p = 2;
    boolean enabled = true;
    Point2D.Double cursorInVS = new Point2D.Double();
    Point lensCenterInPanel = new Point();

    public static ArrayList<GeneralPath> cutPath(GeneralPath path) {
        ArrayList<GeneralPath> paths = new ArrayList<GeneralPath>();
        PathIterator pathIterator = path.getPathIterator(null);
        Point2D lastPoint = null;
        double[] coords = new double[6];
        GeneralPath subGP = null;
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    lastPoint = new Point2D.Double(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    subGP = new GeneralPath();
                    subGP.moveTo(lastPoint.getX(), lastPoint.getY());
                    subGP.lineTo(coords[0], coords[1]);
                    lastPoint = new Point2D.Double(coords[0], coords[1]);
                    paths.add(subGP);
                    break;
                }
                case 2: {
                    subGP = new GeneralPath();
                    subGP.moveTo(lastPoint.getX(), lastPoint.getY());
                    subGP.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    lastPoint = new Point2D.Double(coords[2], coords[3]);
                    paths.add(subGP);
                    break;
                }
                case 3: {
                    subGP = new GeneralPath();
                    subGP.moveTo(lastPoint.getX(), lastPoint.getY());
                    subGP.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    lastPoint = new Point2D.Double(coords[4], coords[5]);
                    paths.add(subGP);
                    break;
                }
                default: {
                    System.out.println("unexpected segment type: " + type);
                }
            }
            pathIterator.next();
        }
        return paths;
    }

    public static GeneralPath concatPath(GeneralPath path1, GeneralPath path2) {
        GeneralPath path = (GeneralPath)path1.clone();
        PathIterator pathIterator = path2.getPathIterator(null);
        double[] coords = new double[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    path.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                default: {
                    System.out.println("unexpected segment type: " + type);
                }
            }
            pathIterator.next();
        }
        return path;
    }

    public static Point2D getClosestPoint(Point2D pt, GeneralPath path, double maxSegmentLength) {
        ArrayList<Point2D> points = RouteLens.getPoints(path, maxSegmentLength);
        Point2D closest = null;
        double minDis = Double.MAX_VALUE;
        for (Point2D p : points) {
            double d = p.distance(pt);
            if (!(d < minDis)) continue;
            minDis = d;
            closest = p;
        }
        return closest;
    }

    public static ArrayList<Point2D> getPoints(GeneralPath path, double maxSegmentLength) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        PathIterator pathIterator = path.getPathIterator(null, 0.1);
        double[] coords = new double[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    points.add(new Point2D.Double(coords[0], coords[1]));
                    break;
                }
                case 1: {
                    points.addAll(RouteLens.resample(points.get(points.size() - 1), new Point2D.Double(coords[0], coords[1]), maxSegmentLength));
                    break;
                }
                default: {
                    System.out.println("unexpected segment type: " + type);
                }
            }
            pathIterator.next();
        }
        return points;
    }

    static Point2D[] getLensPosition(GeneralPath route, Point2D C, double delta, int p, ArrayList<Point2D> attractionPoints, ArrayList<Point2D> attractionValues, Point2D overallAttraction) {
        Point2D L = C;
        Point2D Rc = null;
        Point2D closest = null;
        double dmin = Double.MAX_VALUE;
        int n = 0;
        Point2D.Double A = new Point2D.Double(0.0, 0.0);
        ArrayList<GeneralPath> routeSegments = RouteLens.cutPath(route);
        double sumWeights = 0.0;
        for (GeneralPath routeSegment : routeSegments) {
            Point2D closestPointOnSegment = RouteLens.getClosestPoint(C, routeSegment, 5.0);
            double distanceToSegment = closestPointOnSegment.distance(C);
            if (!(distanceToSegment < delta)) continue;
            Rc = closestPointOnSegment;
            double dc = distanceToSegment;
            double alpha = 1.0 - Math.pow(dc / delta, p);
            Point2D.Double Ai = new Point2D.Double(alpha * (Rc.getX() - C.getX()) / dc, alpha * (Rc.getY() - C.getY()) / dc);
            double weight = delta - dc;
            sumWeights += weight;
            ((Point2D)A).setLocation(((Point2D)A).getX() + weight * ((Point2D)Ai).getX(), ((Point2D)A).getY() + weight * ((Point2D)Ai).getY());
            attractionPoints.add(Rc);
            attractionValues.add(Ai);
            if (dc < dmin) {
                dmin = dc;
                closest = closestPointOnSegment;
            }
            ++n;
        }
        Point2D[] res = new Point2D[2];
        if (n != 0) {
            L = new Point2D.Double(C.getX() + dmin * ((Point2D)A).getX() / sumWeights, C.getY() + dmin * ((Point2D)A).getY() / sumWeights);
            overallAttraction.setLocation(dmin * ((Point2D)A).getX() / sumWeights, dmin * ((Point2D)A).getY() / sumWeights);
        }
        res[0] = L;
        res[1] = closest;
        return res;
    }

    public static Point2D getLensPosition(GeneralPath route, Point2D C, double delta, int p) {
        ArrayList<GeneralPath> routeSegments = RouteLens.cutPath(route);
        return RouteLens.getLensPosition(routeSegments, C, delta, p);
    }

    public static Point2D getLensPosition(ArrayList<GeneralPath> routeSegments, Point2D C, double delta, int p) {
        Point2D L = C;
        Point2D Rc = null;
        double dmin = Double.MAX_VALUE;
        int n = 0;
        Point2D.Double A = new Point2D.Double(0.0, 0.0);
        double sumWeights = 0.0;
        for (GeneralPath routeSegment : routeSegments) {
            Point2D closestPointOnSegment = RouteLens.getClosestPoint(C, routeSegment, 5.0);
            double distanceToSegment = closestPointOnSegment.distance(C);
            if (!(distanceToSegment < delta)) continue;
            Rc = closestPointOnSegment;
            double dc = distanceToSegment;
            double alpha = 1.0 - Math.pow(dc / delta, p);
            Point2D.Double Ai = new Point2D.Double(alpha * (Rc.getX() - C.getX()) / dc, alpha * (Rc.getY() - C.getY()) / dc);
            double weight = delta - dc;
            sumWeights += weight;
            ((Point2D)A).setLocation(((Point2D)A).getX() + weight * ((Point2D)Ai).getX(), ((Point2D)A).getY() + weight * ((Point2D)Ai).getY());
            if (dc < dmin) {
                dmin = dc;
            }
            ++n;
        }
        if (n != 0) {
            L = new Point2D.Double(C.getX() + dmin * ((Point2D)A).getX() / sumWeights, C.getY() + dmin * ((Point2D)A).getY() / sumWeights);
        }
        return L;
    }

    public static ArrayList<Point2D> resample(Point2D pt1, Point2D pt2, double maxSegmentLength) {
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>();
        double d = pt1.distance(pt2);
        if (d < maxSegmentLength) {
            newPoints.add(pt2);
            return newPoints;
        }
        int nPoints = (int)(d / maxSegmentLength);
        for (int i = 1; i < nPoints; ++i) {
            double x = pt1.getX() + (double)i * maxSegmentLength / d * (pt2.getX() - pt1.getX());
            double y = pt1.getY() + (double)i * maxSegmentLength / d * (pt2.getY() - pt1.getY());
            newPoints.add(new Point2D.Double(x, y));
        }
        if ((double)(nPoints - 1) * maxSegmentLength < d) {
            newPoints.add(pt2);
        }
        return newPoints;
    }

    public RouteLens(Lens l, Camera c, double mad, int p) {
        this.lens = l;
        this.camera = c;
        this.view = c.getOwningView();
        this.delta = mad;
        this.param_p = p;
        this.routeSegments = new ArrayList();
        this.routes = new ArrayList();
    }

    public RouteLens(Lens l, Camera c) {
        this.lens = l;
        this.camera = c;
        this.view = c.getOwningView();
        this.delta = l.getRadius();
        this.param_p = 2;
        this.routeSegments = new ArrayList();
        this.routes = new ArrayList();
    }

    public void moveLens(int x, int y) {
        if (this.enabled) {
            this.view.fromPanelToVSCoordinates(x, y, this.camera, this.cursorInVS);
            Point2D lensCenterInVS = RouteLens.getLensPosition(this.routeSegments, (Point2D)this.cursorInVS, this.delta * (this.camera.altitude + this.camera.focal) / this.camera.focal, this.param_p);
            this.view.fromVSToPanelCoordinates(lensCenterInVS.getX(), lensCenterInVS.getY(), this.camera, this.lensCenterInPanel);
            this.lens.setAbsolutePosition(this.lensCenterInPanel.x, this.lensCenterInPanel.y);
        } else {
            this.lens.setAbsolutePosition(x, y);
        }
        this.view.repaint();
    }

    protected void updateGeneralPath() {
        GeneralPath route = this.routes.get(0).getJava2DGeneralPath();
        for (int i = 1; i < this.routes.size(); ++i) {
            DPath path = this.routes.get(i);
            route = RouteLens.concatPath(route, path.getJava2DGeneralPath());
        }
        this.routeSegments = RouteLens.cutPath(route);
    }

    public void addRoute(DPath route) {
        this.routes.add(route);
        this.updateGeneralPath();
    }

    public void removeRoute(DPath route) {
        this.routes.remove(route);
        this.updateGeneralPath();
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getMad() {
        return this.delta;
    }

    public void setMad(double mad) {
        this.delta = mad;
    }

    public int getP() {
        return this.param_p;
    }

    public void setP(int p) {
        this.param_p = p;
    }
}

