/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.lens.BLinearLens;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class HLinearLens
extends BLinearLens {
    protected float a = 0.0f;
    protected float b = 0.0f;

    public HLinearLens() {
    }

    public HLinearLens(float mm) {
        super(mm);
    }

    public HLinearLens(float mm, float tc, float tf, int outerRadius, int innerRadius) {
        super(mm, tc, tf, outerRadius, innerRadius);
    }

    public HLinearLens(float mm, float tc, float tf, int outerRadius, int innerRadius, int x, int y) {
        super(mm, tc, tf, outerRadius, innerRadius, x, y);
    }

    @Override
    void computeDropoffFactors() {
        this.a = (1.0f - this.MM) / (float)(this.LR1 - this.LR2);
        this.b = (this.MM * (float)this.LR1 - (float)this.LR2) / (float)(this.LR1 - this.LR2);
        this.aT = (this.MMTc - this.MMTf) / (float)(this.LR1 - this.LR2);
        this.bT = (this.MMTf * (float)this.LR1 - this.MMTc * (float)this.LR2) / (float)(this.LR1 - this.LR2);
    }

    @Override
    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.MM;
        } else if (this.d <= (double)this.LR1) {
            g[0] = g[1] = this.a * (float)this.d + this.b;
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }

    @Override
    public void gfT(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        g[0] = this.d <= (double)this.LR2 ? this.MMTf : (this.d <= (double)this.LR1 ? this.aT * (float)this.d + this.bT : 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void transformI(WritableRaster iwr, WritableRaster ewr) {
        HLinearLens hLinearLens = this;
        synchronized (hLinearLens) {
            if (this.BMl == null) {
                SinglePixelPackedSampleModel SMl = (SinglePixelPackedSampleModel)ewr.getSampleModel();
                SinglePixelPackedSampleModel SMm = (SinglePixelPackedSampleModel)iwr.getSampleModel();
                this.BMl = SMl.getBitMasks();
                this.BMm = SMm.getBitMasks();
                this.BOl = SMl.getBitOffsets();
                this.BOm = SMm.getBitOffsets();
            }
            iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsI);
            ewr.getDataElements(0, 0, this.mbw, this.mbh, this.mPixelsI);
            if (this.BMl.length == 4) {
                for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
                    for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                        this.gf(x, y, this.gain);
                        this.Pl = this.mPixelsI[Math.round(((float)(y - this.lurd[1]) * this.MM - this.hmbh) / this.gain[1] + this.hmbh) * this.mbw + Math.round(((float)(x - this.lurd[0]) * this.MM - this.hmbw) / this.gain[0] + this.hmbw)];
                        this.Rl = (this.Pl & this.BMl[0]) >>> this.BOl[0];
                        this.Gl = (this.Pl & this.BMl[1]) >>> this.BOl[1];
                        this.Bl = (this.Pl & this.BMl[2]) >>> this.BOl[2];
                        this.Pm = this.oPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])];
                        this.Rm = (this.Pm & this.BMm[0]) >>> this.BOm[0];
                        this.Gm = (this.Pm & this.BMm[1]) >>> this.BOm[1];
                        this.Bm = (this.Pm & this.BMm[2]) >>> this.BOm[2];
                        this.Am = (this.Pm & this.BMm[3]) >>> this.BOm[3];
                        this.gfT(x, y, this.gainT);
                        this.Rr = Math.round((float)this.Rl * this.gainT[0] + (float)this.Rm * (1.0f - this.gainT[0]));
                        this.Gr = Math.round((float)this.Gl * this.gainT[0] + (float)this.Gm * (1.0f - this.gainT[0]));
                        this.Br = Math.round((float)this.Bl * this.gainT[0] + (float)this.Bm * (1.0f - this.gainT[0]));
                        this.tPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.Rr << this.BOm[0] | this.Gr << this.BOl[1] | this.Br << this.BOl[2] | this.Am << this.BOl[3];
                    }
                }
            } else {
                for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
                    for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                        this.gf(x, y, this.gain);
                        this.Pl = this.mPixelsI[Math.round(((float)(y - this.lurd[1]) * this.MM - this.hmbh) / this.gain[1] + this.hmbh) * this.mbw + Math.round(((float)(x - this.lurd[0]) * this.MM - this.hmbw) / this.gain[0] + this.hmbw)];
                        this.Rl = (this.Pl & this.BMl[0]) >>> this.BOl[0];
                        this.Gl = (this.Pl & this.BMl[1]) >>> this.BOl[1];
                        this.Bl = (this.Pl & this.BMl[2]) >>> this.BOl[2];
                        this.Pm = this.oPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])];
                        this.Rm = (this.Pm & this.BMm[0]) >>> this.BOm[0];
                        this.Gm = (this.Pm & this.BMm[1]) >>> this.BOm[1];
                        this.Bm = (this.Pm & this.BMm[2]) >>> this.BOm[2];
                        this.gfT(x, y, this.gainT);
                        this.Rr = Math.round((float)this.Rl * this.gainT[0] + (float)this.Rm * (1.0f - this.gainT[0]));
                        this.Gr = Math.round((float)this.Gl * this.gainT[0] + (float)this.Gm * (1.0f - this.gainT[0]));
                        this.Br = Math.round((float)this.Bl * this.gainT[0] + (float)this.Bm * (1.0f - this.gainT[0]));
                        this.tPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.Rr << this.BOm[0] | this.Gr << this.BOl[1] | this.Br << this.BOl[2];
                    }
                }
            }
            iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void transformS(WritableRaster iwr, WritableRaster ewr) {
        HLinearLens hLinearLens = this;
        synchronized (hLinearLens) {
            if (this.BMl == null) {
                SinglePixelPackedSampleModel SMl = (SinglePixelPackedSampleModel)ewr.getSampleModel();
                SinglePixelPackedSampleModel SMm = (SinglePixelPackedSampleModel)iwr.getSampleModel();
                this.BMl = SMl.getBitMasks();
                this.BMm = SMm.getBitMasks();
                this.BOl = SMl.getBitOffsets();
                this.BOm = SMm.getBitOffsets();
            }
            iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsS);
            ewr.getDataElements(0, 0, this.mbw, this.mbh, this.mPixelsS);
            for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
                for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                    this.gf(x, y, this.gain);
                    this.Pl = this.mPixelsS[Math.round(((float)(y - this.lurd[1]) * this.MM - this.hmbh) / this.gain[1] + this.hmbh) * this.mbw + Math.round(((float)(x - this.lurd[0]) * this.MM - this.hmbw) / this.gain[0] + this.hmbw)];
                    this.Rl = (this.Pl & this.BMl[0]) >>> this.BOl[0];
                    this.Gl = (this.Pl & this.BMl[1]) >>> this.BOl[1];
                    this.Bl = (this.Pl & this.BMl[2]) >>> this.BOl[2];
                    this.Pm = this.oPixelsS[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])];
                    this.Rm = (this.Pm & this.BMm[0]) >>> this.BOm[0];
                    this.Gm = (this.Pm & this.BMm[1]) >>> this.BOm[1];
                    this.Bm = (this.Pm & this.BMm[2]) >>> this.BOm[2];
                    this.gfT(x, y, this.gainT);
                    this.Rr = Math.round((float)this.Rl * this.gainT[0] + (float)this.Rm * (1.0f - this.gainT[0]));
                    this.Gr = Math.round((float)this.Gl * this.gainT[0] + (float)this.Gm * (1.0f - this.gainT[0]));
                    this.Br = Math.round((float)this.Bl * this.gainT[0] + (float)this.Bm * (1.0f - this.gainT[0]));
                    this.tPixelsS[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = (short)(this.Rr << this.BOm[0] | this.Gr << this.BOl[1] | this.Br << this.BOl[2]);
                }
            }
            iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsS);
        }
    }
}

