/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.projection.ProjRing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class VRing<T>
extends ClosedShape {
    public int[] xpcoords;
    public int[] ypcoords;
    public static final double RAD2DEG_FACTOR = 57.29577951308232;
    public static final double DEG2RAD_FACTOR = Math.PI / 180;
    public Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
    public Point2D.Double p2 = new Point2D.Double(0.0, 0.0);
    public Point2D.Double p3 = new Point2D.Double(0.0, 0.0);
    public Point2D.Double p4 = new Point2D.Double(0.0, 0.0);
    public double angle;
    public double orient;
    public int angleDeg;
    public int orientDeg;
    ProjRing[] pr;
    float irr_p;
    Arc2D outerSlice = new Arc2D.Double(2);
    Ellipse2D innerSlice = new Ellipse2D.Double();
    Area subring;

    public VRing(double x, double y, int z, double vs, double ag, float irr, double or, Color c, Color bc) {
        this(x, y, z, vs, ag, irr, or, c, bc, 1.0f);
    }

    public VRing(double x, double y, int z, double vs, double ag, float irr, double or, Color c, Color bc, float alpha) {
        this.initCoordArray(4);
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = vs;
        this.irr_p = irr;
        this.orient = or;
        this.orientDeg = (int)Math.round(this.orient * 57.29577951308232);
        this.angle = ag;
        this.angleDeg = (int)Math.round(this.angle * 57.29577951308232);
        this.setColor(c);
        this.setBorderColor(bc);
        this.setTranslucencyValue(alpha);
    }

    public VRing(double x, double y, int z, double vs, int ag, float irr, int or, Color c, Color bc) {
        this(x, y, z, vs, ag, irr, or, c, bc, 1.0f);
    }

    public VRing(double x, double y, int z, double vs, int ag, float irr, int or, Color c, Color bc, float alpha) {
        this.initCoordArray(4);
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = vs;
        this.irr_p = irr;
        this.orient = (double)or * (Math.PI / 180);
        this.orientDeg = or;
        this.angle = (double)ag * (Math.PI / 180);
        this.angleDeg = ag;
        this.setColor(c);
        this.setBorderColor(bc);
        this.setTranslucencyValue(alpha);
    }

    public void initCoordArray(int n) {
        this.xpcoords = new int[n];
        this.ypcoords = new int[n];
    }

    @Override
    public void initCams(int nbCam) {
        this.pr = new ProjRing[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pr[i] = new ProjRing();
        }
    }

    public float getInnerRatio() {
        return this.irr_p;
    }

    void computeSize() {
        this.size = Math.sqrt((this.p1.x - this.vx) * (this.p1.x - this.vx) + (this.p1.y - this.vy) * (this.p1.y - this.vy));
    }

    void computeOrient() {
        double c = Math.sqrt((this.p1.x - this.vx) * (this.p1.x - this.vx) + (this.p1.y - this.vy) * (this.p1.y - this.vy));
        double a1 = this.p1.y - this.vy >= 0.0 ? Math.acos((this.p1.x - this.vx) / c) : Math.PI * 2 - Math.acos((this.p1.x - this.vx) / c);
        double a2 = this.p2.y - this.vy >= 0.0 ? Math.acos((this.p2.x - this.vx) / c) : Math.PI * 2 - Math.acos((this.p2.x - this.vx) / c);
        this.orient = (a1 + a2) / 2.0;
        this.orientDeg = (int)Math.round(this.orient * 57.29577951308232);
    }

    void computeAngle() {
        double c = Math.sqrt((this.p1.x - this.vx) * (this.p1.x - this.vx) + (this.p1.y - this.vy) * (this.p1.y - this.vy));
        double a1 = this.p1.y - this.vy >= 0.0 ? Math.acos((this.p1.x - this.vx) / c) : Math.PI * 2 - Math.acos((this.p1.x - this.vx) / c);
        double a2 = this.p2.y - this.vy >= 0.0 ? Math.acos((this.p2.x - this.vx) / c) : Math.PI * 2 - Math.acos((this.p2.x - this.vx) / c);
        this.angle = a2 - a1;
        this.angleDeg = (int)Math.round(this.angle * 57.29577951308232);
    }

    void computeSliceEdges() {
        this.p1.x = Math.cos(this.orient - this.angle / 2.0) * this.size + this.vx;
        this.p1.y = Math.sin(this.orient - this.angle / 2.0) * this.size + this.vy;
        this.p2.x = Math.cos(this.orient + this.angle / 2.0) * this.size + this.vx;
        this.p2.y = Math.sin(this.orient + this.angle / 2.0) * this.size + this.vy;
    }

    void computePolygonEdges() {
        if (this.angle < Math.PI) {
            this.p3.x = this.vx + (this.p1.x - this.vx) / Math.cos(this.angle / 2.0);
            this.p3.y = this.vy + (this.p1.y - this.vy) / Math.cos(this.angle / 2.0);
            this.p4.x = this.vx + (this.p2.x - this.vx) / Math.cos(this.angle / 2.0);
            this.p4.y = this.vy + (this.p2.y - this.vy) / Math.cos(this.angle / 2.0);
        } else if (this.angle > Math.PI) {
            this.p3.x = this.vx - (this.p1.x - this.vx) / Math.cos(this.angle / 2.0);
            this.p3.y = this.vy - (this.p1.y - this.vy) / Math.cos(this.angle / 2.0);
            this.p4.x = this.vx - (this.p2.x - this.vx) / Math.cos(this.angle / 2.0);
            this.p4.y = this.vy - (this.p2.y - this.vy) / Math.cos(this.angle / 2.0);
        } else {
            this.p3.x = this.p1.x;
            this.p3.y = this.p1.y;
            this.p4.x = this.p2.x;
            this.p4.y = this.p2.y;
        }
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pr != null) {
            if (verifIndex == this.pr.length) {
                ProjRing[] ta = this.pr;
                this.pr = new ProjRing[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pr[i] = ta[i];
                }
                this.pr[this.pr.length - 1] = new ProjRing();
            } else {
                System.err.println("VRing:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pr = new ProjRing[1];
            this.pr[0] = new ProjRing();
        } else {
            System.err.println("VRing:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pr[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pr.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pr[i] != null) {
            this.pr[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        this.computeSliceEdges();
        this.computePolygonEdges();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        this.computeSliceEdges();
        this.computePolygonEdges();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void orientTo(double ag) {
        this.orient = ag > Math.PI * 2 ? ag % (Math.PI * 2) : ag;
        this.orientDeg = (int)Math.round(this.orient * 57.29577951308232);
        this.computeSliceEdges();
        this.computePolygonEdges();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void setAngle(double ag) {
        this.angle = ag > Math.PI * 2 ? ag % (Math.PI * 2) : ag;
        this.angleDeg = (int)Math.round(this.angle * 57.29577951308232);
        this.computeSliceEdges();
        this.computePolygonEdges();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    public boolean coordInsideHemisphere(int x, int y, int camIndex) {
        if (this.orient == 0.0) {
            return x >= this.pr[camIndex].cx;
        }
        if (this.orient == Math.PI) {
            return x <= this.pr[camIndex].cx;
        }
        double a = (this.pr[camIndex].p2y - this.pr[camIndex].p1y) / (this.pr[camIndex].p2x - this.pr[camIndex].p1x);
        double b = (this.pr[camIndex].p1y * this.pr[camIndex].p2x - this.pr[camIndex].p2y * this.pr[camIndex].p1x) / (this.pr[camIndex].p2x - this.pr[camIndex].p1x);
        return this.orient < Math.PI && (double)y <= a * (double)x + b || this.orient > Math.PI && (double)y >= a * (double)x + b;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return Math.sqrt((jpx - this.pr[camIndex].cx) * (jpx - this.pr[camIndex].cx) + (jpy - this.pr[camIndex].cy) * (jpy - this.pr[camIndex].cy)) <= (double)this.pr[camIndex].outerCircleRadius && this.pr[camIndex].ring.contains(jpx, jpy);
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        if (Math.sqrt((this.vx - dvx) * (this.vx - dvx) + (this.vy - dvy) * (this.vy - dvy)) < dvr + this.size) {
            return this.pr[camIndex].ring.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
        }
        return false;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pr[camIndex].prevMouseIn) {
                this.pr[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pr[camIndex].prevMouseIn) {
            this.pr[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        int hw = d.width / 2;
        int hh = d.height / 2;
        this.pr[i].cx = hw + (int)Math.round((this.vx - c.vx) * this.coef);
        this.pr[i].cy = hh - (int)Math.round((this.vy - c.vy) * this.coef);
        this.pr[i].outerCircleRadius = (int)Math.round(this.size * this.coef);
        this.pr[i].innerRingRadius = (int)Math.round(this.size * (double)this.irr_p * this.coef);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        int hw = lensWidth / 2;
        int hh = lensHeight / 2;
        this.pr[i].lcx = hw + (int)Math.round((this.vx - lensx) * this.coef);
        this.pr[i].lcy = hh - (int)Math.round((this.vy - lensy) * this.coef);
        this.pr[i].louterCircleRadius = (int)Math.round(this.size * this.coef);
        this.pr[i].linnerRingRadius = (int)Math.round(this.size * (double)this.irr_p * this.coef);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pr[i].outerCircleRadius > 2) {
            if (this.isFilled()) {
                this.outerSlice.setArc(dx + this.pr[i].cx - this.pr[i].outerCircleRadius, dy + this.pr[i].cy - this.pr[i].outerCircleRadius, 2 * this.pr[i].outerCircleRadius, 2 * this.pr[i].outerCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg, 2);
                this.innerSlice.setFrame(dx + this.pr[i].cx - this.pr[i].innerRingRadius, dy + this.pr[i].cy - this.pr[i].innerRingRadius, 2 * this.pr[i].innerRingRadius, 2 * this.pr[i].innerRingRadius);
                this.pr[i].ring = new Area(this.outerSlice);
                if (this.pr[i].innerRingRadius > 0) {
                    this.subring = new Area(this.innerSlice);
                    this.pr[i].ring.subtract(this.subring);
                }
                g.setColor(this.color);
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    g.fill(this.pr[i].ring);
                    g.setComposite(acO);
                } else {
                    g.fill(this.pr[i].ring);
                }
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    if (this.alphaC != null) {
                        g.setComposite(this.alphaC);
                        g.draw(this.pr[i].ring);
                        g.setComposite(acO);
                    } else {
                        g.draw(this.pr[i].ring);
                    }
                    g.setStroke(stdS);
                } else if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    g.draw(this.pr[i].ring);
                    g.setComposite(acO);
                } else {
                    g.draw(this.pr[i].ring);
                }
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            g.setColor(this.color);
            g.fillRect(dx + this.pr[i].cx, dy + this.pr[i].cy, 1, 1);
            g.setComposite(acO);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pr[i].cx, dy + this.pr[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pr[i].louterCircleRadius > 2) {
            if (this.isFilled()) {
                this.outerSlice.setArc(dx + this.pr[i].lcx - this.pr[i].louterCircleRadius, dy + this.pr[i].lcy - this.pr[i].louterCircleRadius, 2 * this.pr[i].louterCircleRadius, 2 * this.pr[i].louterCircleRadius, (int)Math.round((double)this.orientDeg - (double)this.angleDeg / 2.0), this.angleDeg, 2);
                this.innerSlice.setFrame(dx + this.pr[i].lcx - this.pr[i].linnerRingRadius, dy + this.pr[i].lcy - this.pr[i].linnerRingRadius, 2 * this.pr[i].linnerRingRadius, 2 * this.pr[i].linnerRingRadius);
                this.pr[i].lring = new Area(this.outerSlice);
                if (this.pr[i].linnerRingRadius > 0) {
                    this.subring = new Area(this.innerSlice);
                    this.pr[i].lring.subtract(this.subring);
                }
                g.setColor(this.color);
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    g.fill(this.pr[i].lring);
                    g.setComposite(acO);
                } else {
                    g.fill(this.pr[i].lring);
                }
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    if (this.alphaC != null) {
                        g.setComposite(this.alphaC);
                        g.draw(this.pr[i].lring);
                        g.setComposite(acO);
                    } else {
                        g.draw(this.pr[i].lring);
                    }
                    g.setStroke(stdS);
                } else if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    g.draw(this.pr[i].lring);
                    g.setComposite(acO);
                } else {
                    g.draw(this.pr[i].lring);
                }
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            g.setColor(this.color);
            g.fillRect(dx + this.pr[i].lcx, dy + this.pr[i].lcy, 1, 1);
            g.setComposite(acO);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pr[i].lcx, dy + this.pr[i].lcy, 1, 1);
        }
    }

    @Override
    public Shape getJava2DShape() {
        return null;
    }

    @Override
    public Object clone() {
        VRing<T> res = new VRing<T>(this.vx, this.vy, this.vz, this.size, this.angle, this.irr_p, this.orient, this.color, this.borderColor, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

