/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.actions;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.FindInFileActionDelegate;
import org.eclipse.search2.internal.ui.text2.FindInProjectActionDelegate;
import org.eclipse.search2.internal.ui.text2.FindInRecentScopeActionDelegate;
import org.eclipse.search2.internal.ui.text2.FindInWorkingSetActionDelegate;
import org.eclipse.search2.internal.ui.text2.FindInWorkspaceActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionGroup;

public class TextSearchGroup
extends ActionGroup {
    private static final String CTX_MENU_ID = "org.eclipse.search.text.ctxmenu";
    private String fAppendToGroup = "group.find";
    private String fMenuText = SearchMessages.TextSearchGroup_submenu_text;
    private FindInRecentScopeActionDelegate[] fActions;

    public TextSearchGroup(IEditorPart editor) {
        this.createActions(editor);
    }

    public void setMenuText(String text) {
        this.fMenuText = text;
    }

    public void setAppendToGroup(String groupID) {
        this.fAppendToGroup = groupID;
    }

    private void createActions(IEditorPart editor) {
        this.fActions = new FindInRecentScopeActionDelegate[]{new FindInWorkspaceActionDelegate(), new FindInProjectActionDelegate(), new FindInFileActionDelegate(), new FindInWorkingSetActionDelegate()};
        int i = 0;
        while (i < this.fActions.length) {
            FindInRecentScopeActionDelegate action = this.fActions[i];
            action.setActiveEditor((IAction)action, editor);
            ++i;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        MenuManager textSearchMM = new MenuManager(this.fMenuText, CTX_MENU_ID);
        int i = 0;
        i = 0;
        while (i < this.fActions.length - 1) {
            textSearchMM.add((IAction)this.fActions[i]);
            ++i;
        }
        textSearchMM.add((IContributionItem)new GroupMarker("additions"));
        textSearchMM.add((IContributionItem)new Separator());
        textSearchMM.add((IAction)this.fActions[i]);
        menu.appendToGroup(this.fAppendToGroup, (IContributionItem)textSearchMM);
    }
}

