/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.SelectionUtils;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.markers.handler.MarkerHandler;
import org.eclipse.titanium.markers.utils.Analyzer;
import org.eclipse.titanium.markers.utils.AnalyzerCache;
import org.eclipse.titanium.utils.ProjectAnalyzerJob;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CheckCodeSmells
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage iwPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = iwPage.getSelection();
        List res = SelectionUtils.getResourcesFromSelection((ISelection)selection);
        HashMap<IProject, List<IFile>> files = new HashMap<IProject, List<IFile>>();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        this.collectResourcesToBeAnalyzed(new LinkedList<IResource>(res), files, projects);
        String titaniumId = "org.eclipse.titanium";
        String onTheFlyPref = "CODE_SMELL.ON_THE_FLY_SMELLS";
        boolean onTheFlyEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.titanium", "CODE_SMELL.ON_THE_FLY_SMELLS", false, null);
        Analyzer analyzer = AnalyzerCache.withPreference();
        for (IProject project : projects) {
            files.remove(project);
        }
        this.checkProjects(projects, onTheFlyEnabled, analyzer);
        this.checkSeparateFiles(files, onTheFlyEnabled, analyzer);
        return null;
    }

    private void collectResourcesToBeAnalyzed(Deque<IResource> res, Map<IProject, List<IFile>> files, List<IProject> projects) {
        while (!res.isEmpty()) {
            IFile file;
            String extension;
            IResource resource = res.pollFirst();
            if (resource instanceof IProject) {
                IResource[] project = (IResource[])resource;
                projects.add((IProject)project);
                continue;
            }
            if (resource instanceof IFolder) {
                try {
                    for (IResource r2 : ((IFolder)resource).members()) {
                        res.addLast(r2);
                    }
                    continue;
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)"Error while collecting resources", (Throwable)e);
                    continue;
                }
            }
            if (!(resource instanceof IFile) || !"ttcn".equals(extension = (file = (IFile)resource).getFileExtension()) && !"ttcn3".equals(extension)) continue;
            IProject project = file.getProject();
            List<IFile> filesInProject = files.get(project);
            if (filesInProject == null) {
                filesInProject = new ArrayList<IFile>();
                files.put(project, filesInProject);
            }
            filesInProject.add(file);
        }
    }

    private void checkProjects(List<IProject> projects, final boolean onTheFlyEnabled, final Analyzer analyzer) {
        for (final IProject project : projects) {
            new ProjectAnalyzerJob("Check " + project.getName() + " for code smells"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IStatus doPostWork(IProgressMonitor monitor) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (!onTheFlyEnabled) {
                        MarkerHandler handler;
                        IProject iProject = project;
                        synchronized (iProject) {
                            handler = analyzer.analyzeProject((IProgressMonitor)progress.newChild(100), project);
                        }
                        handler.showAll();
                    }
                    return Status.OK_STATUS;
                }
            }.quickSchedule(project);
        }
    }

    private void checkSeparateFiles(final Map<IProject, List<IFile>> files, final boolean onTheFlyEnabled, final Analyzer analyzer) {
        for (final IProject project : files.keySet()) {
            new ProjectAnalyzerJob("Check some files in " + project.getName() + " for code smells"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IStatus doPostWork(IProgressMonitor monitor) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((List)files.get(project)).size());
                    if (!onTheFlyEnabled) {
                        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
                        for (IFile file : (List)files.get(project)) {
                            MarkerHandler handler;
                            Module module = projectSourceParser.containedModule(file);
                            if (module == null) continue;
                            progress.subTask("Analyzing module " + module.getName());
                            IProject iProject = project;
                            synchronized (iProject) {
                                handler = analyzer.analyzeModule((IProgressMonitor)progress.newChild(1), module);
                            }
                            handler.showAll();
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.quickSchedule(project);
        }
    }
}

