/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.executor.tabpages.hostcontrollers.HostControllersTab;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class LaunchShortcut
implements ILaunchShortcut {
    protected abstract String getConfigurationId();

    protected abstract String getDialogTitle();

    public abstract boolean initLaunchConfiguration(ILaunchConfigurationWorkingCopy var1, IProject var2, String var3);

    protected ILaunchConfigurationWorkingCopy getWorkingCopy(IProject project, IFile file, String mode) {
        try {
            ILaunchConfigurationType configurationType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.getConfigurationId());
            ILaunchConfiguration[] configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configurationType);
            ArrayList<ILaunchConfiguration> candidateConfigurations = new ArrayList<ILaunchConfiguration>();
            for (ILaunchConfiguration configuration : configurations) {
                IResource[] resources = configuration.getMappedResources();
                if (null == resources) continue;
                boolean found = false;
                for (IResource resource : resources) {
                    if (!file.equals(resource)) continue;
                    found = true;
                }
                if (!found) continue;
                candidateConfigurations.add(configuration);
            }
            if (1 == candidateConfigurations.size()) {
                ((ILaunchConfiguration)candidateConfigurations.get(0)).launch(mode, null);
                return null;
            }
            if (candidateConfigurations.size() > 1) {
                IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
                dialog.setTitle(this.getDialogTitle());
                dialog.setMessage("Select existing configuration:");
                dialog.setElements((Object[])candidateConfigurations.toArray(new ILaunchConfiguration[candidateConfigurations.size()]));
                if (dialog.open() == 0) {
                    ILaunchConfiguration result = (ILaunchConfiguration)dialog.getFirstResult();
                    result.launch(mode, null);
                    labelProvider.dispose();
                    return null;
                }
                labelProvider.dispose();
            }
            String configurationName = "new configuration (" + file.getFullPath().toString().replace("/", "__") + ")";
            ILaunchConfigurationWorkingCopy wc = configurationType.newInstance(null, configurationName);
            wc.setMappedResources(new IResource[]{project});
            wc.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", true);
            return wc;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return null;
        }
    }

    public final void launch(IEditorPart editor, String mode) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void launch(ISelection selection, String mode) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] selections = ((IStructuredSelection)selection).toArray();
        if (1 != selections.length) {
            return;
        }
        IFile cfgFile = null;
        IProject project = null;
        if (!(selections[0] instanceof IProject)) return;
        project = (IProject)selections[0];
        List cfgFiles = ProjectFileHandler.getCfgFiles((IProject)project);
        if (cfgFiles.size() == 1) {
            cfgFile = (IFile)cfgFiles.get(0);
        } else if (cfgFiles.size() > 1) {
            IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
            dialog.setTitle("Config File Selection");
            dialog.setMessage("Select existing cfg file:");
            dialog.setElements((Object[])cfgFiles.toArray(new IFile[cfgFiles.size()]));
            if (dialog.open() == 0) {
                cfgFile = (IFile)dialog.getFirstResult();
            }
        } else {
            ErrorReporter.logError((String)"Config file not found");
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)("Config file not found in project " + project.getName()));
            return;
        }
        if (project == null || cfgFile == null) {
            return;
        }
        ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy(project, cfgFile, mode);
        if (wc == null) {
            return;
        }
        boolean result = this.initLaunchConfiguration(wc, project, cfgFile.getLocation().toOSString());
        if (result) {
            result = HostControllersTab.initLaunchConfiguration(wc);
        }
        try {
            if (!result) return;
            ILaunchConfiguration conf = wc.doSave();
            conf.launch(mode, null);
            return;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }
}

