/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.executors.ExecuteDialogContentProvider;
import org.eclipse.titan.executor.executors.ExecuteDialogLabelProvider;
import org.eclipse.titan.executor.executors.ITreeBranch;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeBranch;
import org.eclipse.titan.executor.executors.TreeLeaf;

public final class ExecuteDialog
extends Dialog {
    private TreeViewer viewer;
    private TreeBranch treeRoot;
    private List<String> testcases;
    private List<String> testsets;
    private List<String> controlparts;
    private String configurationFile;
    private String selectedElement;
    private Spinner timesSpinner;
    private Label timesPrefixLabel;
    private Label timesPostfixLabel;
    private ExecutableType selectionType = ExecutableType.NONE;
    private InnerLeaf rawSelection;
    private int selectionTimes = 1;
    private boolean selectionTimesVisible = true;

    public ExecuteDialog(Shell shell) {
        super(shell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Execute");
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (null != ExecuteDialog.this.treeRoot) {
                    ExecuteDialog.this.treeRoot.dispose();
                    ExecuteDialog.this.treeRoot = null;
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        container.setLayoutData((Object)data);
        this.viewer = new TreeViewer(container, 2816);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ExecuteDialogContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ExecuteDialogLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Button button = ExecuteDialog.this.getButton(0);
                if (null != button) {
                    if (selection.isEmpty() || selection.getFirstElement() instanceof TreeBranch) {
                        ExecuteDialog.this.selectionType = ExecutableType.NONE;
                        button.setEnabled(false);
                        if (ExecuteDialog.this.selectionTimesVisible) {
                            ExecuteDialog.this.timesPrefixLabel.setEnabled(false);
                            ExecuteDialog.this.timesSpinner.setEnabled(false);
                            ExecuteDialog.this.timesPostfixLabel.setEnabled(false);
                        }
                    } else {
                        ExecuteDialog.this.selectionType = ((InnerLeaf)selection.getFirstElement()).type;
                        ExecuteDialog.this.selectedElement = ((InnerLeaf)selection.getFirstElement()).name();
                        button.setEnabled(true);
                        if (ExecuteDialog.this.selectionTimesVisible) {
                            ExecuteDialog.this.timesPrefixLabel.setEnabled(true);
                            ExecuteDialog.this.timesSpinner.setEnabled(true);
                            ExecuteDialog.this.timesPostfixLabel.setEnabled(true);
                        }
                    }
                }
            }
        });
        final ExecuteDialog thisDialog = this;
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty() || selection.getFirstElement() instanceof TreeBranch) {
                    return;
                }
                thisDialog.okPressed();
            }
        });
        if (this.selectionTimesVisible) {
            Composite timesComp = new Composite(container, 0);
            timesComp.setLayout((Layout)new GridLayout(3, false));
            this.timesPrefixLabel = new Label(timesComp, 0);
            this.timesPrefixLabel.setLayoutData((Object)new GridData(32));
            this.timesPrefixLabel.setText("Run selected:");
            this.timesSpinner = new Spinner(timesComp, 0);
            this.timesSpinner.setLayoutData((Object)new GridData(32));
            this.timesSpinner.setMinimum(1);
            this.timesSpinner.setMaximum(100000);
            this.timesSpinner.setPageIncrement(100);
            this.timesSpinner.setSelection(this.selectionTimes);
            this.timesSpinner.setToolTipText("Controls how many times the selected item should be executed");
            this.timesSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    ExecuteDialog.this.selectionTimes = ExecuteDialog.this.timesSpinner.getSelection();
                }
            });
            this.timesPostfixLabel = new Label(timesComp, 0);
            this.timesPostfixLabel.setLayoutData((Object)new GridData(32));
            this.timesPostfixLabel.setText("times");
        }
        this.createInitialInput();
        this.viewer.setInput((Object)this.treeRoot);
        if (null != this.rawSelection) {
            StructuredSelection selection = new StructuredSelection((Object)this.rawSelection);
            this.viewer.setSelection((ISelection)selection, true);
        }
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    public void setTestcases(List<String> testcases) {
        this.testcases = testcases;
    }

    public void setControlparts(List<String> controlparts) {
        this.controlparts = controlparts;
    }

    public void setTestsets(List<String> testsets) {
        this.testsets = testsets;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public void setSelection(String selectedElement, int selectionTimes, ExecutableType selectionType) {
        this.selectedElement = selectedElement;
        this.selectionTimes = selectionTimes;
        this.selectionType = selectionType;
    }

    private void createInitialInput() {
        TreeBranch helper;
        this.treeRoot = new TreeBranch("treeroot");
        if (null != this.controlparts) {
            helper = new TreeBranch("control parts");
            this.treeRoot.addChildToEnd(helper);
            for (String name : this.controlparts) {
                helper.addChildToEnd(new InnerLeaf(name, ExecutableType.CONTROLPART));
            }
        }
        if (null != this.testsets) {
            helper = new TreeBranch("test sets");
            this.treeRoot.addChildToEnd(helper);
            for (String name : this.testsets) {
                helper.addChildToEnd(new InnerLeaf(name, ExecutableType.TESTSET));
            }
        }
        if (null != this.testcases) {
            helper = new TreeBranch("testcases");
            this.treeRoot.addChildToEnd(helper);
            for (String name : this.testcases) {
                helper.addChildToEnd(new InnerLeaf(name, ExecutableType.TESTCASE));
            }
        }
        if (null != this.configurationFile && this.configurationFile.length() > 0) {
            helper = new TreeBranch("configuration file");
            this.treeRoot.addChildToEnd(helper);
            helper.addChildToEnd(new InnerLeaf(this.configurationFile, ExecutableType.CONFIGURATIONFILE));
        }
        if (null != this.selectedElement) {
            for (ITreeLeaf branch : this.treeRoot.children()) {
                for (ITreeLeaf leaf : ((ITreeBranch)branch).children()) {
                    if (!this.selectedElement.equals(leaf.name())) continue;
                    this.rawSelection = (InnerLeaf)leaf;
                }
            }
        }
    }

    public String getSelectedElement() {
        return this.selectedElement;
    }

    public ExecutableType getSelectionType() {
        return this.selectionType;
    }

    public void disableSelectionTimes() {
        this.selectionTimesVisible = false;
    }

    public int getSelectionTimes() {
        return this.selectionTimes;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    public static enum ExecutableType {
        NONE(0),
        TESTCASE(1),
        TESTSET(2),
        CONTROLPART(3),
        CONFIGURATIONFILE(4);

        private int value;

        private ExecutableType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ExecutableType getExecutableType(int value) {
            switch (value) {
                case 1: {
                    return TESTCASE;
                }
                case 2: {
                    return TESTSET;
                }
                case 3: {
                    return CONTROLPART;
                }
                case 4: {
                    return CONFIGURATIONFILE;
                }
            }
            return NONE;
        }
    }

    private static final class InnerLeaf
    extends TreeLeaf {
        private ExecutableType type;

        public InnerLeaf(String name, ExecutableType type) {
            super(name);
            this.type = type;
        }
    }
}

