/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.svg;

import fr.inria.zvtm.engine.SwingWorker;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.RImage;
import fr.inria.zvtm.glyphs.VImage;
import fr.inria.zvtm.glyphs.VRectangle;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.svg.Config;
import fr.inria.zvtm.svg.Messages;
import fr.inria.zvtm.svg.Viewer;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.ImageIcon;

class Overlay
implements ViewListener {
    Viewer application;
    boolean showingAbout = false;
    VRectangle fadeAbout;
    VImage insituLogo;
    VImage inriaLogo;
    VText[] aboutLines;
    VRectangle fadedRegion;
    VText sayGlyph;

    Overlay(Viewer app) {
        this.application = app;
    }

    void init() {
        this.fadedRegion = new VRectangle(0.0, 0.0, 0, 10.0, 10.0, Config.FADE_REGION_FILL, Config.FADE_REGION_STROKE, 0.85f);
        this.application.aboutSpace.addGlyph((Glyph)this.fadedRegion);
        this.fadedRegion.setVisible(false);
        this.sayGlyph = new VText(0.0, -10.0, 0, Config.SAY_MSG_COLOR, "", 1);
        this.sayGlyph.setFont(Config.SAY_MSG_FONT);
        this.application.aboutSpace.addGlyph((Glyph)this.sayGlyph);
        this.sayGlyph.setVisible(false);
    }

    void showAbout() {
        if (!this.showingAbout) {
            this.fadeAbout = new VRectangle(0.0, 0.0, 0, (double)Math.round((double)this.application.panelWidth / 1.05), (double)Math.round((double)this.application.panelHeight / 1.5), Config.FADE_REGION_FILL, Config.FADE_REGION_STROKE, 0.85f);
            this.aboutLines = new VText[4];
            this.aboutLines[0] = new VText(0.0, 150.0, 0, Color.WHITE, "ZVTM SVG Viewer", 1, 4.0f);
            this.aboutLines[1] = new VText(0.0, 110.0, 0, Color.WHITE, "v" + Messages.VERSION, 1, 2.0f);
            this.aboutLines[2] = new VText(0.0, 40.0, 0, Color.WHITE, "Author: Emmanuel Pietriga", 1, 2.0f);
            RImage.setReflectionHeight((float)0.7f);
            this.inriaLogo = new RImage(-150.0, -40.0, 0, new ImageIcon(this.getClass().getResource("/images/inria.png")).getImage(), 1.0f);
            this.insituLogo = new RImage(200.0, -40.0, 0, new ImageIcon(this.getClass().getResource("/images/insitu.png")).getImage(), 1.0f);
            this.aboutLines[3] = new VText(0.0, -200.0, 0, Color.WHITE, "Based upon: ZVTM (http://zvtm.sf.net)", 1, 2.0f);
            this.aboutLines[3].setFont(Config.MONOSPACE_ABOUT_FONT);
            this.application.aboutSpace.addGlyph((Glyph)this.fadeAbout);
            this.application.aboutSpace.addGlyph((Glyph)this.inriaLogo);
            this.application.aboutSpace.addGlyph((Glyph)this.insituLogo);
            for (int i = 0; i < this.aboutLines.length; ++i) {
                this.application.aboutSpace.addGlyph((Glyph)this.aboutLines[i]);
            }
            this.showingAbout = true;
        }
        this.application.mView.setActiveLayer(1);
        if (this.application.nm.ovPortal.isVisible()) {
            this.application.nm.toggleOverview();
        }
    }

    void hideAbout() {
        if (this.showingAbout) {
            this.showingAbout = false;
            if (this.insituLogo != null) {
                this.application.aboutSpace.removeGlyph((Glyph)this.insituLogo);
                this.insituLogo = null;
            }
            if (this.inriaLogo != null) {
                this.application.aboutSpace.removeGlyph((Glyph)this.inriaLogo);
                this.inriaLogo = null;
            }
            if (this.fadeAbout != null) {
                this.application.aboutSpace.removeGlyph((Glyph)this.fadeAbout);
                this.fadeAbout = null;
            }
            for (int i = 0; i < this.aboutLines.length; ++i) {
                if (this.aboutLines[i] == null) continue;
                this.application.aboutSpace.removeGlyph((Glyph)this.aboutLines[i]);
                this.aboutLines[i] = null;
            }
        }
        this.application.mView.setActiveLayer(0);
        this.application.nm.ovPortal.setVisible(true);
    }

    void say(final String msg) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                Overlay.this.showMessage(msg);
                this.sleep(500);
                Overlay.this.hideMessage();
                return null;
            }
        };
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showMessage(String msg) {
        Overlay overlay = this;
        synchronized (overlay) {
            this.fadedRegion.setWidth((double)(this.application.panelWidth / 2 - 1));
            this.fadedRegion.setHeight(50.0);
            this.sayGlyph.setText(msg);
            this.fadedRegion.setVisible(true);
            this.sayGlyph.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideMessage() {
        Overlay overlay = this;
        synchronized (overlay) {
            this.fadedRegion.setVisible(false);
            this.sayGlyph.setVisible(false);
        }
    }

    public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        this.hideAbout();
    }

    public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
    }

    public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
    }

    public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
    }

    public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
    }

    public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
    }

    public void enterGlyph(Glyph g) {
    }

    public void exitGlyph(Glyph g) {
    }

    public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        this.hideAbout();
    }

    public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void viewActivated(View v) {
    }

    public void viewDeactivated(View v) {
    }

    public void viewIconified(View v) {
    }

    public void viewDeiconified(View v) {
    }

    public void viewClosing(View v) {
        this.application.exit();
    }
}

