/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.metadata.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.archetype.metadata.AbstractArchetypeDescriptor;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.FileSet;
import org.apache.maven.archetype.metadata.ModuleDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ArchetypeDescriptorXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, ArchetypeDescriptor archetypeDescriptor) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(archetypeDescriptor.getModelEncoding(), null);
        this.writeArchetypeDescriptor(archetypeDescriptor, "archetype-descriptor", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, ArchetypeDescriptor archetypeDescriptor) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, archetypeDescriptor.getModelEncoding());
        serializer.startDocument(archetypeDescriptor.getModelEncoding(), null);
        this.writeArchetypeDescriptor(archetypeDescriptor, "archetype-descriptor", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeAbstractArchetypeDescriptor(AbstractArchetypeDescriptor abstractArchetypeDescriptor, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (abstractArchetypeDescriptor.getFileSets() != null && abstractArchetypeDescriptor.getFileSets().size() > 0) {
            serializer.startTag(NAMESPACE, "fileSets");
            for (FileSet fileSet : abstractArchetypeDescriptor.getFileSets()) {
                this.writeFileSet(fileSet, "fileSet", serializer);
            }
            serializer.endTag(NAMESPACE, "fileSets");
        }
        if (abstractArchetypeDescriptor.getModules() != null && abstractArchetypeDescriptor.getModules().size() > 0) {
            serializer.startTag(NAMESPACE, "modules");
            for (ModuleDescriptor moduleDescriptor : abstractArchetypeDescriptor.getModules()) {
                this.writeModuleDescriptor(moduleDescriptor, "module", serializer);
            }
            serializer.endTag(NAMESPACE, "modules");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeArchetypeDescriptor(ArchetypeDescriptor archetypeDescriptor, String tagName, XmlSerializer serializer) throws IOException {
        serializer.setPrefix("", "http://maven.apache.org/plugins/maven-archetype-plugin/archetype-descriptor/1.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/plugins/maven-archetype-plugin/archetype-descriptor/1.0.0 http://maven.apache.org/xsd/archetype-descriptor-1.0.0.xsd");
        if (archetypeDescriptor.getName() != null) {
            serializer.attribute(NAMESPACE, "name", archetypeDescriptor.getName());
        }
        if (archetypeDescriptor.isPartial()) {
            serializer.attribute(NAMESPACE, "partial", String.valueOf(archetypeDescriptor.isPartial()));
        }
        if (archetypeDescriptor.getRequiredProperties() != null && archetypeDescriptor.getRequiredProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "requiredProperties");
            for (RequiredProperty requiredProperty : archetypeDescriptor.getRequiredProperties()) {
                this.writeRequiredProperty(requiredProperty, "requiredProperty", serializer);
            }
            serializer.endTag(NAMESPACE, "requiredProperties");
        }
        if (archetypeDescriptor.getFileSets() != null && archetypeDescriptor.getFileSets().size() > 0) {
            serializer.startTag(NAMESPACE, "fileSets");
            for (FileSet fileSet : archetypeDescriptor.getFileSets()) {
                this.writeFileSet(fileSet, "fileSet", serializer);
            }
            serializer.endTag(NAMESPACE, "fileSets");
        }
        if (archetypeDescriptor.getModules() != null && archetypeDescriptor.getModules().size() > 0) {
            serializer.startTag(NAMESPACE, "modules");
            for (ModuleDescriptor moduleDescriptor : archetypeDescriptor.getModules()) {
                this.writeModuleDescriptor(moduleDescriptor, "module", serializer);
            }
            serializer.endTag(NAMESPACE, "modules");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (fileSet.isFiltered()) {
            serializer.attribute(NAMESPACE, "filtered", String.valueOf(fileSet.isFiltered()));
        }
        if (fileSet.isPackaged()) {
            serializer.attribute(NAMESPACE, "packaged", String.valueOf(fileSet.isPackaged()));
        }
        if (fileSet.getEncoding() != null) {
            serializer.attribute(NAMESPACE, "encoding", fileSet.getEncoding());
        }
        if (fileSet.getDirectory() != null) {
            serializer.startTag(NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(NAMESPACE, "directory");
        }
        if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (String include : fileSet.getIncludes()) {
                serializer.startTag(NAMESPACE, "include").text(include).endTag(NAMESPACE, "include");
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (String exclude : fileSet.getExcludes()) {
                serializer.startTag(NAMESPACE, "exclude").text(exclude).endTag(NAMESPACE, "exclude");
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeModuleDescriptor(ModuleDescriptor moduleDescriptor, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (moduleDescriptor.getId() != null) {
            serializer.attribute(NAMESPACE, "id", moduleDescriptor.getId());
        }
        if (moduleDescriptor.getDir() != null) {
            serializer.attribute(NAMESPACE, "dir", moduleDescriptor.getDir());
        }
        if (moduleDescriptor.getName() != null) {
            serializer.attribute(NAMESPACE, "name", moduleDescriptor.getName());
        }
        if (moduleDescriptor.getFileSets() != null && moduleDescriptor.getFileSets().size() > 0) {
            serializer.startTag(NAMESPACE, "fileSets");
            for (FileSet fileSet : moduleDescriptor.getFileSets()) {
                this.writeFileSet(fileSet, "fileSet", serializer);
            }
            serializer.endTag(NAMESPACE, "fileSets");
        }
        if (moduleDescriptor.getModules() != null && moduleDescriptor.getModules().size() > 0) {
            serializer.startTag(NAMESPACE, "modules");
            for (ModuleDescriptor moduleDescriptor2 : moduleDescriptor.getModules()) {
                this.writeModuleDescriptor(moduleDescriptor2, "module", serializer);
            }
            serializer.endTag(NAMESPACE, "modules");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRequiredProperty(RequiredProperty requiredProperty, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (requiredProperty.getKey() != null) {
            serializer.attribute(NAMESPACE, "key", requiredProperty.getKey());
        }
        if (requiredProperty.getDefaultValue() != null) {
            serializer.startTag(NAMESPACE, "defaultValue").text(requiredProperty.getDefaultValue()).endTag(NAMESPACE, "defaultValue");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

