/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentStateManager;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.PushToGerritWizard;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CommitJob
extends Job {
    private CommitOperation commitOperation;
    private Repository repository;
    private boolean openCommitEditor;
    private PushMode pushMode;

    public CommitJob(Repository repository, CommitOperation commitOperation) {
        super(UIText.CommitAction_CommittingChanges);
        this.repository = repository;
        this.commitOperation = commitOperation;
    }

    public CommitJob setOpenCommitEditor(boolean openCommitEditor) {
        this.openCommitEditor = openCommitEditor;
        return this;
    }

    public CommitJob setPushUpstream(PushMode pushMode) {
        this.pushMode = pushMode;
        return this;
    }

    protected IStatus run(IProgressMonitor monitor) {
        RevCommit commit = null;
        try {
            try {
                this.commitOperation.execute(monitor);
                commit = this.commitOperation.getCommit();
                CommitMessageComponentStateManager.deleteState(this.repository);
            }
            catch (CoreException e) {
                block12: {
                    if (e.getCause() instanceof JGitInternalException) {
                        IStatus iStatus = Activator.createErrorStatus(e.getLocalizedMessage(), e.getCause());
                        GitLightweightDecorator.refresh();
                        return iStatus;
                    }
                    if (!(e.getCause() instanceof AbortedByHookException)) break block12;
                    this.showAbortedByHook(e.getCause());
                    IStatus iStatus = Status.CANCEL_STATUS;
                    GitLightweightDecorator.refresh();
                    return iStatus;
                }
                IStatus iStatus = Activator.createErrorStatus(UIText.CommitAction_CommittingFailed, e);
                GitLightweightDecorator.refresh();
                return iStatus;
            }
        }
        finally {
            GitLightweightDecorator.refresh();
        }
        if (commit != null) {
            if (this.openCommitEditor) {
                this.openCommitEditor(commit);
            }
            if (this.pushMode != null) {
                this.pushUpstream(commit, this.pushMode);
            }
        }
        return Status.OK_STATUS;
    }

    private void showAbortedByHook(final Throwable cause) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)UIText.CommitJob_AbortedByHook, (String)cause.getLocalizedMessage());
            }
        });
    }

    private void openCommitEditor(final RevCommit newCommit) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CommitEditor.openQuiet(new RepositoryCommit(CommitJob.this.repository, newCommit));
            }
        });
    }

    private void pushUpstream(final RevCommit commit, final PushMode pushTo) {
        RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemote(this.repository);
        if (pushTo == PushMode.GERRIT || config == null) {
            final Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Wizard pushWizard = CommitJob.this.getPushWizard(commit, pushTo);
                    if (pushWizard != null) {
                        WizardDialog wizardDialog = new WizardDialog(display.getActiveShell(), (IWizard)pushWizard);
                        wizardDialog.setHelpAvailable(true);
                        wizardDialog.open();
                    }
                }
            });
        } else {
            PushOperationUI op = new PushOperationUI(this.repository, config.getName(), false);
            op.start();
        }
    }

    private Wizard getPushWizard(RevCommit commit, PushMode pushTo) {
        switch (pushTo) {
            case GERRIT: {
                return new PushToGerritWizard(this.repository);
            }
            case UPSTREAM: {
                try {
                    String fullBranch = this.repository.getFullBranch();
                    if (fullBranch != null && fullBranch.startsWith("refs/heads/")) {
                        Ref ref = this.repository.exactRef(fullBranch);
                        return new PushBranchWizard(this.repository, ref);
                    }
                    return new PushBranchWizard(this.repository, commit.getId());
                }
                catch (IOException e) {
                    Activator.handleError(NLS.bind((String)UIText.CommitUI_pushFailedMessage, (Object)e), e, true);
                    return null;
                }
            }
        }
        return null;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.COMMIT.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    public static enum PushMode {
        UPSTREAM,
        GERRIT;

    }
}

