/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CallHierarchyImageDescriptor
extends CompositeImageDescriptor {
    public static final int RECURSIVE = 1;
    public static final int MAX_LEVEL = 2;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public CallHierarchyImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !CallHierarchyImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        CallHierarchyImageDescriptor other = (CallHierarchyImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        this.drawImage(bg, 0, 0);
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            JavaPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
        }
        return data;
    }

    private void drawBottomLeft() {
        Point size = this.getSize();
        int x = 0;
        ImageData data = null;
        if ((this.fFlags & 1) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_RECURSIVE);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
        if ((this.fFlags & 2) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_MAX_LEVEL);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
    }
}

