/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.GroupSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.GroupDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.GroupDataLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.GroupItemDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.GroupItemDataLabelProvider;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class GroupsSubPage {
    private Label totalGroupsLabel;
    private Label totalGroupItemsLabel;
    private Table groupsTable;
    private Table itemsTable;
    private TableViewer groupsTableViewer;
    private TableViewer itemsTableViewer;
    private Button addGroup;
    private Button removeGroup;
    private Button addItem;
    private Button removeItem;
    private ConfigEditor editor;
    private GroupSectionHandler groupSectionHandler;
    private GroupSectionHandler.Group selectedGroup;

    public GroupsSubPage(ConfigEditor editor) {
        this.editor = editor;
    }

    void createGroupsSection(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        section.setText("Groups section");
        section.setDescription("Specify the contents of the groups section for this configuration.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        GridData gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        this.createMainGroupsSection(client, form, toolkit);
        this.createGroupItemsSection(client, form, toolkit);
    }

    void createMainGroupsSection(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.groupsTable = toolkit.createTable(client, 66308);
        this.groupsTable.setEnabled(this.groupSectionHandler != null);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        this.groupsTable.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        this.groupsTable.setLinesVisible(true);
        this.groupsTable.setHeaderVisible(true);
        Composite buttons = toolkit.createComposite(client);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(2));
        this.addGroup = toolkit.createButton(buttons, "Add group", 8);
        gd = new GridData(258);
        this.addGroup.setLayoutData((Object)gd);
        this.addGroup.setEnabled(this.groupSectionHandler != null);
        this.addGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupSectionHandler.Group newGroup;
                if (GroupsSubPage.this.groupSectionHandler == null) {
                    return;
                }
                if (GroupsSubPage.this.groupSectionHandler.getLastSectionRoot() == null) {
                    GroupsSubPage.this.createNewGroupsSection();
                }
                if ((newGroup = GroupsSubPage.this.createNewGroup()) == null) {
                    return;
                }
                ConfigTreeNodeUtilities.addChild((ParseTree)GroupsSubPage.this.groupSectionHandler.getLastSectionRoot(), (ParseTree)newGroup.getRoot());
                GroupsSubPage.this.groupSectionHandler.getGroups().add(newGroup);
                GroupsSubPage.this.internalRefresh();
                GroupsSubPage.this.groupsTable.select(GroupsSubPage.this.groupSectionHandler.getGroups().size() - 1);
                GroupsSubPage.this.groupsTable.showSelection();
                GroupsSubPage.this.selectedGroup = newGroup;
                GroupsSubPage.this.itemsTableViewer.setInput((Object)newGroup);
                GroupsSubPage.this.refreshItemsbTableViewer();
                GroupsSubPage.this.editor.setDirty();
            }
        });
        this.removeGroup = toolkit.createButton(buttons, "Remove group", 8);
        gd = new GridData(258);
        this.removeGroup.setLayoutData((Object)gd);
        this.removeGroup.setEnabled(this.groupSectionHandler != null);
        this.removeGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GroupsSubPage.this.groupsTableViewer == null || GroupsSubPage.this.groupSectionHandler == null) {
                    return;
                }
                GroupsSubPage.this.removeSelectedGroups();
                if (GroupsSubPage.this.groupSectionHandler.getGroups().isEmpty()) {
                    GroupsSubPage.this.removeGroupsSection();
                }
                GroupsSubPage.this.internalRefresh();
                GroupsSubPage.this.editor.setDirty();
            }
        });
        this.totalGroupsLabel = toolkit.createLabel(buttons, "Total: 0");
        gd = new GridData(258);
        this.totalGroupsLabel.setLayoutData((Object)gd);
        section.setText("Groups");
        section.setDescription("Specify groups of components for this configuration.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        TableColumn column = new TableColumn(this.groupsTable, 16384, 0);
        column.setText("Group name");
        column.setWidth(150);
        column.setMoveable(false);
        this.groupsTableViewer = new TableViewer(this.groupsTable);
        this.groupsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GroupSectionHandler.Group group = (GroupSectionHandler.Group)((StructuredSelection)event.getSelection()).getFirstElement();
                GroupsSubPage.this.selectedGroup = group;
                GroupsSubPage.this.itemsTable.setEnabled(GroupsSubPage.this.groupSectionHandler != null && GroupsSubPage.this.selectedGroup != null);
                GroupsSubPage.this.addItem.setEnabled(GroupsSubPage.this.groupSectionHandler != null && GroupsSubPage.this.selectedGroup != null);
                GroupsSubPage.this.removeItem.setEnabled(GroupsSubPage.this.groupSectionHandler != null && GroupsSubPage.this.selectedGroup != null);
                GroupsSubPage.this.itemsTableViewer.setInput((Object)group);
                GroupsSubPage.this.refreshItemsbTableViewer();
            }
        });
        this.groupsTableViewer.setContentProvider((IContentProvider)new GroupDataContentProvider());
        this.groupsTableViewer.setLabelProvider((IBaseLabelProvider)new GroupDataLabelProvider());
        this.groupsTableViewer.setInput((Object)this.groupSectionHandler);
        this.groupsTableViewer.setColumnProperties(new String[]{"groupName"});
        this.groupsTableViewer.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)this.groupsTable)});
        this.groupsTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public String getValue(Object element, String property) {
                GroupDataLabelProvider labelProvider = (GroupDataLabelProvider)GroupsSubPage.this.groupsTableViewer.getLabelProvider();
                return labelProvider.getColumnText(element, 0);
            }

            public void modify(Object element, String property, Object value) {
                if (element != null && element instanceof TableItem && value instanceof String) {
                    GroupSectionHandler.Group group = (GroupSectionHandler.Group)((TableItem)element).getData();
                    ConfigTreeNodeUtilities.setText((ParseTree)group.getGroupName(), (String)((String)value));
                    GroupsSubPage.this.groupsTableViewer.refresh((Object)group);
                    GroupsSubPage.this.editor.setDirty();
                }
            }
        });
        this.refreshGroupsbTableViewer();
    }

    private void createGroupItemsSection(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.itemsTable = toolkit.createTable(client, 0);
        this.itemsTable.setEnabled(this.groupSectionHandler != null && this.selectedGroup != null);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        this.itemsTable.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        this.itemsTable.setLinesVisible(true);
        this.itemsTable.setHeaderVisible(true);
        Composite buttons = toolkit.createComposite(client);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(2));
        this.addItem = toolkit.createButton(buttons, "Add item", 8);
        gd = new GridData(258);
        this.addItem.setLayoutData((Object)gd);
        this.addItem.setEnabled(this.groupSectionHandler != null && this.selectedGroup != null);
        this.addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GroupsSubPage.this.groupSectionHandler == null) {
                    return;
                }
                if (GroupsSubPage.this.selectedGroup == null) {
                    return;
                }
                AddedParseTree hidden = new AddedParseTree(", ");
                ConfigTreeNodeUtilities.addChild((ParseTree)GroupsSubPage.this.selectedGroup.getRoot(), (ParseTree)hidden);
                AddedParseTree node = new AddedParseTree("item");
                ConfigTreeNodeUtilities.addChild((ParseTree)GroupsSubPage.this.selectedGroup.getRoot(), (ParseTree)node);
                GroupSectionHandler.GroupItem newItem = new GroupSectionHandler.GroupItem((ParseTree)node);
                GroupsSubPage.this.selectedGroup.getGroupItems().add(newItem);
                GroupsSubPage.this.internalRefresh();
                GroupsSubPage.this.itemsTable.select(GroupsSubPage.this.selectedGroup.getGroupItems().size() - 1);
                GroupsSubPage.this.itemsTable.showSelection();
                GroupsSubPage.this.editor.setDirty();
            }
        });
        this.removeItem = toolkit.createButton(buttons, "Remove item", 8);
        gd = new GridData(258);
        this.removeItem.setLayoutData((Object)gd);
        this.removeItem.setEnabled(this.groupSectionHandler != null && this.selectedGroup != null);
        this.removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GroupsSubPage.this.itemsTableViewer == null || GroupsSubPage.this.groupSectionHandler == null) {
                    return;
                }
                GroupsSubPage.this.removeSelectedItems();
                GroupsSubPage.this.internalRefresh();
                GroupsSubPage.this.editor.setDirty();
            }
        });
        this.totalGroupItemsLabel = toolkit.createLabel(buttons, "");
        if (this.selectedGroup == null) {
            this.totalGroupItemsLabel.setText("Total: ");
        } else {
            this.totalGroupItemsLabel.setText("Total: " + this.selectedGroup.getGroupItems().size());
        }
        gd = new GridData(258);
        this.totalGroupItemsLabel.setLayoutData((Object)gd);
        section.setText("Group items");
        section.setDescription("Specify items of the selected group.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        TableColumn column = new TableColumn(this.itemsTable, 16384, 0);
        column.setText("Group item");
        column.setWidth(150);
        column.setMoveable(false);
        this.itemsTableViewer = new TableViewer(this.itemsTable);
        this.itemsTableViewer.setContentProvider((IContentProvider)new GroupItemDataContentProvider());
        this.itemsTableViewer.setLabelProvider((IBaseLabelProvider)new GroupItemDataLabelProvider());
        this.itemsTableViewer.setInput(null);
        this.itemsTableViewer.setColumnProperties(new String[]{"groupItem"});
        this.itemsTableViewer.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)this.itemsTable)});
        this.itemsTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                GroupItemDataLabelProvider labelProvider = (GroupItemDataLabelProvider)GroupsSubPage.this.itemsTableViewer.getLabelProvider();
                return labelProvider.getColumnText(element, 0);
            }

            public void modify(Object element, String property, Object value) {
                if (element != null && element instanceof TableItem && value instanceof String) {
                    GroupSectionHandler.GroupItem item = (GroupSectionHandler.GroupItem)((TableItem)element).getData();
                    ConfigTreeNodeUtilities.setText((ParseTree)item.getItem(), (String)((String)value));
                    GroupsSubPage.this.itemsTableViewer.refresh((Object)item);
                    GroupsSubPage.this.editor.setDirty();
                }
            }
        });
    }

    public void refreshGroupsbTableViewer() {
        this.groupsTableViewer.refresh();
        if (this.groupSectionHandler != null) {
            this.totalGroupsLabel.setText("Total: " + this.groupSectionHandler.getGroups().size());
        }
    }

    public void refreshItemsbTableViewer() {
        this.itemsTableViewer.refresh();
        if (this.selectedGroup == null) {
            this.totalGroupItemsLabel.setText("Total: ");
        } else {
            this.totalGroupItemsLabel.setText("Total: " + this.selectedGroup.getGroupItems().size());
        }
    }

    private void internalRefresh() {
        this.addGroup.setEnabled(this.groupSectionHandler != null);
        this.removeGroup.setEnabled(this.groupSectionHandler != null);
        this.addItem.setEnabled(this.groupSectionHandler != null && this.selectedGroup != null);
        this.removeItem.setEnabled(this.groupSectionHandler != null && this.selectedGroup != null);
        this.groupsTable.setEnabled(this.groupSectionHandler != null);
        this.groupsTableViewer.setInput((Object)this.groupSectionHandler);
        this.itemsTable.setEnabled(this.groupSectionHandler != null && this.selectedGroup != null);
        if (this.selectedGroup != null) {
            this.itemsTableViewer.setInput((Object)this.selectedGroup);
        }
        if (this.groupSectionHandler == null) {
            this.totalGroupsLabel.setText("Total: 0");
        } else {
            this.totalGroupsLabel.setText("Total: " + this.groupSectionHandler.getGroups().size());
        }
    }

    public void refreshData(GroupSectionHandler groupSectionHandler) {
        this.groupSectionHandler = groupSectionHandler;
        if (this.groupsTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GroupsSubPage.this.internalRefresh();
                }
            });
        }
    }

    private void createNewGroupsSection() {
        if (this.groupSectionHandler == null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.groupSectionHandler.setLastSectionRoot(sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[GROUPS]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    private GroupSectionHandler.Group createNewGroup() {
        if (this.groupSectionHandler == null) {
            return null;
        }
        GroupSectionHandler.Group newGroup = new GroupSectionHandler.Group();
        ParserRuleContext root = new ParserRuleContext();
        newGroup.setRoot((ParseTree)root);
        AddedParseTree groupName = new AddedParseTree("group_name");
        AddedParseTree item = new AddedParseTree("item");
        newGroup.setGroupName((ParseTree)groupName);
        newGroup.setGroupItems(new ArrayList());
        newGroup.getGroupItems().add(new GroupSectionHandler.GroupItem((ParseTree)item));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)"\n"));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)groupName);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(" := "));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)item);
        return newGroup;
    }

    private void removeGroupsSection() {
        if (this.groupSectionHandler == null || this.groupSectionHandler.getLastSectionRoot() == null) {
            return;
        }
        ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.groupSectionHandler.getLastSectionRoot());
        this.groupSectionHandler.setLastSectionRoot(null);
    }

    private void removeSelectedGroups() {
        if (this.groupsTableViewer == null || this.groupSectionHandler == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.groupsTableViewer.getSelection();
        for (GroupSectionHandler.Group group : selection) {
            if (group == null) continue;
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.groupSectionHandler.getLastSectionRoot(), (ParseTree)group.getRoot());
            this.groupSectionHandler.getGroups().remove(group);
        }
    }

    private void removeSelectedItems() {
        if (this.itemsTableViewer == null || this.groupSectionHandler == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.itemsTableViewer.getSelection();
        for (GroupSectionHandler.GroupItem item : selection) {
            if (item == null) continue;
            List groupItems = this.selectedGroup.getGroupItems();
            int size = groupItems.size();
            if (size == 1) {
                return;
            }
            ParseTree selected = item.getItem();
            ParseTree parent = this.selectedGroup.getRoot();
            ConfigTreeNodeUtilities.removeChildWithSeparator((ParseTree)parent, (ParseTree)selected, (String)",", (int)2);
            this.selectedGroup.getGroupItems().remove(item);
        }
    }
}

