/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.editors.actions.DeclarationCollectionHelper;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.actions.OpenDeclarationHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public abstract class BaseTextHover
implements ITextHover,
ITextHoverExtension2 {
    protected abstract ISourceViewer getSourceViewer();

    protected abstract IEditorPart getTargetEditor();

    protected abstract IReferenceParser getReferenceParser();

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String string;
        if (hoverRegion == null || textViewer == null) {
            return null;
        }
        IAnnotationModel annotationModel = this.getSourceViewer().getAnnotationModel();
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            ArrayList<String> messages = new ArrayList<String>();
            while (iterator.hasNext()) {
                MarkerAnnotation actualMarker;
                Position markerPosition;
                Object o = iterator.next();
                if (!(o instanceof MarkerAnnotation) || (markerPosition = annotationModel.getPosition((Annotation)(actualMarker = (MarkerAnnotation)o))) == null || markerPosition.getOffset() > hoverRegion.getOffset() || markerPosition.getOffset() + markerPosition.getLength() < hoverRegion.getOffset()) continue;
                String message = actualMarker.getText();
                if (message != null) {
                    message = message.replaceAll("\\<([A-Z]+)\\>", "$1");
                } else {
                    ErrorReporter.INTERNAL_ERROR((String)"BaseTextHover.getHoverInfo(): message == null");
                }
                messages.add(message);
            }
            if (!messages.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append((String)messages.get(0));
                for (int i = 1; i < messages.size() && i <= 3; ++i) {
                    builder.append("<br></br>");
                    builder.append((String)messages.get(i));
                }
                if (messages.size() > 3) {
                    builder.append("<br></br>...");
                }
                return builder.toString();
            }
        }
        ErrorReporter.parallelDisplayInStatusLine((IEditorPart)this.getTargetEditor(), null);
        DeclarationCollector declarationCollector = OpenDeclarationHelper.findVisibleDeclarations(this.getTargetEditor(), this.getReferenceParser(), textViewer.getDocument(), hoverRegion.getOffset(), false);
        if (declarationCollector == null) {
            return null;
        }
        List<DeclarationCollectionHelper> collected = declarationCollector.getCollected();
        if (T3Doc.isT3DocEnable() && (string = T3Doc.getCommentStringBasedOnReference(declarationCollector, collected, this.getTargetEditor(), hoverRegion, this.getReferenceParser(), textViewer)) != null) {
            return string;
        }
        if (collected.isEmpty()) {
            return null;
        }
        DeclarationCollectionHelper declaration = collected.get(0);
        if (!T3Doc.isT3DocEnable()) {
            return declaration.description;
        }
        if (declaration.node != null) {
            if (declaration.node.getT3Doc(declaration.location) == null) {
                return "";
            }
            if (declaration.description != null) {
                return declaration.description + "<BR></BR>" + declaration.node.getT3Doc(declaration.location).toString();
            }
            return declaration.node.getT3Doc(declaration.location).toString();
        }
        if (declaration.scope != null) {
            if (declaration.description != null) {
                return declaration.description + declaration.scope.getT3Doc(declaration.location).toString();
            }
            return declaration.scope.getT3Doc(declaration.location).toString();
        }
        return "";
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        String selection = this.getHoverInfo(textViewer, hoverRegion);
        return selection;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }
}

