/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.core.TITANBuilderResourceVisitor;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.properties.data.DOMErrorHandlerImpl;
import org.eclipse.titan.designer.properties.data.MakefileCreationData;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public final class GenerateBuilderInformation
extends AbstractHandler
implements IObjectActionDelegate {
    private static final String DOM_IMPLEMENTATION_SOURCE = "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl";
    private static final String LOAD_SAVE_VERSION = "LS 3.0";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!LicenseValidator.check()) {
            return;
        }
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        for (Object selected : structSelection.toList()) {
            if (!(selected instanceof IProject) || !TITANBuilder.isBuilderEnabled((IProject)selected)) continue;
            IProject tempProject = (IProject)selected;
            try {
                this.generateInfoForProject(tempProject);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateInfoForProject(IProject project) throws CoreException {
        DOMImplementationRegistry dOMImplementationRegistry;
        IProject[] referencedProjects;
        Element node;
        String temp;
        DocumentBuilder builder;
        boolean win32 = "win32".equals(Platform.getOS());
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return;
        }
        DOMImplementation impl = builder.getDOMImplementation();
        Document document = impl.createDocument(null, "TITAN_External_Builder_Information", null);
        Element root = document.getDocumentElement();
        root.setAttribute("version", "1.0");
        Element makefileSettings = document.createElement("Makefile_settings");
        root.appendChild(makefileSettings);
        for (int i = 0; i < MakefileCreationData.MAKEFILE_PROPERTIES.length; ++i) {
            try {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", MakefileCreationData.MAKEFILE_PROPERTIES[i]));
                node = document.createElement(MakefileCreationData.MAKEFILE_TAGS[i]);
                node.appendChild(document.createTextNode(temp));
                makefileSettings.appendChild(node);
                continue;
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            }
        }
        node = document.createElement("projectName");
        node.appendChild(document.createTextNode(project.getName()));
        makefileSettings.appendChild(node);
        node = document.createElement("projectRoot");
        node.appendChild(document.createTextNode(project.getLocationURI().toString()));
        makefileSettings.appendChild(node);
        temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
        node = document.createElement("workingDirectory");
        node.appendChild(document.createTextNode(TITANPathUtilities.resolvePathURI((String)temp, (String)project.getLocation().toOSString()).toString()));
        makefileSettings.appendChild(node);
        temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
        node = document.createElement("targetExecutable");
        node.appendChild(document.createTextNode(TITANPathUtilities.resolvePathURI((String)temp, (String)project.getLocation().toOSString()).toString()));
        makefileSettings.appendChild(node);
        temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileUpdateScript"));
        node = document.createElement("MakefileScript");
        node.appendChild(document.createTextNode(TITANPathUtilities.resolvePathURI((String)temp, (String)project.getLocation().toOSString()).toString()));
        makefileSettings.appendChild(node);
        temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileFlags"));
        node = document.createElement("MakefileFlags");
        node.appendChild(document.createTextNode(temp));
        makefileSettings.appendChild(node);
        Element projectsElement = document.createElement("ReferencedProjects");
        root.appendChild(projectsElement);
        for (IProject tempProject : referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getReferencedProjects()) {
            Element element = document.createElement("ReferencedProject");
            element.setAttribute("name", tempProject.getName());
            element.setAttribute("location", tempProject.getLocationURI().toString());
            if (win32 && tempProject.getLocation() != null) {
                String string = PathConverter.convert((String)tempProject.getLocation().toOSString(), (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole());
                Path path = new Path(string);
                element.setAttribute("cygwinPath", URIUtil.toURI((IPath)path).toString());
            }
            projectsElement.appendChild(element);
        }
        Element filesElement = document.createElement("Files");
        root.appendChild(filesElement);
        TITANBuilderResourceVisitor visitor = ProjectBasedBuilder.getProjectBasedBuilder(project).getResourceVisitor();
        Map<String, IFile> files = visitor.getFiles();
        for (IFile iFile : files.values()) {
            Element element = document.createElement("File");
            element.setAttribute("path", iFile.getLocationURI().toString());
            if (win32 && iFile.getLocation() != null) {
                String fileLocation = iFile.getLocation().toOSString();
                String converted = PathConverter.convert((String)iFile.getLocation().toOSString(), (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole());
                if (converted != fileLocation) {
                    Path path = new Path(converted);
                    element.setAttribute("cygwinPath", URIUtil.toURI((IPath)path).toString());
                }
            }
            element.setAttribute("relativePath", org.eclipse.core.runtime.URIUtil.makeRelative((URI)iFile.getLocationURI(), (URI)project.getLocationURI()).toString());
            filesElement.appendChild(element);
        }
        Map<String, IFile> contralStorageFiles = visitor.getCentralStorageFiles();
        for (IFile iFile : contralStorageFiles.values()) {
            String converted;
            Element element = document.createElement("File");
            String fileLocation = iFile.getLocationURI().toString();
            element.setAttribute("path", fileLocation);
            if (win32 && iFile.getLocation() != null && (converted = PathConverter.convert((String)iFile.getLocation().toOSString(), (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole())) != fileLocation) {
                Path path = new Path(converted);
                element.setAttribute("cygwinPath", URIUtil.toURI((IPath)path).toString());
            }
            element.setAttribute("relativePath", org.eclipse.core.runtime.URIUtil.makeRelative((URI)iFile.getLocationURI(), (URI)project.getLocationURI()).toString());
            element.setAttribute("centralStorage", "true");
            filesElement.appendChild(element);
        }
        Map<String, IFile> map = ProjectBasedBuilder.getProjectBasedBuilder(project).getFilesofReferencedProjects();
        for (IFile file : map.values()) {
            Element element = document.createElement("File");
            element.setAttribute("path", file.getLocationURI().toString());
            if (win32 && file.getLocation() != null) {
                String fileLocation = file.getLocation().toOSString();
                String converted = PathConverter.convert((String)file.getLocation().toOSString(), (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole());
                if (converted != fileLocation) {
                    Path path = new Path(converted);
                    element.setAttribute("cygwinPath", URIUtil.toURI((IPath)path).toString());
                }
            }
            element.setAttribute("relativePath", org.eclipse.core.runtime.URIUtil.makeRelative((URI)file.getLocationURI(), (URI)project.getLocationURI()).toString());
            element.setAttribute("fromProject", file.getProject().getName());
            filesElement.appendChild(element);
        }
        ProjectFileHandler.indentNode(document, document.getDocumentElement(), 1);
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", DOM_IMPLEMENTATION_SOURCE);
        Object var19_34 = null;
        try {
            dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassNotFoundException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)ce);
            return;
        }
        catch (InstantiationException ie) {
            ErrorReporter.logExceptionStackTrace((Exception)ie);
            return;
        }
        catch (IllegalAccessException iae) {
            ErrorReporter.logExceptionStackTrace((Exception)iae);
            return;
        }
        DOMImplementation domImpl = dOMImplementationRegistry.getDOMImplementation(LOAD_SAVE_VERSION);
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)domImpl);
        LSParser parser = domImplLS.createLSParser((short)1, XML_SCHEMA);
        DOMConfiguration config = parser.getDomConfig();
        DOMErrorHandlerImpl errorHandler = new DOMErrorHandlerImpl();
        config.setParameter("error-handler", errorHandler);
        config.setParameter("validate", Boolean.TRUE);
        config.setParameter("schema-type", XML_SCHEMA);
        config.setParameter("validate-if-schema", Boolean.TRUE);
        LSSerializer dom3Writer = domImplLS.createLSSerializer();
        LSOutput output = domImplLS.createLSOutput();
        IFile propertiesFile = project.getFile("/external_build_information.xml");
        File file = propertiesFile.getLocation().toFile();
        StringWriter sw = null;
        try {
            propertiesFile.refreshLocal(0, null);
            sw = new StringWriter();
            output.setCharacterStream(sw);
            output.setEncoding("UTF-8");
            dom3Writer.write(document, output);
            String temporaloutput = sw.getBuffer().toString();
            String temporalStorage = null;
            if (propertiesFile.isAccessible() && file.exists() && file.canRead()) {
                InputStream is = propertiesFile.getContents(true);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringBuilder sb = new StringBuilder();
                boolean firstLine = true;
                String line = br.readLine();
                while (line != null) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        sb.append('\n');
                    }
                    sb.append(line);
                    line = br.readLine();
                }
                temporalStorage = sb.toString();
                br.close();
            }
            if (temporalStorage == null || !temporalStorage.equals(temporaloutput)) {
                if (file.exists()) {
                    propertiesFile.setContents((InputStream)new ByteArrayInputStream(temporaloutput.getBytes()), 3, null);
                } else {
                    propertiesFile.create((InputStream)new ByteArrayInputStream(temporaloutput.getBytes()), 1, null);
                }
                try {
                    propertiesFile.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!LicenseValidator.check()) {
            return null;
        }
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!(this.selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        for (Object selected : structSelection.toList()) {
            if (!(selected instanceof IProject) || !TITANBuilder.isBuilderEnabled((IProject)selected)) continue;
            IProject tempProject = (IProject)selected;
            try {
                this.generateInfoForProject(tempProject);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        return null;
    }
}

