/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionUtilities;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EqualsExpression
extends Expression_Value {
    private final Value value1;
    private final Value value2;

    public EqualsExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.EQUALS_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.value1.createStringRepresentation());
        builder.append(" == ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return true;
        }
        return this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return;
        }
        if (this.value1.getIsErroneous(timestamp) || this.value2.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return;
        }
        ExpressionUtilities.checkExpressionOperatorCompatibility(timestamp, (Expression_Value)this, referenceChain, expectedValue, this.value1, this.value2);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
        this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value1 == null || this.value2 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
        IValue last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        if (last1 == null || last2 == null) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        this.lastValue = new Boolean_Value(last1.checkEquality(timestamp, last2));
        this.lastValue.copyGeneralProperties(this);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }
}

