/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureExceptions;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Signature_Type
extends Type {
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for signature `{1}''";
    private static final String SIGNATUREEXPECTED = "sequence value was expected for type `{0}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed in a template for signature `{0}''";
    private static final String DUPLICATEPARAMETERAGAIN = "Duplicate parameter `{0}'' in template for signature `{1}''";
    private static final String DUPLICATEPARAMETERFIRST = "Parameter `{0}'' is already given here";
    private static final String UNEXPECTEDPARAMETER = "Unexpected parameter `{0}'' in signature template";
    private static final String NONEXISTENTPARAMETER = "Reference to non-existent parameter `{0}'' in template for signature `{1}''";
    private static final String INCOMPLETE1 = "Signature template is incomplete, because the inout parameter `{0}'' is missing";
    private static final String INCOMPLETE2 = "Signature template is incomplete, because the in parameter `{0}'' and the out parameter `{1}'' is missing";
    private static final String FULLNAMEPART1 = ".<return_type>";
    private static final String FULLNAMEPART2 = ".<exception_list>";
    private final SignatureFormalParameterList formalParList;
    private final Type returnType;
    private final boolean noBlock;
    private final SignatureExceptions exceptions;
    private boolean componentInternal;

    public Signature_Type(SignatureFormalParameterList formalParList, Type returnType, boolean noBlock, SignatureExceptions exceptions) {
        this.formalParList = formalParList;
        this.returnType = returnType;
        this.noBlock = noBlock;
        this.exceptions = exceptions;
        this.componentInternal = false;
        if (formalParList != null) {
            formalParList.setFullNameParent(this);
        }
        if (returnType != null) {
            returnType.setFullNameParent(this);
        }
        if (exceptions != null) {
            exceptions.setFullNameParent(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_SIGNATURE;
    }

    public boolean isNonblocking() {
        return this.noBlock;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.returnType == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.exceptions == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.formalParList != null) {
            this.formalParList.setMyScope(scope);
        }
        if (this.returnType != null) {
            this.returnType.setMyScope(scope);
        }
        if (this.exceptions != null) {
            this.exceptions.setMyScope(scope);
        }
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType last = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || last.getIsErroneous(timestamp)) {
            return true;
        }
        return this == last;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "signature.gif";
    }

    public int getNofParameters() {
        if (this.formalParList == null) {
            return 0;
        }
        return this.formalParList.getNofParameters();
    }

    public boolean hasParameterWithName(String name) {
        return this.formalParList.hasParameterWithName(name);
    }

    public SignatureFormalParameter getParameterByName(String name) {
        return this.formalParList.getParameterByName(name);
    }

    public Identifier getParameterIdentifierByIndex(int index) {
        return this.formalParList.getParameterByIndex(index).getIdentifier();
    }

    public SignatureFormalParameterList getParameterList() {
        return this.formalParList;
    }

    public SignatureExceptions getSignatureExceptions() {
        return this.exceptions;
    }

    public Type getSignatureReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.componentInternal;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Type type;
        int i;
        int size;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.componentInternal = false;
        this.parseAttributes(timestamp);
        if (this.formalParList != null) {
            this.formalParList.check(timestamp, this);
            size = this.formalParList.getNofParameters();
            for (i = 0; i < size && !this.componentInternal; ++i) {
                type = this.formalParList.getParameterByIndex(i).getType();
                if (type == null || !type.isComponentInternal(timestamp)) continue;
                this.componentInternal = true;
            }
        }
        if (this.returnType != null) {
            this.returnType.setParentType(this);
            this.returnType.check(timestamp);
            this.returnType.checkEmbedded(timestamp, this.returnType.getLocation(), true, "the return type of a signature");
            if (!this.componentInternal && this.returnType.isComponentInternal(timestamp)) {
                this.componentInternal = true;
            }
        }
        if (this.exceptions != null) {
            this.exceptions.check(timestamp, this);
            size = this.exceptions.getNofExceptions();
            for (i = 0; i < size && !this.componentInternal; ++i) {
                type = this.exceptions.getExceptionByIndex(i);
                if (type == null || !type.isComponentInternal(timestamp)) continue;
                this.componentInternal = true;
            }
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        Type type;
        int i;
        int size;
        if (typeSet.contains(this)) {
            return;
        }
        typeSet.add(this);
        if (this.formalParList != null) {
            size = this.formalParList.getNofParameters();
            for (i = 0; i < size; ++i) {
                type = this.formalParList.getParameterByIndex(i).getType();
                if (type == null || !type.isComponentInternal(timestamp)) continue;
                type.checkComponentInternal(timestamp, typeSet, operation);
            }
        }
        if (this.returnType != null && this.returnType.isComponentInternal(timestamp)) {
            this.returnType.checkComponentInternal(timestamp, typeSet, operation);
        }
        if (this.exceptions != null) {
            size = this.exceptions.getNofExceptions();
            for (i = 0; i < size; ++i) {
                type = this.exceptions.getExceptionByIndex(i);
                if (type == null || !type.isComponentInternal(timestamp)) continue;
                type.checkComponentInternal(timestamp, typeSet, operation);
            }
        }
        typeSet.remove(this);
    }

    @Override
    public void checkEmbedded(CompilationTimeStamp timestamp, Location errorLocation, boolean defaultAllowed, String errorMessage) {
        errorLocation.reportSemanticError(MessageFormat.format("Signature type `{0}'' cannot be {1}", this.getTypename(), errorMessage));
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                this.checkThisValueSequence(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SEQUENCEOF_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE);
                this.checkThisValueSequence(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREEXPECTED, this.getTypename()));
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueSequence(CompilationTimeStamp timestamp, Sequence_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        int i;
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        boolean inSnyc = true;
        int nofTypeComponents = this.getNofParameters();
        int nofvalueComponents = value.getNofComponents();
        int nextIndex = 0;
        SignatureFormalParameter lastParameter = null;
        for (i = 0; i < nofvalueComponents; ++i) {
            NamedValue namedValue = value.getSeqValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!this.formalParList.hasParameterWithName(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTPARAMETER, valueId.getDisplayName(), this.getTypename()));
                inSnyc = false;
                continue;
            }
            if (componentMap.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEPARAMETERAGAIN, valueId.getDisplayName(), this.getTypename()));
                ((NamedValue)componentMap.get(valueId.getName())).getLocation().reportSemanticError(MessageFormat.format(DUPLICATEPARAMETERFIRST, valueId.getDisplayName()));
                inSnyc = false;
            } else {
                componentMap.put(valueId.getName(), namedValue);
            }
            SignatureFormalParameter formalParameter = this.formalParList.getParameterByName(valueId.getName());
            if (inSnyc) {
                if (incompleteAllowed) {
                    boolean found = false;
                    for (int j = nextIndex; j < nofTypeComponents && !found; ++j) {
                        SignatureFormalParameter formalParameter2 = this.formalParList.getParameterByIndex(j);
                        if (!valueId.getName().equals(formalParameter2.getIdentifier().getName())) continue;
                        lastParameter = formalParameter2;
                        nextIndex = j + 1;
                        found = true;
                    }
                    if (lastParameter != null && !found) {
                        namedValue.getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' cannot appear after parameter `{1}'' in signature value", valueId.getDisplayName(), lastParameter.getIdentifier().getDisplayName()));
                        inSnyc = false;
                    }
                } else {
                    SignatureFormalParameter formalParameter2 = this.formalParList.getParameterByIndex(i);
                    if (formalParameter != formalParameter2) {
                        namedValue.getLocation().reportSemanticError(MessageFormat.format("Unexpected field `{0}'' in signature value, expecting `{1}''", valueId.getDisplayName(), formalParameter2.getIdentifier().getDisplayName()));
                        inSnyc = false;
                    }
                }
            }
            Type type = formalParameter.getType();
            IValue componentValue = namedValue.getValue();
            if (componentValue == null) continue;
            componentValue.setMyGovernor(type);
            IValue tempValue = type.checkThisValueRef(timestamp, componentValue);
            type.checkThisValue(timestamp, tempValue, new IType.ValueCheckingOptions(expectedValue, false, false, true, implicitOmit, strElem));
        }
        if (!incompleteAllowed) {
            for (i = 0; i < this.formalParList.getNofInParameters(); ++i) {
                SignatureFormalParameter formalParameter = this.formalParList.getInParameterByIndex(i);
                Identifier identifier = formalParameter.getIdentifier();
                if (componentMap.containsKey(identifier.getName()) || 1 == formalParameter.getDirection()) continue;
                value.getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is missing from signature value", identifier.getDisplayName()));
            }
        }
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                ITTCN3Template transformed = template.setTemplatetype(timestamp, ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST);
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)transformed, isModified);
                break;
            }
            case NAMED_TEMPLATE_LIST: {
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)template, isModified);
                break;
            }
            case SPECIFIC_VALUE: {
                ((SpecificValue_Template)template).checkSpecificValue(timestamp, false);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
    }

    private void checkThisNamedTemplateList(CompilationTimeStamp timestamp, Named_Template_List template, boolean isModified) {
        HashMap<String, NamedTemplate> componentMap = new HashMap<String, NamedTemplate>();
        boolean inSynch = true;
        int nofTypeParameters = this.getNofParameters();
        int nofTemplateComponents = template.getNofTemplates();
        int tI = 0;
        if (nofTemplateComponents < nofTypeParameters) {
            template.getLocation().reportSemanticError(MessageFormat.format("Too few elements in value list notation for type `{0}'': {1} was expected instead of {2}", this.getFullName(), nofTypeParameters, nofTemplateComponents));
        }
        for (int vI = 0; vI < nofTemplateComponents; ++vI) {
            NamedTemplate namedTemplate = template.getTemplateByIndex(vI);
            Identifier identifier = namedTemplate.getName();
            String name = identifier.getName();
            if (this.hasParameterWithName(name)) {
                if (componentMap.containsKey(name)) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEPARAMETERAGAIN, identifier.getDisplayName(), this.getTypename()));
                    ((NamedTemplate)componentMap.get(name)).getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEPARAMETERFIRST, identifier.getDisplayName()));
                    inSynch = false;
                } else {
                    componentMap.put(name, namedTemplate);
                }
                SignatureFormalParameter parameter = this.formalParList.getParameterByName(name);
                if (inSynch) {
                    SignatureFormalParameter parameter2 = null;
                    boolean found = false;
                    while (tI < nofTypeParameters && !found) {
                        parameter2 = this.formalParList.getParameterByIndex(tI);
                        if (parameter == parameter2) {
                            found = true;
                            break;
                        }
                        ++tI;
                    }
                    if (!found) {
                        namedTemplate.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDPARAMETER, identifier.getDisplayName()));
                        inSynch = false;
                    }
                }
                Type parameterType = parameter.getType();
                ITTCN3Template componentTemplate = namedTemplate.getTemplate();
                componentTemplate.setMyGovernor(parameterType);
                componentTemplate = parameterType.checkThisTemplateRef(timestamp, componentTemplate);
                componentTemplate.checkThisTemplateGeneric(timestamp, parameterType, isModified, false, false, true, false);
                continue;
            }
            namedTemplate.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTPARAMETER, identifier.getDisplayName(), this.getTypename()));
            inSynch = false;
        }
        if (isModified) {
            SignatureFormalParameter firstUndefIn = null;
            SignatureFormalParameter firstUndefOut = null;
            block6: for (int i = 0; i < nofTypeParameters; ++i) {
                SignatureFormalParameter parameter = this.formalParList.getParameterByIndex(i);
                Identifier identifier = parameter.getIdentifier();
                if (componentMap.containsKey(identifier.getName()) && !ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)((NamedTemplate)componentMap.get(identifier.getName())).getTemplate().getTemplatetype())) continue;
                switch (parameter.getDirection()) {
                    case 0: {
                        if (firstUndefIn != null) continue block6;
                        firstUndefIn = parameter;
                        continue block6;
                    }
                    case 1: {
                        if (firstUndefOut != null) continue block6;
                        firstUndefOut = parameter;
                        continue block6;
                    }
                    default: {
                        template.getLocation().reportSemanticError(MessageFormat.format(INCOMPLETE1, identifier.getDisplayName()));
                    }
                }
            }
            if (firstUndefIn != null && firstUndefOut != null) {
                template.getLocation().reportSemanticError(MessageFormat.format(INCOMPLETE2, firstUndefIn.getIdentifier().getDisplayName(), firstUndefOut.getIdentifier().getDisplayName()));
            }
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("signature");
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.returnType != null) {
            this.returnType.updateSyntax(reparser, false);
            reparser.updateLocation(this.returnType.getLocation());
        }
        if (this.exceptions != null) {
            this.exceptions.updateSyntax(reparser, false);
            reparser.updateLocation(this.exceptions.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.returnType != null) {
            this.returnType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.exceptions != null) {
            this.exceptions.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        if (this.returnType != null && !this.returnType.accept(v)) {
            return false;
        }
        return this.exceptions == null || this.exceptions.accept(v);
    }
}

