/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Indexed_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Array_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Array_Type
extends Type
implements IReferenceableElement {
    private static final String ARRAYVALUEEXPECTED = "Array value was expected";
    private static final String TOOMANYEXPECTED = "Too many elements in the array value: {0} was expected instead of {1}";
    private static final String TOOFEWEXPECTED = "Too few elements in the array value: {0} was expected instead of {1}";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `{1}''";
    private static final String REDUNDANTLENGTHRESTRICTION = "Redundant usage of length restriction with `omit''";
    private static final String TOOMANYTEMPLATEELEMENTS = "Too many elements in the array template: {0} was expected instead of {1}";
    private static final String TOOFEWTEMPLATEELEMENTS = "Too few elements in the array template: {0} was expected instead of {1}";
    private static final String NOTUSEDNOTALLOWED = "Not used symbol `-'' is not allowed in this context";
    private static final String FULLNAMEPART1 = ".<elementType>";
    private static final String FULLNAMEPART2 = ".<dimension>";
    private static final String BADARRAYDIMENSION = "Array types should have the same dimension";
    private static final String NOFFIELDSDONTMATCH = "The number of fields in record/SEQUENCE types ({0}) and the size of the array ({1}) must be the same";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";
    private final Type elementType;
    private final ArrayDimension dimension;
    private final boolean inTypeDefinition;
    private boolean componentInternal;

    public Array_Type(Type elementType, ArrayDimension dimension, boolean inTypeDefinition) {
        this.elementType = elementType;
        this.dimension = dimension;
        this.inTypeDefinition = inTypeDefinition;
        this.componentInternal = false;
        if (elementType != null) {
            elementType.setFullNameParent(this);
        }
        if (dimension != null) {
            dimension.setFullNameParent(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ARRAY;
    }

    public ArrayDimension getDimension() {
        return this.dimension;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.elementType == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.dimension == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.elementType != null) {
            this.elementType.setMyScope(scope);
        }
        if (this.dimension != null) {
            this.dimension.setMyScope(scope);
        }
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                ASN1_Sequence_Type tempType = (ASN1_Sequence_Type)temp;
                long thisNofComps = this.getDimension().getSize();
                int tempTypeNofComps = tempType.getNofComponents(timestamp);
                if (tempTypeNofComps == 0) {
                    return false;
                }
                if (thisNofComps != (long)tempTypeNofComps) {
                    info.setErrorStr(MessageFormat.format(NOFFIELDSDONTMATCH, thisNofComps, tempTypeNofComps));
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    IType tempElementType = this.getElementType().getTypeRefdLast(timestamp);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(tempElementType);
                    rChain.add(tempTypeCfType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(tempElementType, tempTypeCfType, false);
                    if (!(tempElementType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || tempElementType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Sequence_Type tempType = (TTCN3_Sequence_Type)temp;
                long nofComps = this.getDimension().getSize();
                int tempTypeNofComps = tempType.getNofComponents();
                if (tempTypeNofComps == 0) {
                    return false;
                }
                if (nofComps != (long)tempTypeNofComps) {
                    info.setErrorStr(MessageFormat.format(NOFFIELDSDONTMATCH, nofComps, tempTypeNofComps));
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    IType tempElementType = this.getElementType().getTypeRefdLast(timestamp);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(tempElementType);
                    rChain.add(tempTypeCfType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(tempElementType, tempTypeCfType, false);
                    if (!(tempElementType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || tempElementType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SEQUENCE_OF: {
                SequenceOf_Type tempType = (SequenceOf_Type)temp;
                if (!tempType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                IType tempTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                IType tempElementType = this.getElementType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(tempElementType);
                rChain.add(tempTypeOfType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(tempElementType, tempTypeOfType, false);
                if (!(tempElementType.equals(tempTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || tempElementType.isCompatible(timestamp, tempTypeOfType, infoTemp, lChain, rChain))) {
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    if (infoTemp.getOp2RefStr().length() > 0) {
                        info.appendOp2Ref("[]");
                    }
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ARRAY: {
                Array_Type tempType = (Array_Type)temp;
                if (this == tempType) {
                    return true;
                }
                if (this.dimension != null && tempType.dimension != null && !this.dimension.isIdentical(timestamp, tempType.dimension)) {
                    info.setErrorStr(BADARRAYDIMENSION);
                    return false;
                }
                IType tempElementType = this.getElementType().getTypeRefdLast(timestamp);
                IType tempTypeElementType = tempType.getElementType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(tempElementType);
                rChain.add(tempTypeElementType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(tempElementType, tempTypeElementType, false);
                if (!(tempElementType.equals(tempTypeElementType) || lChain.hasRecursion() && rChain.hasRecursion() || tempElementType.isCompatible(timestamp, tempTypeElementType, infoTemp, lChain, rChain))) {
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        if (!IType.Type_type.TYPE_ARRAY.equals((Object)temp.getTypetype())) {
            return false;
        }
        Array_Type other = (Array_Type)temp;
        boolean result = this.elementType != null && other.elementType != null && this.elementType.isIdentical(timestamp, other.elementType);
        return result && this.dimension != null && other.dimension != null && this.dimension.isIdentical(timestamp, other.dimension);
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.componentInternal;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.elementType != null && referenceChain.add(this)) {
            referenceChain.markState();
            this.elementType.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.componentInternal = false;
        this.isErroneous = false;
        this.parseAttributes(timestamp);
        if (this.elementType != null) {
            this.elementType.setParentType(this);
            this.elementType.check(timestamp);
            this.elementType.checkEmbedded(timestamp, this.elementType.getLocation(), true, "embedded into an array type");
            this.componentInternal = this.elementType.isComponentInternal(timestamp);
        }
        if (this.dimension != null) {
            this.dimension.check(timestamp);
        }
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        if (typeSet.contains(this)) {
            return;
        }
        if (this.elementType != null && this.elementType.isComponentInternal(timestamp)) {
            typeSet.add(this);
            this.elementType.checkComponentInternal(timestamp, typeSet, operation);
            typeSet.remove(this);
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCEOF_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.ARRAY_VALUE);
                this.checkThisValueArray(timestamp, value, (Array_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case ARRAY_VALUE: {
                this.checkThisValueArray(timestamp, value, (Array_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(ARRAYVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueArray(CompilationTimeStamp timestamp, IValue originalValue, Array_Value lastValue, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        if (this.dimension == null) {
            return;
        }
        int nofValues = lastValue.getNofComponents();
        if (!this.dimension.getIsErroneous(timestamp) && this.dimension.getSize() < (long)nofValues) {
            originalValue.getLocation().reportSemanticError(MessageFormat.format(TOOMANYEXPECTED, this.dimension.getSize(), nofValues));
            originalValue.setIsErroneous(true);
        }
        if (lastValue.isIndexed()) {
            boolean checkHoles = !this.dimension.getIsErroneous(timestamp) && Expected_Value_type.EXPECTED_CONSTANT.equals((Object)expectedValue);
            long arraySize = this.dimension.getSize();
            BigInteger maxIndex = BigInteger.valueOf(-1L);
            HashMap<BigInteger, Integer> indexMap = new HashMap<BigInteger, Integer>(lastValue.getNofComponents());
            int size = lastValue.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = lastValue.getValueByIndex(i);
                Value index = lastValue.getIndexByIndex(i);
                this.dimension.checkIndex(timestamp, index, expectedValue);
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue indexLast = index.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (indexLast.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)indexLast.getValuetype())) {
                    checkHoles = false;
                } else {
                    BigInteger tempIndex = ((Integer_Value)indexLast).getValueValue();
                    if (tempIndex.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                        index.getLocation().reportSemanticError(MessageFormat.format("A integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''", Integer.MAX_VALUE, this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (tempIndex.compareTo(BigInteger.ZERO) == -1) {
                        index.getLocation().reportSemanticError(MessageFormat.format("A non-negative integer value was expected for indexing type `{0}'' instead of `{1}''", this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (indexMap.containsKey(tempIndex)) {
                        index.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value `{0}'' for components {1} and {2}", tempIndex, indexMap.get(tempIndex), i + 1));
                        checkHoles = false;
                    } else {
                        indexMap.put(tempIndex, i + 1);
                        if (maxIndex.compareTo(tempIndex) == -1) {
                            maxIndex = tempIndex;
                        }
                    }
                }
                component.setMyGovernor(this.elementType);
                IValue tempValue2 = this.elementType.checkThisValueRef(timestamp, component);
                this.elementType.checkThisValue(timestamp, tempValue2, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
            if (checkHoles && (long)indexMap.size() < arraySize) {
                lastValue.getLocation().reportSemanticError("It's not allowed to create hole(s) in constant values");
                originalValue.setIsErroneous(true);
            }
        } else {
            if (!this.dimension.getIsErroneous(timestamp)) {
                long arraySize = this.dimension.getSize();
                if (arraySize > (long)nofValues) {
                    originalValue.getLocation().reportSemanticError(MessageFormat.format(TOOFEWEXPECTED, arraySize, nofValues));
                    originalValue.setIsErroneous(true);
                } else if (arraySize < (long)nofValues) {
                    originalValue.getLocation().reportSemanticError(MessageFormat.format(TOOMANYEXPECTED, arraySize, nofValues));
                    originalValue.setIsErroneous(true);
                }
            }
            int size = lastValue.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = lastValue.getValueByIndex(i);
                component.setMyGovernor(this.elementType);
                if (IValue.Value_type.NOTUSED_VALUE.equals((Object)component.getValuetype())) {
                    if (incompleteAllowed) continue;
                    component.getLocation().reportSemanticError("Not used symbol `-' is not allowed in this context");
                    continue;
                }
                IValue tempValue2 = this.elementType.checkThisValueRef(timestamp, component);
                this.elementType.checkThisValue(timestamp, tempValue2, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
        }
    }

    public IType getElementType() {
        return this.elementType;
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case OMIT_VALUE: {
                if (template.getLengthRestriction() == null) break;
                template.getLocation().reportSemanticWarning(REDUNDANTLENGTHRESTRICTION);
                break;
            }
            case TEMPLATE_LIST: {
                ITTCN3Template baseTemplate = template.getBaseTemplate();
                int nofBaseComponents = 0;
                if (baseTemplate != null) {
                    if (ITTCN3Template.Template_type.TEMPLATE_LIST.equals((Object)(baseTemplate = baseTemplate.getTemplateReferencedLast(timestamp, null)).getTemplatetype())) {
                        nofBaseComponents = ((Template_List)baseTemplate).getNofTemplates();
                    } else {
                        baseTemplate = null;
                    }
                }
                if (!this.dimension.getIsErroneous(timestamp)) {
                    int templateSize;
                    long arraySize = this.dimension.getSize();
                    if (arraySize < (long)(templateSize = ((Template_List)template).getNofTemplates())) {
                        template.getLocation().reportSemanticError(MessageFormat.format(TOOMANYTEMPLATEELEMENTS, arraySize, templateSize));
                    } else if (arraySize > (long)templateSize) {
                        template.getLocation().reportSemanticError(MessageFormat.format(TOOFEWTEMPLATEELEMENTS, arraySize, templateSize));
                    }
                }
                int nofComponents = ((Template_List)template).getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = ((Template_List)template).getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.elementType);
                    if (baseTemplate == null || i >= nofBaseComponents) continue;
                    templateComponent.setBaseTemplate(((Template_List)baseTemplate).getTemplateByIndex(i));
                    templateComponent = this.elementType.checkThisTemplateRef(timestamp, templateComponent);
                    if (ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)templateComponent.getTemplatetype())) {
                        if (isModified) continue;
                        templateComponent.getLocation().reportSemanticError(NOTUSEDNOTALLOWED);
                        continue;
                    }
                    templateComponent.checkThisTemplateGeneric(timestamp, this.elementType, isModified, false, true, true, implicitOmit);
                }
                break;
            }
            case INDEXED_TEMPLATE_LIST: {
                HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
                Indexed_Template_List indexedTemplateList = (Indexed_Template_List)template;
                for (int i = 0; i < indexedTemplateList.getNofTemplates(); ++i) {
                    IndexedTemplate indexedTemplate = indexedTemplateList.getIndexedTemplateByIndex(i);
                    Value indexValue = indexedTemplate.getIndex().getValue();
                    this.dimension.checkIndex(timestamp, indexValue, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                    ITTCN3Template templateComponent = indexedTemplate.getTemplate();
                    ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IValue lastValue = indexValue.getValueRefdLast(timestamp, chain);
                    chain.release();
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)lastValue.getValuetype())) {
                        long index = ((Integer_Value)lastValue).getValue();
                        if (index > Integer.MAX_VALUE) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format("An integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''", Integer.MAX_VALUE, this.getTypename(), index));
                            indexValue.setIsErroneous(true);
                        } else if (indexMap.containsKey(index)) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value `{0}'' for component `{1}'' and `{2}''", index, i + 1, indexMap.get(index)));
                            indexValue.setIsErroneous(true);
                        } else {
                            indexMap.put(index, i);
                        }
                    }
                    templateComponent.setMyGovernor(this.elementType);
                    templateComponent = this.elementType.checkThisTemplateRef(timestamp, templateComponent);
                    templateComponent.checkThisTemplateGeneric(timestamp, this.elementType, isModified, false, true, true, implicitOmit);
                }
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        if (this.isErroneous || this.elementType == null || this == this.elementType) {
            return "Erroneous type";
        }
        StringBuilder builder = new StringBuilder(this.elementType.getTypename());
        builder.append(this.dimension.createStringRepresentation());
        Type temp = this.elementType;
        while (temp != null && IType.Type_type.TYPE_ARRAY.equals((Object)temp.getTypetype())) {
            Array_Type tempArray = (Array_Type)temp;
            builder.append(tempArray.dimension.createStringRepresentation());
            temp = tempArray.elementType;
        }
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "array.gif";
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value indexValue = ((ArraySubReference)subreference).getValue();
                if (this.dimension != null) {
                    this.dimension.checkIndex(timestamp, indexValue, expectedIndex);
                }
                if (this.elementType != null) {
                    return this.elementType.getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        builder.append("array of ");
        if (this.elementType != null) {
            this.elementType.getProposalDescription(builder);
        }
        return builder;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() < i) {
            return;
        }
        if (subreferences.size() == i) {
            ISubReference subreference = subreferences.get(i - 1);
            if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
                String candidate = ((FieldSubReference)subreference).getId().getDisplayName();
                propCollector.addTemplateProposal(candidate, new Template(candidate + "[index]", candidate + " with index", propCollector.getContextIdentifier(), candidate + "[${index}]", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            }
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() > i + 1 && this.elementType != null) {
            this.elementType.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() > i + 1 && this.elementType != null) {
            this.elementType.addDeclaration(declarationCollector, i + 1);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.elementType != null) {
            this.elementType.updateSyntax(reparser, false);
            reparser.updateLocation(this.elementType.getLocation());
        }
        if (this.dimension != null) {
            this.dimension.updateSyntax(reparser, false);
            reparser.updateLocation(this.dimension.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.elementType == null) {
            return;
        }
        this.elementType.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.elementType != null) {
            this.elementType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.dimension != null) {
            this.dimension.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.elementType != null && !this.elementType.accept(v)) {
            return false;
        }
        return this.dimension == null || this.dimension.accept(v);
    }

    @Override
    public Declaration resolveReference(Reference reference, int subRefIdx, ISubReference lastSubreference) {
        if (this.elementType == null) {
            return null;
        }
        IType refdLastOfType = this.elementType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdLastOfType instanceof IReferenceableElement) {
            return ((IReferenceableElement)((Object)refdLastOfType)).resolveReference(reference, subRefIdx + 1, lastSubreference);
        }
        return null;
    }
}

