/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Altstep_Reference_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Altstep_Type
extends Type {
    private static final String ALTSTEPREFERENCEVALUEEXPECTED = "Reference to an altstep was expected";
    private static final String RUNSONLESSEXPECTED = "Type `{0}'' does not have a `runs on'' clause, but {1} runs on `{2}''.";
    private static final String INCOMPATIBLERUNSONTYPESERROR = "Runs on clause mismatch: type `{0}'' expects component type `{1}'', but {2} runs on `{3}''";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `{0}''";
    private static final String FULLNAMEPART1 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART2 = ".<runsOnType>";
    private final FormalParameterList formalParList;
    private final Reference runsOnRef;
    private Component_Type runsOnType;
    private final boolean runsOnSelf;

    public Altstep_Type(FormalParameterList formalParList, Reference runsOnRef, boolean runsOnSelf) {
        this.formalParList = formalParList;
        this.runsOnRef = runsOnRef;
        this.runsOnSelf = runsOnSelf;
        formalParList.setFullNameParent(this);
        if (runsOnRef != null) {
            runsOnRef.setFullNameParent(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ALTSTEP;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.formalParList == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.runsOnRef == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.formalParList.setMyScope(scope);
        if (this.runsOnRef != null) {
            this.runsOnRef.setMyScope(scope);
        }
        scope.addSubScope(this.formalParList.getLocation(), this.formalParList);
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_ALTSTEP.equals((Object)temp.getTypetype());
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    public FormalParameterList getFormalParameters() {
        return this.formalParList;
    }

    public Component_Type getRunsOnType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnType;
    }

    public boolean isRunsOnSelf() {
        return this.runsOnSelf;
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "altstep.gif";
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnSelf;
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_ALTSTEP;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.runsOnType = null;
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        this.parseAttributes(timestamp);
        if (this.runsOnRef != null) {
            this.runsOnType = this.runsOnRef.chkComponentypeReference(timestamp);
            if (this.runsOnType != null) {
                Scope formalParlistPreviosScope = this.formalParList.getParentScope();
                if (formalParlistPreviosScope instanceof RunsOnScope && ((RunsOnScope)formalParlistPreviosScope).getParentScope() == this.myScope) {
                    ((RunsOnScope)formalParlistPreviosScope).setComponentType(this.runsOnType);
                } else {
                    RunsOnScope tempScope = new RunsOnScope(this.runsOnType, this.myScope);
                    this.formalParList.setMyScope(tempScope);
                }
            }
        }
        this.formalParList.reset();
        this.formalParList.check(timestamp, Assignment.Assignment_type.A_ALTSTEP);
        this.formalParList.checkNoLazyParams();
        this.checkSubtypeRestrictions(timestamp);
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        if (this.runsOnSelf) {
            this.location.reportSemanticError(MessageFormat.format("Altstep type `{0}'' with `runs on self'' clause cannot be {1}", this.getTypename(), operation));
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        Def_Altstep altstep = null;
        switch (last.getValuetype()) {
            case ALTSTEP_REFERENCE_VALUE: {
                altstep = ((Altstep_Reference_Value)last).getReferredAltstep();
                if (altstep == null) {
                    this.setIsErroneous(true);
                    return;
                }
                altstep.check(timestamp);
                break;
            }
            case TTCN3_NULL_VALUE: {
                return;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                return;
            }
            default: {
                value.getLocation().reportSemanticError(ALTSTEPREFERENCEVALUEEXPECTED);
                value.setIsErroneous(true);
                return;
            }
        }
        this.formalParList.checkCompatibility(timestamp, altstep.getFormalParameterList(), value.getLocation());
        Component_Type temporalRunsOnType = altstep.getRunsOnType(timestamp);
        if (temporalRunsOnType != null) {
            if (this.runsOnSelf) {
                Scope valueScope = value.getMyScope();
                if (valueScope == null) {
                    value.setIsErroneous(true);
                    return;
                }
                RunsOnScope runsOnScope = valueScope.getScopeRunsOn();
                if (runsOnScope != null) {
                    Component_Type componentType = runsOnScope.getComponentType();
                    if (!this.runsOnType.isCompatible(timestamp, componentType, null, null, null)) {
                        value.getLocation().reportSemanticError(MessageFormat.format("Runs on clause mismatch: type `{0}'' has a `runs on self'' clause and the current scope expects component type `{1}'', but {2} runs on `{3}''", this.getTypename(), componentType.getTypename(), altstep.getDescription(), temporalRunsOnType.getTypename()));
                    }
                } else if (valueScope instanceof ComponentTypeBody) {
                    ComponentTypeBody body = (ComponentTypeBody)valueScope;
                    if (!this.runsOnType.isCompatible(timestamp, body.getMyType(), null, null, null)) {
                        value.getLocation().reportSemanticError(MessageFormat.format("Runs on clause mismatch: type `{0}'' has a `runs on self'' clause and the current component definition is of type `{1}'', but {2} runs on `{3}''", this.getTypename(), body.getMyType().getTypename(), altstep.getDescription(), temporalRunsOnType.getTypename()));
                    }
                } else {
                    value.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' has a `runs on self'' clause and the current scope does not have a `runs on'' clause, but {1} runs on `{2}''", this.getTypename(), altstep.getDescription(), temporalRunsOnType.getTypename()));
                }
            } else if (this.runsOnRef == null) {
                value.getLocation().reportSemanticError(MessageFormat.format(RUNSONLESSEXPECTED, this.getTypename(), altstep.getAssignmentName(), temporalRunsOnType.getTypename()));
                value.setIsErroneous(true);
            } else if (this.runsOnType != null && !temporalRunsOnType.isCompatible(timestamp, this.runsOnType, null, null, null)) {
                value.getLocation().reportSemanticError(MessageFormat.format(INCOMPATIBLERUNSONTYPESERROR, this.getTypename(), this.runsOnType.getTypename(), altstep.getAssignmentName(), temporalRunsOnType.getTypename()));
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, value);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("altstep type");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() != i + 1 || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        propCollector.addTemplateProposal("apply", new Template("apply( parameters )", "", propCollector.getContextIdentifier(), "apply( ${parameters} )", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.runsOnRef.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.runsOnRef != null && this.runsOnType != null && this.runsOnType == referenceFinder.type) {
            foundIdentifiers.add(new ReferenceFinder.Hit(this.runsOnRef.getId(), this.runsOnRef));
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        return this.runsOnRef == null || this.runsOnRef.accept(v);
    }
}

