/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.CompositeTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.AST.TTCN3.templates.ListOfTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateBody;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ComplementedList_Template
extends CompositeTemplate {
    private static final String ANYOROMITWARNING = "`*'' in complemented list. This template will not match anything.";

    public ComplementedList_Template(ListOfTemplates templates) {
        super(templates);
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.COMPLEMENTED_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous complemented list match";
        }
        return "complemented list match";
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IType type = this.templates.getTemplateByIndex(i).getExpressionGovernor(timestamp, expectedValue);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IType.Type_type type = this.templates.getTemplateByIndex(i).getExpressionReturntype(timestamp, expectedValue);
            if (IType.Type_type.TYPE_UNDEFINED.equals((Object)type)) continue;
            return type;
        }
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of a complemented list match");
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        if (type == null) {
            return;
        }
        boolean allowOmitInValueList = this.allowOmitInValueList(allowOmit);
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            ITemplateListItem component = this.templates.getTemplateByIndex(i);
            component.setMyGovernor(type);
            ITTCN3Template temporalComponent = type.checkThisTemplateRef(timestamp, component);
            temporalComponent.checkThisTemplateGeneric(timestamp, type, false, allowOmitInValueList, true, subCheck, implicitOmit);
            if (!ITTCN3Template.Template_type.ANY_OR_OMIT.equals((Object)temporalComponent.getTemplatetype())) continue;
            component.getLocation().reportSemanticWarning(ANYOROMITWARNING);
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        boolean allowOmitInValueList = this.allowOmitInValueList(true);
        if (allowOmitInValueList) {
            boolean hasAnyOrOmit = false;
            int size = this.templates.getNofTemplates();
            for (int i = 0; i < size; ++i) {
                IValue value;
                TTCN3Template template;
                ITemplateListItem component = this.templates.getTemplateByIndex(i);
                if (component instanceof TemplateBody && ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)(template = ((TemplateBody)component).getTemplate()).getTemplatetype()) && IValue.Value_type.OMIT_VALUE.equals((Object)(value = ((SpecificValue_Template)template).getSpecificValue()).getValuetype())) {
                    hasAnyOrOmit = true;
                    break;
                }
                ITTCN3Template.Template_type componentType = component.getTemplatetype();
                if (!ITTCN3Template.Template_type.ANY_OR_OMIT.equals((Object)componentType)) continue;
                hasAnyOrOmit = true;
                break;
            }
            if (!hasAnyOrOmit) {
                this.location.reportSemanticError(MessageFormat.format("Restriction on {0} does not allow usage of `{1}'' without omit or AnyValueOrNone in the list", definitionName, this.getTemplateTypeName()));
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getNameForStringRep() {
        return "complement";
    }
}

