/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Redirect;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Getcall_Statement
extends Statement {
    private static final String SIGNATUREPARAMETEREXPECTED = "The type of parameter is `{0}'', which is not a signature";
    private static final String ANYWITHREDIRECT = "Operation `any port.{0}'' cannot have parameter redirect";
    private static final String ANYWITHPARAMETER = "operation `any port.{0}'' cannot have parameter";
    private static final String SIGNATURENOTPRESENT = "Signature `{0}'' is not present on the incoming list of port type `{1}''";
    private static final String UNKNOWNSIGNATURETYPE = "Cannot determine the type of the signature";
    private static final String MESSAGEBASEDPORT = "Procedure-based operation `{0}'' is not applicable to a massage-based port of type `{1}''";
    private static final String NOINSIGNATURES = "Port type `{0}'' does not have any incoming signatures";
    private static final String REDIRECTWITHOUTSIGNATURE = "Parameter redirect cannot be used without signature template";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".parameter";
    private static final String FULLNAMEPART3 = ".from";
    private static final String FULLNAMEPART4 = ".parameters";
    private static final String FULLNAMEPART5 = ".redirectSender";
    private static final String STATEMENT_NAME = "getcall";
    private final Reference portReference;
    private final TemplateInstance parameter;
    private final TemplateInstance fromClause;
    private final Parameter_Redirect redirectParameter;
    private final Reference redirectSender;

    public Getcall_Statement(Reference portReference, TemplateInstance parameter, TemplateInstance fromClause, Parameter_Redirect redirectParameter, Reference redirectSender) {
        this.portReference = portReference;
        this.parameter = parameter;
        this.fromClause = fromClause;
        this.redirectParameter = redirectParameter;
        this.redirectSender = redirectSender;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectParameter != null) {
            redirectParameter.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_GETCALL;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.redirectParameter == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART5);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Getcall_Statement.checkGetcallStatement(timestamp, this, STATEMENT_NAME, this.portReference, this.parameter, this.fromClause, this.redirectParameter, this.redirectSender);
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    public static void checkGetcallStatement(CompilationTimeStamp timestamp, Statement statement, String statementName, Reference portReference, TemplateInstance parameter, TemplateInstance fromClause, Parameter_Redirect redirect, Reference redirectSender) {
        Port_Type portType = Port_Utility.checkPortReference(timestamp, statement, portReference);
        if (parameter == null) {
            if (portType != null) {
                PortTypeBody body = portType.getPortBody();
                if (PortTypeBody.OperationModes.OP_Message.equals((Object)body.getOperationMode())) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(MESSAGEBASEDPORT, statementName, portType.getTypename()));
                } else if (body.getInSignatures() == null) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(NOINSIGNATURES, portType.getTypename()));
                }
            }
            if (redirect != null) {
                redirect.getLocation().reportSemanticError(REDIRECTWITHOUTSIGNATURE);
                redirect.checkErroneous(timestamp);
            }
        } else {
            IType signature = null;
            boolean signatureDetermined = false;
            if (portType != null) {
                PortTypeBody body = portType.getPortBody();
                TypeSet inSignatures = body.getInSignatures();
                if (PortTypeBody.OperationModes.OP_Message.equals((Object)body.getOperationMode())) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(MESSAGEBASEDPORT, statementName, portType.getTypename()));
                } else if (inSignatures != null) {
                    if (inSignatures.getNofTypes() == 1) {
                        signature = inSignatures.getTypeByIndex(0);
                    } else {
                        signature = Port_Utility.getOutgoingType(timestamp, parameter);
                        if (signature == null) {
                            parameter.getLocation().reportSemanticError(UNKNOWNSIGNATURETYPE);
                        } else if (!inSignatures.hasType(timestamp, signature)) {
                            parameter.getLocation().reportSemanticError(MessageFormat.format(SIGNATURENOTPRESENT, signature.getTypename(), portType.getTypename()));
                        }
                    }
                    signatureDetermined = true;
                } else {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(NOINSIGNATURES, portType.getTypename()));
                }
            } else if (portReference == null) {
                parameter.getLocation().reportSemanticError(MessageFormat.format(ANYWITHPARAMETER, statementName));
                if (redirect != null) {
                    redirect.getLocation().reportSemanticError(MessageFormat.format(ANYWITHREDIRECT, statementName));
                }
            }
            if (!signatureDetermined) {
                signature = Port_Utility.getOutgoingType(timestamp, parameter);
            }
            if (signature != null) {
                parameter.check(timestamp, signature);
                signature = signature.getTypeRefdLast(timestamp);
                switch (signature.getTypetype()) {
                    case TYPE_SIGNATURE: {
                        ((Signature_Type)signature).checkThisTemplate(timestamp, parameter.getTemplateBody(), false, false);
                        if (redirect == null) break;
                        redirect.check(timestamp, (Signature_Type)signature, false);
                        break;
                    }
                    default: {
                        parameter.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREPARAMETEREXPECTED, signature.getTypename()));
                        if (redirect == null) break;
                        redirect.checkErroneous(timestamp);
                    }
                }
            }
        }
        Port_Utility.checkFromClause(timestamp, statement, portType, fromClause, redirectSender);
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(129);
        if (this.redirectParameter != null) {
            return result;
        }
        result.add(219);
        if (this.fromClause != null) {
            return result;
        }
        result.add(54);
        if (this.parameter != null) {
            return result;
        }
        result.add(251);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectParameter.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        if (this.redirectParameter != null && !this.redirectParameter.accept(v)) {
            return false;
        }
        return this.redirectSender == null || this.redirectSender.accept(v);
    }
}

