/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Done_Statement
extends Statement {
    private static final String FULLNAMEPART1 = "componentreference";
    private static final String FULLNAMEPART2 = "donematch";
    private static final String FULLNAMEPART3 = "redirection";
    private static final String STATEMENT_NAME = "done";
    private final Value componentreference;
    private final TemplateInstance doneMatch;
    private final Reference redirect;

    public Done_Statement(Value componentreference, TemplateInstance doneMatch, Reference redirect) {
        this.componentreference = componentreference;
        this.doneMatch = doneMatch;
        this.redirect = redirect;
        if (componentreference != null) {
            componentreference.setFullNameParent(this);
        }
        if (doneMatch != null) {
            doneMatch.setFullNameParent(this);
        }
        if (redirect != null) {
            redirect.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_DONE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentreference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.doneMatch == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.redirect == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentreference != null) {
            this.componentreference.setMyScope(scope);
        }
        if (this.doneMatch != null) {
            this.doneMatch.setMyScope(scope);
        }
        if (this.redirect != null) {
            this.redirect.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Port_Utility.checkComponentReference(timestamp, this, this.componentreference, false, false);
        if (this.componentreference == null) {
            this.lastTimeChecked = timestamp;
            return;
        }
        if (this.doneMatch != null) {
            boolean[] valueRedirectChecked = new boolean[]{false};
            IType returnType = Port_Utility.getIncomingType(timestamp, this.doneMatch, this.redirect, valueRedirectChecked);
            if (returnType == null) {
                this.doneMatch.getLocation().reportSemanticError("Cannot determine the return type for value returning done");
            } else {
                IType lastType = returnType;
                boolean returnTypeCorrect = false;
                while (!returnTypeCorrect) {
                    if (lastType.hasDoneAttribute()) {
                        returnTypeCorrect = true;
                        break;
                    }
                    if (!(lastType instanceof IReferencingType)) break;
                    ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IType refd = ((IReferencingType)((Object)lastType)).getTypeRefd(timestamp, refChain);
                    refChain.release();
                    if (lastType == refd) break;
                    lastType = refd;
                }
                if (!returnTypeCorrect) {
                    this.location.reportSemanticError(MessageFormat.format("Return type `{0}'' does not have `done'' extension attibute", returnType.getTypename()));
                    returnType.setIsErroneous(true);
                }
                this.doneMatch.check(timestamp, returnType);
                if (!valueRedirectChecked[0]) {
                    Port_Utility.checkValueRedirect(timestamp, this.redirect, returnType);
                }
            }
        } else if (this.redirect != null) {
            this.redirect.getLocation().reportSemanticError("Redirect cannot be used for the return value without a matching template");
            Port_Utility.checkValueRedirect(timestamp, this.redirect, null);
            this.redirect.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirect != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(219);
        if (this.doneMatch != null) {
            return result;
        }
        result.add(251);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentreference != null) {
            this.componentreference.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentreference.getLocation());
        }
        if (this.doneMatch != null) {
            this.doneMatch.updateSyntax(reparser, false);
            reparser.updateLocation(this.doneMatch.getLocation());
        }
        if (this.redirect != null) {
            this.redirect.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirect.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentreference != null) {
            this.componentreference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.doneMatch != null) {
            this.doneMatch.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirect != null) {
            this.redirect.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentreference != null && !this.componentreference.accept(v)) {
            return false;
        }
        if (this.doneMatch != null && !this.doneMatch.accept(v)) {
            return false;
        }
        return this.redirect == null || this.redirect.accept(v);
    }
}

