/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class SimpleTypeMappingTarget
extends TypeMappingTarget {
    private final Type targetType;

    public SimpleTypeMappingTarget(Type targetType) {
        this.targetType = targetType;
    }

    @Override
    public TypeMappingTarget.TypeMapping_type getTypeMappingType() {
        return TypeMappingTarget.TypeMapping_type.SIMPLE;
    }

    @Override
    public String getMappingName() {
        return "simple";
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Type source) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (source != null && !source.isIdentical(timestamp, this.targetType)) {
            this.targetType.getLocation().reportSemanticError(MessageFormat.format("The source and target types must be the same: `{0}'' was expected instead of `{1}''", source.getTypename(), this.targetType.getTypename()));
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.targetType != null) {
            this.targetType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.targetType == null || this.targetType.accept(v);
    }
}

