/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.UniversalCharstring_Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class BMPString_Type
extends ASN1Type {
    private static final String BMPSTRINGVALUEEXPECTED = "BMP string value was expected";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_BMPSTRING;
    }

    @Override
    public IASN1Type newInstance() {
        return new BMPString_Type();
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_UCHARSTRING;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        switch (temp.getTypetype()) {
            case TYPE_UCHARSTRING: 
            case TYPE_UTF8STRING: 
            case TYPE_BMPSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_NUMERICSTRING: 
            case TYPE_PRINTABLESTRING: 
            case TYPE_IA5STRING: 
            case TYPE_VISIBLESTRING: 
            case TYPE_UTCTIME: 
            case TYPE_GENERALIZEDTIME: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTypename() {
        return "BMPString";
    }

    @Override
    public String getOutlineIcon() {
        return "universal_charstring.gif";
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (null == last || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.CHARSYMBOLS_VALUE);
                if (last.getIsErroneous(timestamp)) {
                    return;
                }
                last.setValuetype(timestamp, IValue.Value_type.UNIVERSALCHARSTRING_VALUE);
                break;
            }
            case CHARSYMBOLS_VALUE: 
            case CHARSTRING_VALUE: {
                last.setValuetype(timestamp, IValue.Value_type.UNIVERSALCHARSTRING_VALUE);
                break;
            }
            case ISO2022STRING_VALUE: {
                this.location.reportSemanticError("ISO-10646 string value cannot be converted to ISO-2022 string");
                this.setIsErroneous(true);
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(BMPSTRINGVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        UniversalCharstring_Type.checkThisTemplateString(timestamp, this, template, isModified);
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                if (subreferences.size() > actualSubReference + 1) {
                    subreference.getLocation().reportSemanticError("A string element cannot be indexed");
                    return null;
                }
                if (subreferences.size() == actualSubReference + 1) {
                    reference.setStringElementReferencing();
                }
                return this;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("BMP string");
    }
}

