/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.OmitValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_Sequence_Type
extends ASN1_Set_Seq_Choice_BaseType {
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for record type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for record type `{0}''";
    private static final String SEQUANCEEPECTED = "SEQUENCE value was expected for type `{0}''";
    private static final String NONEXISTENTFIELDERRORASN1 = "Reference to a non-existent component `{0}'' of SEQUENCE type `{1}''";
    private static final String DUPLICATEDFIELDFIRSTASN1 = "Component `{0}'' is already given here";
    private static final String DUBLICATEDFIELDAGAINASN1 = "Duplicated SEQUENCE component `{0}''";
    private static final String WRONGFIELDORDERASN1 = "Component `{0}'' cannot appear after component `{1}'' in SEQUENCE value";
    private static final String UNEXPECTEDFIELDASN1 = "Unexpected component `{0}'' in SEQUENCE value, expecting `{1}''";
    private static final String MISSINGFIELDASN1 = "Mandatory component `{0}'' is missing from SEQUENCE value";
    private static final String NONEXISTENTFIELDERRORTTCN3 = "Reference to a non-existent field `{0}'' in record value for type `{1}''";
    private static final String DUPLICATEDFIELDFIRSTTTCN3 = "Field `{0}'' is already given here";
    private static final String DUBLICATEDFIELDAGAINTTCN3 = "Duplicated record field `{0}''";
    private static final String WRONGFIELDORDERTTCN3 = "Field `{0}'' cannot appear after field `{1}'' in record value";
    private static final String UNEXPECTEDFIELDTTCN3 = "Unexpected field `{0}'' in record value, expecting `{1}''";
    private static final String MISSINGFIELDTTCN3 = "Field `{0}'' is missing from record value";
    private static final String DUPLICATETEMPLATEFIELDFIRST = "Duplicate field `{0}'' in template";
    private static final String DUPLICATETEMPLATEFIELDAGAIN = "Field `{0}'' is already given here";
    private static final String INCORRECTTEMPLATEFIELDORDER = "Field `{0}'' cannot appear after field `{1}'' in a template for record type `{2}''";
    private static final String UNEXPECTEDTEMPLATEFIELD = "Unexpected field `{0}'' in record template, expecting `{1}''";
    private static final String NONEXISTENTTEMPLATEFIELDREFERENCE = "Reference to non-existing field `{0}'' in record template for type `{1}''";
    private static final String MISSINGTEMPLATEFIELD = "Field `{0}'' is missing from template for record type `{1}''";
    private static final String NOFFIELDSDONTMATCH = "The number of fields in record/SEQUENCE types must be the same";
    private static final String NOFFIELDSDIMENSIONDONTMATCH = "The number of fields in SEQUENCE types ({0}) and the size of the array ({1}) must be the same";
    private static final String BADOPTIONALITY = "The optionality of fields in record/SEQUENCE types must be the same";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";
    private CompilationTimeStamp trCompsofTimestamp;
    private static boolean defaultAsOptional = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.defaultAsOptional", false, null);
    private static boolean strictConstantCheckingSeverity;

    public ASN1_Sequence_Type(Block aBlock) {
        this.mBlock = aBlock;
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_Sequence_Type(this.mBlock);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ASN1_SEQUENCE;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_SEQUENCE;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                ASN1_Sequence_Type temporalType = (ASN1_Sequence_Type)temp;
                if (this == temporalType) {
                    return true;
                }
                if (this.getNofComponents(timestamp) != temporalType.getNofComponents(timestamp)) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                int size = this.getNofComponents(timestamp);
                for (int i = 0; i < size; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    CompField temporalTypeCompField = temporalType.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType temporalTypeCompFieldType = temporalTypeCompField.getType().getTypeRefdLast(timestamp);
                    if (compField.isOptional() != temporalTypeCompField.isOptional()) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String temporalTypeCompFieldName = temporalTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName);
                        info.appendOp2Ref("." + temporalTypeCompFieldName);
                        info.setOp1Type(compFieldType);
                        info.setOp2Type(temporalTypeCompFieldType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, temporalTypeCompFieldType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(temporalTypeCompFieldType);
                    if (!(compFieldType.equals(temporalTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, temporalTypeCompFieldType, infoTemp, lChain, rChain))) {
                        String compFieldame = compField.getIdentifier().getDisplayName();
                        String temporalTypeCompFieldName = temporalTypeCompField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldame + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + temporalTypeCompFieldName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Sequence_Type tempType = (TTCN3_Sequence_Type)temp;
                if (this.getNofComponents(timestamp) != tempType.getNofComponents()) {
                    info.setErrorStr(NOFFIELDSDONTMATCH);
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents(timestamp);
                for (int i = 0; i < size; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    CompField tempTypeComponentField = tempType.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType temporalTypeCompFieldType = tempTypeComponentField.getType().getTypeRefdLast(timestamp);
                    if (compField.isOptional() != tempTypeComponentField.isOptional()) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String temporalTypeCompFieldName = tempTypeComponentField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName);
                        info.appendOp2Ref("." + temporalTypeCompFieldName);
                        info.setOp1Type(compFieldType);
                        info.setOp2Type(temporalTypeCompFieldType);
                        info.setErrorStr(BADOPTIONALITY);
                        return false;
                    }
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, temporalTypeCompFieldType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(temporalTypeCompFieldType);
                    if (!(compFieldType.equals(temporalTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, temporalTypeCompFieldType, infoTemp, lChain, rChain))) {
                        String compFieldName = compField.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeComponentField.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + compFieldName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCompFieldName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SEQUENCE_OF: {
                SequenceOf_Type temporalType = (SequenceOf_Type)temp;
                if (!temporalType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                int thisNofComps = this.getNofComponents(timestamp);
                if (thisNofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                for (int i = 0; i < thisNofComps; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType temporalTypeOfType = temporalType.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, temporalTypeOfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(temporalTypeOfType);
                    if (!(compFieldType.equals(temporalTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, temporalTypeOfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref("." + compField.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                        if (infoTemp.getOp2RefStr().length() > 0) {
                            info.appendOp2Ref("[]");
                        }
                        info.appendOp2Ref(infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_ARRAY: {
                Array_Type temporalType = (Array_Type)temp;
                int nofComps = this.getNofComponents(timestamp);
                if (nofComps == 0) {
                    return false;
                }
                long temporalTypeNofComps = temporalType.getDimension().getSize();
                if ((long)nofComps != temporalTypeNofComps) {
                    info.setErrorStr(MessageFormat.format(NOFFIELDSDIMENSIONDONTMATCH, nofComps, temporalTypeNofComps));
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                for (int i = 0; i < nofComps; ++i) {
                    CompField compField = this.getComponentByIndex(i);
                    IType compFieldType = compField.getType().getTypeRefdLast(timestamp);
                    IType tempTypeElementType = temporalType.getElementType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(compFieldType, tempTypeElementType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(compFieldType);
                    rChain.add(tempTypeElementType);
                    if (!(compFieldType.equals(tempTypeElementType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, tempTypeElementType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref("." + compField.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                        info.appendOp2Ref(infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "sequence.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("sequence");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.components == null) {
            return;
        }
        if (referenceChain.add(this)) {
            int size = this.components.getNofComps();
            for (int i = 0; i < size; ++i) {
                CompField field = this.components.getCompByIndex(i);
                Type type = field.getType();
                if (field.isOptional() || type == null) continue;
                referenceChain.markState();
                type.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.components != null && this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        if (this.components == null) {
            this.parseBlockSequence();
        }
        if (this.isErroneous || this.components == null) {
            return;
        }
        this.trCompsof(timestamp, null);
        this.components.check(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                if (last.isAsn()) {
                    this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SEQUENCEOF_VALUE: {
                if (((SequenceOf_Value)last).isIndexed()) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Indexed assignment notation cannot be used for SEQUENCE type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                if ((last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE)).isAsn()) {
                    this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE);
                this.checkThisValueSeq(timestamp, (Sequence_Value)last, valueCheckingOptions.expected_value, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(SEQUANCEEPECTED, this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    private void checkThisValueSeq(CompilationTimeStamp timestamp, Sequence_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        CompilationTimeStamp valueTimeStamp = value.getLastTimeChecked();
        if (valueTimeStamp == null || valueTimeStamp.isLess(timestamp)) {
            value.removeGeneratedValues();
        }
        boolean isAsn = value.isAsn();
        boolean inSnyc = true;
        int nofTypeComponents = this.getNofComponents(timestamp);
        int nofValueComponents = value.getNofComponents();
        int nextIndex = 0;
        CompField lastCompField = null;
        int sequenceIndex = 0;
        int i = 0;
        while (i < nofValueComponents) {
            NamedValue namedValue = value.getSeqValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!this.hasComponentWithName(valueId)) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? NONEXISTENTFIELDERRORASN1 : NONEXISTENTFIELDERRORTTCN3, namedValue.getName().getDisplayName(), this.getTypename()));
                inSnyc = false;
            } else {
                if (componentMap.containsKey(valueId.getName())) {
                    namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? DUBLICATEDFIELDAGAINASN1 : DUBLICATEDFIELDAGAINTTCN3, valueId.getDisplayName()));
                    Location tempLocation = ((NamedValue)componentMap.get(valueId.getName())).getLocation();
                    tempLocation.reportSingularSemanticError(MessageFormat.format(isAsn ? DUPLICATEDFIELDFIRSTASN1 : "Field `{0}'' is already given here", valueId.getDisplayName()));
                    inSnyc = false;
                } else {
                    componentMap.put(valueId.getName(), namedValue);
                }
                CompField componentField = this.getComponentByName(valueId);
                if (inSnyc) {
                    if (incompleteAllowed) {
                        boolean found = false;
                        for (int j = nextIndex; j < nofTypeComponents && !found; ++j) {
                            CompField field2 = this.getComponentByIndex(j);
                            if (!valueId.getName().equals(field2.getIdentifier().getName())) continue;
                            lastCompField = field2;
                            nextIndex = j + 1;
                            found = true;
                        }
                        if (lastCompField != null && !found) {
                            namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? WRONGFIELDORDERASN1 : WRONGFIELDORDERTTCN3, valueId.getDisplayName(), lastCompField.getIdentifier().getDisplayName()));
                        }
                    } else {
                        CompField field2;
                        CompField field2Original = field2 = this.getComponentByIndex(sequenceIndex);
                        boolean isOptional = field2.isOptional();
                        if (!isOptional && field2.hasDefault() && defaultAsOptional) {
                            isOptional = true;
                        }
                        while (implicitOmit && sequenceIndex < this.getNofComponents(timestamp) && componentField != field2 && isOptional) {
                            field2 = this.getComponentByIndex(++sequenceIndex);
                        }
                        if (sequenceIndex >= this.getNofComponents(timestamp) || componentField != field2) {
                            namedValue.getLocation().reportSemanticError(MessageFormat.format(isAsn ? UNEXPECTEDFIELDASN1 : UNEXPECTEDFIELDTTCN3, valueId.getDisplayName(), field2Original.getIdentifier().getDisplayName()));
                        }
                    }
                }
                Type type = componentField.getType();
                IValue componentValue = namedValue.getValue();
                if (componentValue != null) {
                    componentValue.setMyGovernor(type);
                    IValue temporalValue = type.checkThisValueRef(timestamp, componentValue);
                    boolean isOptional = componentField.isOptional();
                    if (!isOptional && componentField.hasDefault() && defaultAsOptional) {
                        isOptional = true;
                    }
                    type.checkThisValue(timestamp, temporalValue, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, isOptional, true, implicitOmit, strElem));
                }
            }
            ++i;
            ++sequenceIndex;
        }
        if (!incompleteAllowed || strictConstantCheckingSeverity) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier id = this.getComponentByIndex(i).getIdentifier();
                if (componentMap.containsKey(id.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    value.addNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_TTCN, id.getDisplayName()), new Omit_Value(), false));
                    continue;
                }
                value.getLocation().reportSemanticError(MessageFormat.format(isAsn ? MISSINGFIELDASN1 : MISSINGFIELDTTCN3, id.getDisplayName()));
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                ITTCN3Template transformed = template.setTemplatetype(timestamp, ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST);
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)transformed, isModified, implicitOmit);
                break;
            }
            case NAMED_TEMPLATE_LIST: {
                this.checkThisNamedTemplateList(timestamp, (Named_Template_List)template, isModified, implicitOmit);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
    }

    private void checkThisNamedTemplateList(CompilationTimeStamp timestamp, Named_Template_List templateList, boolean isModified, boolean implicitOmit) {
        int i;
        templateList.removeGeneratedValues();
        HashMap<String, NamedTemplate> componentMap = new HashMap<String, NamedTemplate>();
        int nofTypeComponents = this.getNofComponents(timestamp);
        int nofTemplateComponents = templateList.getNofTemplates();
        boolean inSync = true;
        CompField lastComponentField = null;
        int nextIndex = 0;
        for (i = 0; i < nofTemplateComponents; ++i) {
            NamedTemplate namedTemplate = templateList.getTemplateByIndex(i);
            Identifier identifier = namedTemplate.getName();
            String templateName = identifier.getName();
            if (this.hasComponentWithName(identifier)) {
                Type type;
                if (componentMap.containsKey(templateName)) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(DUPLICATETEMPLATEFIELDFIRST, identifier.getDisplayName()));
                    Location tempLocation = ((NamedTemplate)componentMap.get(templateName)).getLocation();
                    tempLocation.reportSemanticError(MessageFormat.format("Field `{0}'' is already given here", identifier.getDisplayName()));
                    inSync = false;
                } else {
                    componentMap.put(templateName, namedTemplate);
                }
                CompField componentField = this.getComponentByName(identifier);
                if (inSync) {
                    CompField componentField2;
                    if (isModified) {
                        boolean found = false;
                        for (int j = nextIndex; j < nofTypeComponents && !found; ++j) {
                            CompField componentField22 = this.getComponentByIndex(j);
                            if (!templateName.equals(componentField22.getIdentifier().getName())) continue;
                            lastComponentField = componentField22;
                            nextIndex = j + 1;
                            found = true;
                        }
                        if (!found && lastComponentField != null) {
                            namedTemplate.getLocation().reportSemanticError(MessageFormat.format(INCORRECTTEMPLATEFIELDORDER, identifier.getDisplayName(), lastComponentField.getIdentifier().getDisplayName(), this.getFullName()));
                            inSync = false;
                        }
                    } else if (strictConstantCheckingSeverity && (componentField2 = this.getComponentByIndex(i)) != componentField && (!componentField2.isOptional() || componentField2.isOptional() && !implicitOmit)) {
                        namedTemplate.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDTEMPLATEFIELD, identifier.getDisplayName(), componentField2.getIdentifier().getDisplayName()));
                        inSync = false;
                    }
                }
                if ((type = componentField.getType()) == null || type.getIsErroneous(timestamp)) continue;
                ITTCN3Template componentTemplate = namedTemplate.getTemplate();
                componentTemplate.setMyGovernor(type);
                componentTemplate = type.checkThisTemplateRef(timestamp, componentTemplate);
                boolean isOptional = componentField.isOptional();
                if (!isOptional && componentField.hasDefault() && defaultAsOptional) {
                    isOptional = true;
                }
                componentTemplate.checkThisTemplateGeneric(timestamp, type, isModified, isOptional, isOptional, true, implicitOmit);
                continue;
            }
            namedTemplate.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTTEMPLATEFIELDREFERENCE, identifier.getDisplayName(), this.getTypename()));
            inSync = false;
        }
        if (!isModified && strictConstantCheckingSeverity) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier identifier = this.getComponentIdentifierByIndex(i);
                if (componentMap.containsKey(identifier.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    templateList.addNamedValue(new NamedTemplate(new Identifier(Identifier.Identifier_type.ID_TTCN, identifier.getDisplayName()), new OmitValue_Template(), false));
                    continue;
                }
                templateList.getLocation().reportSemanticError(MessageFormat.format(MISSINGTEMPLATEFIELD, identifier.getDisplayName(), this.getTypename()));
            }
        }
    }

    private void parseBlockSequence() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.components = parser.pr_special_ComponentTypeLists().list;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.components = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.components == null) {
            this.isErroneous = true;
            return;
        }
        this.components.setFullNameParent(this);
        this.components.setMyScope(this.getMyScope());
        this.components.setMyType(this);
    }

    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.trCompsofTimestamp != null && !this.trCompsofTimestamp.isLess(timestamp)) {
            return;
        }
        if (referenceChain != null) {
            this.components.trCompsof(timestamp, referenceChain, false);
        } else {
            ReferenceChain temporalReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            this.components.trCompsof(timestamp, temporalReferenceChain, false);
            temporalReferenceChain.release();
        }
        this.trCompsofTimestamp = timestamp;
        this.components.trCompsof(timestamp, null, true);
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                if (this.components == null) {
                    return null;
                }
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                if (interruptIfOptional && compField.isOptional()) {
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return compField.getType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                if (this.components == null) {
                    return false;
                }
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return false;
                }
                int fieldIndex = this.components.components.indexOf(compField);
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                subrefsArray.add(fieldIndex);
                typeArray.add(this);
                return fieldType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return false;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return false;
    }

    static {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.defaultAsOptional".equals(property)) {
                        defaultAsOptional = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.defaultAsOptional", false, null);
                    }
                }
            });
        }
        strictConstantCheckingSeverity = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", false, null);
        activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.reportStrictConstants".equals(property)) {
                        strictConstantCheckingSeverity = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", false, null);
                    }
                }
            });
        }
    }
}

