/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class Undefined_Assignment
extends ASN1Assignment {
    protected static final String CIRCULARASSIGNMENTCHAIN = "Circular assignment chain: {0}";
    protected static final String UNRECOGNISABLEASSIGNMENT = "Cannot recognise this assignment";
    protected Scope rightScope;
    protected ASN1Assignment realAssignment;

    public Undefined_Assignment(Identifier id, Ass_pard assPard) {
        super(id, assPard);
    }

    @Override
    public final Assignment.Assignment_type getAssignmentType() {
        if (null != this.realAssignment) {
            return this.realAssignment.getAssignmentType();
        }
        return Assignment.Assignment_type.A_UNDEF;
    }

    @Override
    public final String getAssignmentName() {
        if (null != this.realAssignment) {
            return this.realAssignment.getAssignmentName();
        }
        return "<undefined assignment>";
    }

    public final ASN1Assignment getRealAssignment(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.realAssignment;
    }

    @Override
    public final void setRightScope(Scope rightScope) {
        if (null != this.realAssignment) {
            this.realAssignment.setRightScope(rightScope);
        }
        this.rightScope = rightScope;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.realAssignment) {
            this.realAssignment.setMyScope(scope);
        }
        this.rightScope = scope;
    }

    @Override
    public final ISetting getSetting(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (null != this.realAssignment) {
            return this.realAssignment.getSetting(timestamp);
        }
        return null;
    }

    @Override
    public final IType getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (null != this.realAssignment) {
            return this.realAssignment.getType(timestamp);
        }
        return null;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        Module module;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (null != this.myScope && null != this.lastTimeChecked && null != (module = this.myScope.getModuleScope()) && module.getSkippedFromSemanticChecking()) {
            this.lastTimeChecked = timestamp;
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.assPard) {
            this.assPard.check(timestamp);
            return;
        }
        this.classifyAssignment(timestamp, null);
        if (null != this.realAssignment) {
            this.realAssignment.check(timestamp);
        }
    }

    @Override
    public final boolean isAssignmentType(CompilationTimeStamp timestamp, Assignment.Assignment_type assignmentType, IReferenceChain referenceChain) {
        this.check(timestamp);
        if (null == this.realAssignment) {
            return false;
        }
        return this.getIsErroneous() ? false : this.realAssignment.isAssignmentType(timestamp, assignmentType, referenceChain);
    }

    protected abstract void classifyAssignment(CompilationTimeStamp var1, IReferenceChain var2);

    @Override
    public final Object[] getOutlineChildren() {
        if (null == this.realAssignment) {
            return super.getOutlineChildren();
        }
        return this.realAssignment.getOutlineChildren();
    }

    @Override
    public final String getOutlineIcon() {
        if (null != this.realAssignment) {
            return this.realAssignment.getOutlineIcon();
        }
        return "titan.gif";
    }

    @Override
    public final void addDeclaration(DeclarationCollector declarationCollector, int i) {
        if (null != this.realAssignment) {
            this.realAssignment.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    public Location getLikelyLocation() {
        if (this.realAssignment != null) {
            return this.realAssignment.getLikelyLocation();
        }
        return super.getLikelyLocation();
    }

    @Override
    public final void addProposal(ProposalCollector propCollector, int i) {
        if (null != this.realAssignment) {
            this.realAssignment.addProposal(propCollector, i);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.realAssignment != null) {
            this.realAssignment.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.realAssignment == null || this.realAssignment.accept(v);
    }
}

