/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedSparseGraph<V, E>
extends AbstractTypedGraph<V, E>
implements DirectedGraph<V, E> {
    protected Map<V, Pair<Map<V, E>>> vertices = new HashMap<V, Pair<Map<V, E>>>();
    protected Map<E, Pair<V>> edges = new HashMap<E, Pair<V>>();

    public static final <V, E> Factory<DirectedGraph<V, E>> getFactory() {
        return new Factory<DirectedGraph<V, E>>(){

            public DirectedGraph<V, E> create() {
                return new DirectedSparseGraph();
            }
        };
    }

    public DirectedSparseGraph() {
        super(EdgeType.DIRECTED);
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        V dest;
        this.validateEdgeType(edgeType);
        Pair<V> new_endpoints = this.getValidatedEndpoints(edge, endpoints);
        if (new_endpoints == null) {
            return false;
        }
        V source = new_endpoints.getFirst();
        if (this.findEdge(source, dest = new_endpoints.getSecond()) != null) {
            return false;
        }
        this.edges.put(edge, new_endpoints);
        if (!this.vertices.containsKey(source)) {
            this.addVertex(source);
        }
        if (!this.vertices.containsKey(dest)) {
            this.addVertex(dest);
        }
        this.vertices.get(source).getSecond().put(dest, edge);
        this.vertices.get(dest).getFirst().put(source, edge);
        return true;
    }

    @Override
    public E findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        return this.vertices.get(v1).getSecond().get(v2);
    }

    @Override
    public Collection<E> findEdgeSet(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        ArrayList<E> edge_collection = new ArrayList<E>(1);
        E e = this.findEdge(v1, v2);
        if (e == null) {
            return edge_collection;
        }
        edge_collection.add(e);
        return edge_collection;
    }

    protected Collection<E> getIncoming_internal(V vertex) {
        return this.vertices.get(vertex).getFirst().values();
    }

    protected Collection<E> getOutgoing_internal(V vertex) {
        return this.vertices.get(vertex).getSecond().values();
    }

    protected Collection<V> getPreds_internal(V vertex) {
        return this.vertices.get(vertex).getFirst().keySet();
    }

    protected Collection<V> getSuccs_internal(V vertex) {
        return this.vertices.get(vertex).getSecond().keySet();
    }

    @Override
    public Collection<E> getInEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getIncoming_internal(vertex));
    }

    @Override
    public Collection<E> getOutEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getOutgoing_internal(vertex));
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getPreds_internal(vertex));
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getSuccs_internal(vertex));
    }

    @Override
    public Pair<V> getEndpoints(E edge) {
        if (!this.containsEdge(edge)) {
            return null;
        }
        return this.edges.get(edge);
    }

    @Override
    public V getSource(E directed_edge) {
        if (!this.containsEdge(directed_edge)) {
            return null;
        }
        return this.edges.get(directed_edge).getFirst();
    }

    @Override
    public V getDest(E directed_edge) {
        if (!this.containsEdge(directed_edge)) {
            return null;
        }
        return this.edges.get(directed_edge).getSecond();
    }

    @Override
    public boolean isSource(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return vertex.equals(this.getEndpoints(edge).getFirst());
    }

    @Override
    public boolean isDest(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return vertex.equals(this.getEndpoints(edge).getSecond());
    }

    @Override
    public Collection<E> getEdges() {
        return Collections.unmodifiableCollection(this.edges.keySet());
    }

    @Override
    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertices.keySet());
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.vertices.containsKey(vertex);
    }

    @Override
    public boolean containsEdge(E edge) {
        return this.edges.containsKey(edge);
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size();
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> neighbors = new HashSet<V>();
        neighbors.addAll(this.getPreds_internal(vertex));
        neighbors.addAll(this.getSuccs_internal(vertex));
        return Collections.unmodifiableCollection(neighbors);
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<E> incident_edges = new HashSet<E>();
        incident_edges.addAll(this.getIncoming_internal(vertex));
        incident_edges.addAll(this.getOutgoing_internal(vertex));
        return Collections.unmodifiableCollection(incident_edges);
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put(vertex, new Pair(new HashMap(), new HashMap()));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        ArrayList<E> incident = new ArrayList<E>(this.getIncoming_internal(vertex));
        incident.addAll(this.getOutgoing_internal(vertex));
        for (E edge : incident) {
            this.removeEdge(edge);
        }
        this.vertices.remove(vertex);
        return true;
    }

    @Override
    public boolean removeEdge(E edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        Pair<V> endpoints = this.getEndpoints(edge);
        V source = endpoints.getFirst();
        V dest = endpoints.getSecond();
        this.vertices.get(source).getSecond().remove(dest);
        this.vertices.get(dest).getFirst().remove(source);
        this.edges.remove(edge);
        return true;
    }
}

