/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.Java2DPainter;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.LElem;

class PeriodicActionManager
implements Runnable,
MouseMotionListener,
Java2DPainter {
    static int SLEEP_TIME = 500;
    static int TOOLTIP_TIME = 1000;
    static Color TP_BACKGROUND = new Color(255, 255, 147);
    static Color TP_FOREGROUND = Color.black;
    static Font TP_FONT = new Font("Dialog", 0, 10);
    static int TP_PADDING = 4;
    static int TP_MARGIN = 15;
    private boolean invalidBounds = true;
    GraphicsManager grMngr;
    Thread runTP;
    long lastMouseMoved = System.currentTimeMillis();
    Glyph tippedGlyph;
    String tipLabel;
    int lX;
    int lY;
    int rX;
    int rY;
    int rW;
    int rH;
    boolean updatePalette = false;

    PeriodicActionManager(GraphicsManager gm) {
        this.grMngr = gm;
    }

    public void start() {
        this.runTP = new Thread(this);
        this.runTP.setPriority(1);
        this.runTP.start();
    }

    public synchronized void stop() {
        this.runTP = null;
        this.notify();
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (this.runTP == me) {
            this.updateTooltip();
            this.checkToolPalette();
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    void updateTooltip() {
        Glyph g;
        if (System.currentTimeMillis() - this.lastMouseMoved > (long)TOOLTIP_TIME && (g = this.grMngr.mainView.getPanel().lastGlyphEntered()) != null && g != this.grMngr.boundingBox && this.tippedGlyph != g) {
            this.tippedGlyph = g;
            if (this.tippedGlyph.getOwner() != null && this.tippedGlyph.getOwner() instanceof LElem) {
                this.tipLabel = ((LElem)this.tippedGlyph.getOwner()).getTooltip(this.tippedGlyph);
            }
            if (this.tipLabel != null && this.tipLabel.length() > 0) {
                this.lX = this.grMngr.mainView.mouse.getPanelXCoordinate() + TP_MARGIN;
                this.lY = this.grMngr.mainView.mouse.getPanelYCoordinate() + TP_MARGIN;
                this.invalidBounds = true;
                this.grMngr.vsm.repaint();
            }
        }
    }

    void removeTooltip() {
        this.tipLabel = null;
        this.tippedGlyph = null;
        this.invalidBounds = true;
        this.grMngr.vsm.repaint();
    }

    void computeTipRectangle(int labelWidth, int labelHeight) {
        this.rX = this.lX - TP_PADDING;
        this.rY = this.lY - labelHeight;
        this.rW = labelWidth + TP_PADDING + TP_PADDING;
        this.rH = labelHeight + TP_PADDING;
    }

    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (this.tipLabel != null) {
            Font origFont = g2d.getFont();
            g2d.setFont(TP_FONT);
            if (this.invalidBounds) {
                Rectangle2D r2d = g2d.getFontMetrics().getStringBounds(this.tipLabel, g2d);
                this.computeTipRectangle((int)r2d.getWidth(), (int)r2d.getHeight());
                this.invalidBounds = false;
            }
            g2d.setColor(TP_BACKGROUND);
            g2d.fillRect(this.rX, this.rY, this.rW, this.rH);
            g2d.setColor(TP_FOREGROUND);
            g2d.drawRect(this.rX, this.rY, this.rW, this.rH);
            g2d.drawString(this.tipLabel, this.lX, this.lY);
            g2d.setFont(origFont);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.lastMouseMoved = System.currentTimeMillis();
        this.removeTooltip();
    }

    public void mouseMoved(MouseEvent e) {
        this.lastMouseMoved = System.currentTimeMillis();
        this.removeTooltip();
    }

    void requestToolPaletteRelocation() {
        this.updatePalette = true;
    }

    void checkToolPalette() {
        if (this.updatePalette) {
            this.grMngr.tp.updateHiddenPosition();
            this.updatePalette = false;
        }
    }
}

