/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.serializer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.execution.core.IWorkflowConfigurationConstants;
import org.eclipse.efm.execution.core.util.PrettyPrintWriter;
import org.eclipse.efm.execution.core.workflow.Director;
import org.eclipse.efm.execution.core.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.TraceElementCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.efm.execution.core.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.execution.core.workflow.serializer.impl.BasicTraceSerializerImpl;

public class BasicTraceSerializerWorkerCustomImpl
extends BasicTraceSerializerImpl
implements IWorkflowConfigurationConstants {
    protected BasicTraceSerializerWorkerCustomImpl(Director director, String name) {
        this.setDirector(director);
        this.setName(name);
    }

    protected BasicTraceSerializerWorkerCustomImpl(Director director, String name, String description) {
        this.setDirector(director);
        this.setName(name);
        this.setDescription(description);
    }

    public static BasicTraceSerializerWorkerCustomImpl create(Director director, ILaunchConfiguration configuration) {
        String path;
        String traceFormat;
        boolean enabled;
        BasicTraceSerializerWorkerCustomImpl serializerWorker = new BasicTraceSerializerWorkerCustomImpl(director, "basic_trace_generator");
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ELIMINATION_REDUNDANCE", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        serializerWorker.setEnabledNormalization(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_INITIAL_VALUES_ENABLED_PRINTING", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        serializerWorker.setEnabledInitialValuesPrinting(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_LIFELINES_TRACE_ENABLED_PRINTING", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        serializerWorker.setEnabledLifelinesPrinting(enabled);
        try {
            traceFormat = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_FORMAT_ELEMENT_LIST", "comment = \"\\t// %1%\\n\"\npath#condition = \"\\tPC: %1%\\n\"\npath#timed#condition = \"\\tPtC: %1%\\n\"\nnode#condition = \"\\tNC: %1%\\n\"\nnode#timed#condition = \"\\tNtC: %1%\\n\"\ntime       = \"\\tdelta = %4%\\n\"\nassign     = \"\\t%3%=%4%\\n\"\nnewfresh   = \"\\tnewfresh(%2%:%3%) <- %4%\\n\"\ninput#env  = \"\\tINPUT  %2%:%3%%4%\\n\"\ninput#rdv  = \"\\tinput  %2%:%3%%4%\\n\"\ninput      = \"\\tinput  %2%:%3%%4%\\n\"\noutput#env = \"\\tOUTPUT %2%:%3%%4%\\n\"\noutput#rdv = \"\\toutput %2%:%3%%4%\\n\"\noutput     = \"\\toutput %2%:%3%%4%\\n\"\nroutine    = \"\\tinvoke %2%:%3%\\n\"\ntransition = \"\\tfired transition %2%:%3%\\n\"\nmachine    = \"\\trun %2%:%3%\\n\"");
        }
        catch (CoreException e) {
            e.printStackTrace();
            traceFormat = "comment = \"\\t// %1%\\n\"\npath#condition = \"\\tPC: %1%\\n\"\npath#timed#condition = \"\\tPtC: %1%\\n\"\nnode#condition = \"\\tNC: %1%\\n\"\nnode#timed#condition = \"\\tNtC: %1%\\n\"\ntime       = \"\\tdelta = %4%\\n\"\nassign     = \"\\t%3%=%4%\\n\"\nnewfresh   = \"\\tnewfresh(%2%:%3%) <- %4%\\n\"\ninput#env  = \"\\tINPUT  %2%:%3%%4%\\n\"\ninput#rdv  = \"\\tinput  %2%:%3%%4%\\n\"\ninput      = \"\\tinput  %2%:%3%%4%\\n\"\noutput#env = \"\\tOUTPUT %2%:%3%%4%\\n\"\noutput#rdv = \"\\toutput %2%:%3%%4%\\n\"\noutput     = \"\\toutput %2%:%3%%4%\\n\"\nroutine    = \"\\tinvoke %2%:%3%\\n\"\ntransition = \"\\tfired transition %2%:%3%\\n\"\nmachine    = \"\\trun %2%:%3%\\n\"";
        }
        if (traceFormat == null || traceFormat.trim().isEmpty()) {
            traceFormat = "comment = \"\\t// %1%\\n\"\npath#condition = \"\\tPC: %1%\\n\"\npath#timed#condition = \"\\tPtC: %1%\\n\"\nnode#condition = \"\\tNC: %1%\\n\"\nnode#timed#condition = \"\\tNtC: %1%\\n\"\ntime       = \"\\tdelta = %4%\\n\"\nassign     = \"\\t%3%=%4%\\n\"\nnewfresh   = \"\\tnewfresh(%2%:%3%) <- %4%\\n\"\ninput#env  = \"\\tINPUT  %2%:%3%%4%\\n\"\ninput#rdv  = \"\\tinput  %2%:%3%%4%\\n\"\ninput      = \"\\tinput  %2%:%3%%4%\\n\"\noutput#env = \"\\tOUTPUT %2%:%3%%4%\\n\"\noutput#rdv = \"\\toutput %2%:%3%%4%\\n\"\noutput     = \"\\toutput %2%:%3%%4%\\n\"\nroutine    = \"\\tinvoke %2%:%3%\\n\"\ntransition = \"\\tfired transition %2%:%3%\\n\"\nmachine    = \"\\trun %2%:%3%\\n\"";
        }
        TraceSpecificationCustomImpl format = TraceSpecificationCustomImpl.create("format", traceFormat);
        serializerWorker.setFormat(format);
        TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("trace", "// See full grammar of [Trace Specification] at the end of this generated file");
        BasicTraceSerializerWorkerCustomImpl.configureTrace(trace, configuration);
        serializerWorker.setTrace(trace);
        try {
            path = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_FOLDER_NAME", "basic");
        }
        catch (CoreException e) {
            e.printStackTrace();
            path = "basic";
        }
        serializerWorker.setFolderName(path);
        try {
            path = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_FILE_NAME", "testcases.txt");
        }
        catch (CoreException e) {
            e.printStackTrace();
            path = "tests.txt";
        }
        serializerWorker.setFileName(path);
        return serializerWorker;
    }

    private static void configureTrace(TraceSpecificationCustomImpl trace, ILaunchConfiguration configuration) {
        String detailsTrace;
        boolean enabled;
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_TIME_SELECTION", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        if (enabled) {
            trace.getElement().add(new TraceElementCustomImpl(TraceElementKind.TIME, "[*]"));
        }
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ALL_EXTERNAL_INPUT_COM_SELECTION", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        if (enabled) {
            trace.getElement().add(new TraceElementCustomImpl(TraceElementKind.INPUT_ENV, "[*]"));
        }
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ALL_EXTERNAL_OUTPUT_COM_SELECTION", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        if (enabled) {
            trace.getElement().add(new TraceElementCustomImpl(TraceElementKind.OUTPUT_ENV, "[*]"));
        }
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ALL_INPUT_COM_SELECTION", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        if (enabled) {
            trace.getElement().add(new TraceElementCustomImpl(TraceElementKind.INPUT, "[*]"));
        }
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ALL_IOUTPUT_COM_SELECTION", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        if (enabled) {
            trace.getElement().add(new TraceElementCustomImpl(TraceElementKind.OUTPUT, "[*]"));
        }
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ALL_VARIABLE_SELECTION", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        if (enabled) {
            trace.getElement().add(new TraceElementCustomImpl(TraceElementKind.VARIABLE, "[*]"));
        }
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ALL_TRANSITION_SELECTION", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        if (enabled) {
            trace.getElement().add(new TraceElementCustomImpl(TraceElementKind.TRANSITION, "[*]"));
        }
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ALL_STATE_SELECTION", false);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            enabled = false;
        }
        if (enabled) {
            trace.getElement().add(new TraceElementCustomImpl(TraceElementKind.STATE, "[*]"));
        }
        try {
            detailsTrace = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_DETAILS_ELEMENT_LIST", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            detailsTrace = null;
        }
        trace.parseAll(detailsTrace);
    }

    public void toWriter(PrettyPrintWriter writer) {
        TraceSpecificationCustomImpl trace;
        writer.commentLine(this.getComment());
        writer.appendTab("serializer#symbex#trace#basic");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        writer2.appendTabEol("property [");
        writer2.appendTab2Eol("solver = 'CVC4'");
        writer2.appendTab2Eol("format = 'BASIC'");
        writer2.appendTab2Eol("info#selection = 'ALL'");
        writer2.appendTab2Eol("data#selection = 'MODIFIED'");
        writer2.appendTab2Eol("numerizer = 'SOLVER'");
        writer2.appendTab2("normalize = ").appendEol(this.isEnabledNormalization());
        writer2.appendTab2("print#initial#values = ").appendEol(this.isEnabledInitialValuesPrinting());
        writer2.appendTab2("print#lifelines = ").appendEol(this.isEnabledLifelinesPrinting());
        writer2.appendTabEol("] // end property");
        TraceSpecificationCustomImpl format = (TraceSpecificationCustomImpl)this.getFormat();
        if (format != null) {
            format.toWriter(writer2);
        }
        if ((trace = (TraceSpecificationCustomImpl)this.getTrace()) != null) {
            trace.toWriter(writer2);
        }
        String justifier = "";
        writer2.appendTabEol("vfs [");
        String path = this.getFolderName();
        if (path != null) {
            writer2.appendTab2("folder = \"").append(path).appendEol("\"");
            justifier = "  ";
        }
        if ((path = this.getFileName()) != null) {
            writer2.appendTab2("file").append(justifier).append(" = \"").append(path).appendEol("\"");
        }
        writer2.appendTabEol("] // end vfs");
        writer.appendTabEol("}");
    }
}

