/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TraceElementKind implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "undefined"),
    CONDITION(1, "CONDITION", "condition"),
    DECISION(2, "DECISION", "decision"),
    FORMULA(3, "FORMULA", "formula"),
    PATH_CONDITION(4, "PATH_CONDITION", "path#condition"),
    PATH_CONDITION_LEAF(5, "PATH_CONDITION_LEAF", "path#condition#leaf"),
    PATH_TIMED_CONDITION(6, "PATH_TIMED_CONDITION", "path#timed#condition"),
    PATH_TIMED_CONDITION_LEAF(7, "PATH_TIMED_CONDITION_LEAF", "path#timed#condition#leaf"),
    NODE_CONDITION(8, "NODE_CONDITION", "node#condition"),
    NODE_CONDITION_LEAF(9, "NODE_CONDITION_LEAF", "node#condition#leaf"),
    NODE_TIMED_CONDITION(10, "NODE_TIMED_CONDITION", "node#timed#condition"),
    NODE_TIMED_CONDITION_LEAF(11, "NODE_TIMED_CONDITION_LEAF", "node#timed#condition#leaf"),
    ASSIGN(12, "ASSIGN", "assign"),
    DELTA(13, "DELTA", "delta"),
    TIME(14, "TIME", "time"),
    VARIABLE(15, "VARIABLE", "variable"),
    NEWFRESH(16, "NEWFRESH", "newfresh"),
    COM(17, "COM", "com"),
    INOUT(18, "INOUT", "inout"),
    INPUT(19, "INPUT", "input"),
    OUTPUT(20, "OUTPUT", "output"),
    INPUT_ENV(21, "INPUT_ENV", "input#env"),
    OUTPUT_ENV(22, "OUTPUT_ENV", "output#env"),
    INPUT_RDV(23, "INPUT_RDV", "input#rdv"),
    OUTPUT_RDV(24, "OUTPUT_RDV", "output#rdv"),
    INPUT_BUFFER(25, "INPUT_BUFFER", "input#buffer"),
    OUTPUT_BUFFER(26, "OUTPUT_BUFFER", "output#buffer"),
    INPUT_VAR(27, "INPUT_VAR", "input#var"),
    OUTPUT_VAR(28, "OUTPUT_VAR", "output#var"),
    PORT(29, "PORT", "port"),
    SIGNAL(30, "SIGNAL", "signal"),
    MESSAGE(31, "MESSAGE", "message"),
    CHANNEL(32, "CHANNEL", "channel"),
    BUFFER(33, "BUFFER", "buffer"),
    RUNNABLE(34, "RUNNABLE", "runnable"),
    ROUTINE(35, "ROUTINE", "routine"),
    TRANSITION(36, "TRANSITION", "transition"),
    MACHINE(37, "MACHINE", "machine"),
    STATE(38, "STATE", "state"),
    STATEMACHINE(39, "STATEMACHINE", "statemachine"),
    SYSTEM(40, "SYSTEM", "system"),
    FILE_HEADER(41, "FILE_HEADER", "header"),
    FILE_BEGIN(42, "FILE_BEGIN", "begin"),
    FILE_END(43, "FILE_END", "end"),
    TESTCASE_HEADER(44, "TESTCASE_HEADER", "testcase#header"),
    TESTCASE_BEGIN(45, "TESTCASE_BEGIN", "testcase#begin"),
    TESTCASE_END(46, "TESTCASE_END", "testcase#end"),
    INIT_HEADER(47, "INIT_HEADER", "init#header"),
    INIT_BEGIN(48, "INIT_BEGIN", "init#begin"),
    INIT_END(49, "INIT_END", "init#end"),
    STEP_HEADER(50, "STEP_HEADER", "step#header"),
    STEP_BEGIN(51, "STEP_BEGIN", "step#begin"),
    STEP_END(52, "STEP_END", "step#end"),
    COMMENT(53, "COMMENT", "comment"),
    SEPARATOR(54, "SEPARATOR", "separator"),
    NEWLINE(55, "NEWLINE", "newline"),
    NEXT(56, "NEXT", "next"),
    LIFELINE(57, "LIFELINE", "lifeline"),
    LIFELINE_HEADER(58, "LIFELINE_HEADER", "lifeline#header"),
    LIFELINE_BEGIN(59, "LIFELINE_BEGIN", "lifeline#begin"),
    LIFELINE_END(60, "LIFELINE_END", "lifeline#end"),
    LIFELINE_ID(61, "LIFELINE_ID", "lifeline#id"),
    LIFELINE_STATE(62, "LIFELINE_STATE", "lifeline#state"),
    RAW_ATTRIBUTE(63, "RAW_ATTRIBUTE", "RAW_ATTRIBUTE"),
    NODE_HEADER(64, "NODE_HEADER", "node#header"),
    NODE_DATA(65, "NODE_DATA", "node#data"),
    NODE_INFO(66, "NODE_INFO", "node#info"),
    NODE_TRACE_RUN(67, "NODE_TRACE_RUN", "node#trace#run"),
    NODE_TRACE_IO(68, "NODE_TRACE_IO", "node#trace#io"),
    VALUE_PARAMETER_BEGIN(69, "VALUE_PARAMETER_BEGIN", "value#parameter#begin"),
    VALUE_PARAMETER_SEPARATOR(70, "VALUE_PARAMETER_SEPARATOR", "value#parameter#separator"),
    VALUE_PARAMETER_END(71, "VALUE_PARAMETER_END", "value#parameter#end"),
    VALUE_ARRAY_BEGIN(72, "VALUE_ARRAY_BEGIN", "value#array#begin"),
    VALUE_ARRAY_SEPARATOR(73, "VALUE_ARRAY_SEPARATOR", "value#array#separator"),
    VALUE_ARRAY_END(74, "VALUE_ARRAY_END", "value#array#end"),
    VALUE_STRUCT_BEGIN(75, "VALUE_STRUCT_BEGIN", "value#struct#begin"),
    VALUE_STRUCT_SEPARATOR(76, "VALUE_STRUCT_SEPARATOR", "value#struct#separator"),
    VALUE_STRUCT_END(77, "VALUE_STRUCT_END", "value#struct#end");

    public static final int UNDEFINED_VALUE = 0;
    public static final int CONDITION_VALUE = 1;
    public static final int DECISION_VALUE = 2;
    public static final int FORMULA_VALUE = 3;
    public static final int PATH_CONDITION_VALUE = 4;
    public static final int PATH_CONDITION_LEAF_VALUE = 5;
    public static final int PATH_TIMED_CONDITION_VALUE = 6;
    public static final int PATH_TIMED_CONDITION_LEAF_VALUE = 7;
    public static final int NODE_CONDITION_VALUE = 8;
    public static final int NODE_CONDITION_LEAF_VALUE = 9;
    public static final int NODE_TIMED_CONDITION_VALUE = 10;
    public static final int NODE_TIMED_CONDITION_LEAF_VALUE = 11;
    public static final int ASSIGN_VALUE = 12;
    public static final int DELTA_VALUE = 13;
    public static final int TIME_VALUE = 14;
    public static final int VARIABLE_VALUE = 15;
    public static final int NEWFRESH_VALUE = 16;
    public static final int COM_VALUE = 17;
    public static final int INOUT_VALUE = 18;
    public static final int INPUT_VALUE = 19;
    public static final int OUTPUT_VALUE = 20;
    public static final int INPUT_ENV_VALUE = 21;
    public static final int OUTPUT_ENV_VALUE = 22;
    public static final int INPUT_RDV_VALUE = 23;
    public static final int OUTPUT_RDV_VALUE = 24;
    public static final int INPUT_BUFFER_VALUE = 25;
    public static final int OUTPUT_BUFFER_VALUE = 26;
    public static final int INPUT_VAR_VALUE = 27;
    public static final int OUTPUT_VAR_VALUE = 28;
    public static final int PORT_VALUE = 29;
    public static final int SIGNAL_VALUE = 30;
    public static final int MESSAGE_VALUE = 31;
    public static final int CHANNEL_VALUE = 32;
    public static final int BUFFER_VALUE = 33;
    public static final int RUNNABLE_VALUE = 34;
    public static final int ROUTINE_VALUE = 35;
    public static final int TRANSITION_VALUE = 36;
    public static final int MACHINE_VALUE = 37;
    public static final int STATE_VALUE = 38;
    public static final int STATEMACHINE_VALUE = 39;
    public static final int SYSTEM_VALUE = 40;
    public static final int FILE_HEADER_VALUE = 41;
    public static final int FILE_BEGIN_VALUE = 42;
    public static final int FILE_END_VALUE = 43;
    public static final int TESTCASE_HEADER_VALUE = 44;
    public static final int TESTCASE_BEGIN_VALUE = 45;
    public static final int TESTCASE_END_VALUE = 46;
    public static final int INIT_HEADER_VALUE = 47;
    public static final int INIT_BEGIN_VALUE = 48;
    public static final int INIT_END_VALUE = 49;
    public static final int STEP_HEADER_VALUE = 50;
    public static final int STEP_BEGIN_VALUE = 51;
    public static final int STEP_END_VALUE = 52;
    public static final int COMMENT_VALUE = 53;
    public static final int SEPARATOR_VALUE = 54;
    public static final int NEWLINE_VALUE = 55;
    public static final int NEXT_VALUE = 56;
    public static final int LIFELINE_VALUE = 57;
    public static final int LIFELINE_HEADER_VALUE = 58;
    public static final int LIFELINE_BEGIN_VALUE = 59;
    public static final int LIFELINE_END_VALUE = 60;
    public static final int LIFELINE_ID_VALUE = 61;
    public static final int LIFELINE_STATE_VALUE = 62;
    public static final int RAW_ATTRIBUTE_VALUE = 63;
    public static final int NODE_HEADER_VALUE = 64;
    public static final int NODE_DATA_VALUE = 65;
    public static final int NODE_INFO_VALUE = 66;
    public static final int NODE_TRACE_RUN_VALUE = 67;
    public static final int NODE_TRACE_IO_VALUE = 68;
    public static final int VALUE_PARAMETER_BEGIN_VALUE = 69;
    public static final int VALUE_PARAMETER_SEPARATOR_VALUE = 70;
    public static final int VALUE_PARAMETER_END_VALUE = 71;
    public static final int VALUE_ARRAY_BEGIN_VALUE = 72;
    public static final int VALUE_ARRAY_SEPARATOR_VALUE = 73;
    public static final int VALUE_ARRAY_END_VALUE = 74;
    public static final int VALUE_STRUCT_BEGIN_VALUE = 75;
    public static final int VALUE_STRUCT_SEPARATOR_VALUE = 76;
    public static final int VALUE_STRUCT_END_VALUE = 77;
    private static final TraceElementKind[] VALUES_ARRAY;
    public static final List<TraceElementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TraceElementKind[]{UNDEFINED, CONDITION, DECISION, FORMULA, PATH_CONDITION, PATH_CONDITION_LEAF, PATH_TIMED_CONDITION, PATH_TIMED_CONDITION_LEAF, NODE_CONDITION, NODE_CONDITION_LEAF, NODE_TIMED_CONDITION, NODE_TIMED_CONDITION_LEAF, ASSIGN, DELTA, TIME, VARIABLE, NEWFRESH, COM, INOUT, INPUT, OUTPUT, INPUT_ENV, OUTPUT_ENV, INPUT_RDV, OUTPUT_RDV, INPUT_BUFFER, OUTPUT_BUFFER, INPUT_VAR, OUTPUT_VAR, PORT, SIGNAL, MESSAGE, CHANNEL, BUFFER, RUNNABLE, ROUTINE, TRANSITION, MACHINE, STATE, STATEMACHINE, SYSTEM, FILE_HEADER, FILE_BEGIN, FILE_END, TESTCASE_HEADER, TESTCASE_BEGIN, TESTCASE_END, INIT_HEADER, INIT_BEGIN, INIT_END, STEP_HEADER, STEP_BEGIN, STEP_END, COMMENT, SEPARATOR, NEWLINE, NEXT, LIFELINE, LIFELINE_HEADER, LIFELINE_BEGIN, LIFELINE_END, LIFELINE_ID, LIFELINE_STATE, RAW_ATTRIBUTE, NODE_HEADER, NODE_DATA, NODE_INFO, NODE_TRACE_RUN, NODE_TRACE_IO, VALUE_PARAMETER_BEGIN, VALUE_PARAMETER_SEPARATOR, VALUE_PARAMETER_END, VALUE_ARRAY_BEGIN, VALUE_ARRAY_SEPARATOR, VALUE_ARRAY_END, VALUE_STRUCT_BEGIN, VALUE_STRUCT_SEPARATOR, VALUE_STRUCT_END};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TraceElementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TraceElementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TraceElementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TraceElementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TraceElementKind get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return CONDITION;
            }
            case 2: {
                return DECISION;
            }
            case 3: {
                return FORMULA;
            }
            case 4: {
                return PATH_CONDITION;
            }
            case 5: {
                return PATH_CONDITION_LEAF;
            }
            case 6: {
                return PATH_TIMED_CONDITION;
            }
            case 7: {
                return PATH_TIMED_CONDITION_LEAF;
            }
            case 8: {
                return NODE_CONDITION;
            }
            case 9: {
                return NODE_CONDITION_LEAF;
            }
            case 10: {
                return NODE_TIMED_CONDITION;
            }
            case 11: {
                return NODE_TIMED_CONDITION_LEAF;
            }
            case 12: {
                return ASSIGN;
            }
            case 13: {
                return DELTA;
            }
            case 14: {
                return TIME;
            }
            case 15: {
                return VARIABLE;
            }
            case 16: {
                return NEWFRESH;
            }
            case 17: {
                return COM;
            }
            case 18: {
                return INOUT;
            }
            case 19: {
                return INPUT;
            }
            case 20: {
                return OUTPUT;
            }
            case 21: {
                return INPUT_ENV;
            }
            case 22: {
                return OUTPUT_ENV;
            }
            case 23: {
                return INPUT_RDV;
            }
            case 24: {
                return OUTPUT_RDV;
            }
            case 25: {
                return INPUT_BUFFER;
            }
            case 26: {
                return OUTPUT_BUFFER;
            }
            case 27: {
                return INPUT_VAR;
            }
            case 28: {
                return OUTPUT_VAR;
            }
            case 29: {
                return PORT;
            }
            case 30: {
                return SIGNAL;
            }
            case 31: {
                return MESSAGE;
            }
            case 32: {
                return CHANNEL;
            }
            case 33: {
                return BUFFER;
            }
            case 34: {
                return RUNNABLE;
            }
            case 35: {
                return ROUTINE;
            }
            case 36: {
                return TRANSITION;
            }
            case 37: {
                return MACHINE;
            }
            case 38: {
                return STATE;
            }
            case 39: {
                return STATEMACHINE;
            }
            case 40: {
                return SYSTEM;
            }
            case 41: {
                return FILE_HEADER;
            }
            case 42: {
                return FILE_BEGIN;
            }
            case 43: {
                return FILE_END;
            }
            case 44: {
                return TESTCASE_HEADER;
            }
            case 45: {
                return TESTCASE_BEGIN;
            }
            case 46: {
                return TESTCASE_END;
            }
            case 47: {
                return INIT_HEADER;
            }
            case 48: {
                return INIT_BEGIN;
            }
            case 49: {
                return INIT_END;
            }
            case 50: {
                return STEP_HEADER;
            }
            case 51: {
                return STEP_BEGIN;
            }
            case 52: {
                return STEP_END;
            }
            case 53: {
                return COMMENT;
            }
            case 54: {
                return SEPARATOR;
            }
            case 55: {
                return NEWLINE;
            }
            case 56: {
                return NEXT;
            }
            case 57: {
                return LIFELINE;
            }
            case 58: {
                return LIFELINE_HEADER;
            }
            case 59: {
                return LIFELINE_BEGIN;
            }
            case 60: {
                return LIFELINE_END;
            }
            case 61: {
                return LIFELINE_ID;
            }
            case 62: {
                return LIFELINE_STATE;
            }
            case 63: {
                return RAW_ATTRIBUTE;
            }
            case 64: {
                return NODE_HEADER;
            }
            case 65: {
                return NODE_DATA;
            }
            case 66: {
                return NODE_INFO;
            }
            case 67: {
                return NODE_TRACE_RUN;
            }
            case 68: {
                return NODE_TRACE_IO;
            }
            case 69: {
                return VALUE_PARAMETER_BEGIN;
            }
            case 70: {
                return VALUE_PARAMETER_SEPARATOR;
            }
            case 71: {
                return VALUE_PARAMETER_END;
            }
            case 72: {
                return VALUE_ARRAY_BEGIN;
            }
            case 73: {
                return VALUE_ARRAY_SEPARATOR;
            }
            case 74: {
                return VALUE_ARRAY_END;
            }
            case 75: {
                return VALUE_STRUCT_BEGIN;
            }
            case 76: {
                return VALUE_STRUCT_SEPARATOR;
            }
            case 77: {
                return VALUE_STRUCT_END;
            }
        }
        return null;
    }

    private TraceElementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

