/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.launchconfiguration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.efm.execution.core.AbstractLaunchDelegate;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.efm.execution.core.workflow.DirectorCustomImpl;
import org.eclipse.efm.execution.core.workflow.WorkflowCustomImpl;
import org.eclipse.efm.execution.launchconfiguration.ui.views.page.LaunchExecConsoleManager;
import org.eclipse.efm.execution.launchconfiguration.util.BackgroundResourceRefresher;
import org.eclipse.efm.execution.launchconfiguration.util.CoreUtil;
import org.eclipse.osgi.util.NLS;

public class LaunchDelegate
extends AbstractLaunchDelegate {
    private final String BASENAME_SEP = "-";
    private final String WORKFLOW_BASENAME = "workflow";
    private final String WORKFLOW_EXTENSION = ".sew";
    private IPath fAvmExecLocation;
    private IPath fSewLocation = null;
    private IPath fWorkingDirectory = null;
    public static String fModelAnalysisProfile = "";
    public static boolean fEnableTraceExtension = false;
    LaunchExecConsoleManager fConsoleManager = new LaunchExecConsoleManager();
    boolean fEnabledDebugOrDeveloperMode = false;
    public static final int ERR_INTERNAL_ERROR = 150;

    public static boolean isValidFilename(String text) {
        Pattern pattern = Pattern.compile("# Match a valid Windows filename (unspecified file system).          \n^                                # Anchor to start of string.        \n(?!                              # Assert filename is not: CON, PRN, \n  (?:                            # AUX, NUL, COM1, COM2, COM3, COM4, \n    CON|PRN|AUX|NUL|             # COM5, COM6, COM7, COM8, COM9,     \n    COM[1-9]|LPT[1-9]            # LPT1, LPT2, LPT3, LPT4, LPT5,     \n  )                              # LPT6, LPT7, LPT8, and LPT9...     \n  (?:\\.[^.]*)?                  # followed by optional extension    \n  $                              # and end of string                 \n)                                # End negative lookahead assertion. \n[^<>:\"/\\\\|?*\\x00-\\x1F]*     # Zero or more valid filename chars.\n[^<>:\"/\\\\|?*\\x00-\\x1F\\ .]  # Last char is not a space or dot.  \n$                                # Anchor to end of string.            ", 70);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    protected IPath getWorkflowPath(ILaunchConfiguration configuration) {
        String modelBasename = DirectorCustomImpl.getModelBasename((ILaunchConfiguration)configuration);
        String configName = configuration.getName();
        String filename = "workflow" + (configName.isEmpty() ? "" : "-" + configName) + (modelBasename.isEmpty() ? "" : "-" + modelBasename) + ".sew";
        if (LaunchDelegate.isValidFilename(filename)) {
            return this.fWorkingDirectory.append(filename);
        }
        return this.fWorkingDirectory.append("workflow.sew");
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProject project;
        boolean bl = this.fEnabledDebugOrDeveloperMode = "debug".equals(mode) && (SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_DEBUG_OPTIONS") || SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_SYMBEX_DEVELOPER_MODE"));
        if (this.fEnabledDebugOrDeveloperMode) {
            System.out.println("RUN DIVERSITY");
        }
        this.fAvmExecLocation = CoreUtil.getLocation(configuration);
        if (this.fAvmExecLocation != null && (project = this.getCurrentProject(configuration)) != null) {
            this.fWorkingDirectory = project.getLocation();
            WorkflowCustomImpl workflow = WorkflowCustomImpl.create((ILaunchConfiguration)configuration, (IPath)this.fWorkingDirectory);
            this.fSewLocation = this.getWorkflowPath(configuration);
            workflow.toWriter(this.fSewLocation);
            fModelAnalysisProfile = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_ANALYSIS_PROFILE", "");
            fEnableTraceExtension = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_TRACE_EXTENSION", false);
            this.launchExec(configuration, mode, launch, monitor);
        }
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.efm.execution.core", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public IProject getCurrentProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_PROJECT_NAME", "");
        if (projectName != null && !projectName.isEmpty() && (project = root.getProject(projectName)) != null) {
            return project;
        }
        String aLocation = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "");
        if (aLocation == null || aLocation.isEmpty()) {
            this.throwCoreException("The model file does not exist.");
            return null;
        }
        IResource resource = root.findMember(aLocation);
        if (resource == null || !resource.exists()) {
            this.throwCoreException("The ressource model file \"" + aLocation + "\" does not exist.");
            return null;
        }
        return resource.getProject();
    }

    public static boolean isLaunchCoverageFamilyProfile() {
        return fEnableTraceExtension || fModelAnalysisProfile.equals("Transition Coverage") || fModelAnalysisProfile.equals("Behavior Selection");
    }

    public static boolean isLaunchExplorationFamilyProfile() {
        return fModelAnalysisProfile.equals("Exploration") || fModelAnalysisProfile.equals("Test Offline") || fModelAnalysisProfile.equals("");
    }

    public void launchExec(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        String[] arguments = CoreUtil.getArguments(configuration);
        if (monitor.isCanceled()) {
            return;
        }
        int cmdLineLength = 2 + (arguments != null ? arguments.length : 0);
        String[] cmdLine = new String[cmdLineLength];
        cmdLine[0] = this.fAvmExecLocation.toOSString();
        cmdLine[1] = this.fSewLocation.toOSString();
        if (arguments != null) {
            System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
        }
        if (monitor.isCanceled()) {
            return;
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        if (monitor.isCanceled()) {
            return;
        }
        File workingDir = this.fWorkingDirectory != null ? this.fWorkingDirectory.toFile() : null;
        boolean debugOptionMode = SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_DEBUG_OPTIONS");
        String consoleLevel = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", "MINIMUM");
        boolean spiderView = SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_SPIDER_VIEW");
        boolean consoleView = SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_CONSOLE_VIEW");
        if (spiderView && (!debugOptionMode || consoleLevel.equals("MINIMUM"))) {
            this.fConsoleManager.sewLaunchExecProcess(configuration, mode, launch, monitor, cmdLine, workingDir, envp);
        } else if (consoleView) {
            this.defaultLaunchExecProcess(configuration, mode, launch, monitor, cmdLine, workingDir, envp);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void defaultLaunchExecProcess(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, String[] cmdLine, File workingDir, String[] envp) throws CoreException {
        block12: {
            javaProcess = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
            eclipseProcess = null;
            processAttributes = new HashMap<String, String>();
            programName = this.fAvmExecLocation.lastSegment();
            extension = this.fAvmExecLocation.getFileExtension();
            if (extension != null) {
                programName = programName.substring(0, programName.length() - (extension.length() + 1));
            }
            programName = programName.toLowerCase();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
            if (javaProcess != null) {
                monitor.beginTask(NLS.bind((String)"Running {0}...", (Object[])new String[]{configuration.getName()}), -1);
                fStopavmLocation = this.getCurrentProject(configuration).getLocation().append("Output/log/stop.avm");
                fStopavmFile = fStopavmLocation.toFile();
                fStopavmFile.delete();
                eclipseProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)javaProcess, (String)this.fAvmExecLocation.toOSString(), processAttributes);
            }
            if (javaProcess == null || eclipseProcess == null) {
                if (javaProcess != null) {
                    javaProcess.destroy();
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.efm.execution.core", 150, "An IProcess could not be created for the launch", null));
            }
            eclipseProcess.setAttribute(IProcess.ATTR_CMDLINE, this.generateCommandLine(cmdLine));
            if (!configuration.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true)) ** GOTO lbl37
            scope = configuration.getAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, null);
            if (scope == null) break block12;
            refresher = new BackgroundResourceRefresher(configuration, eclipseProcess);
            refresher.startBackgroundRefresh();
            break block12;
lbl-1000:
            // 1 sources

            {
                try {
                    if (monitor.isCanceled()) {
                        eclipseProcess.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
lbl37:
                // 3 sources

                ** while (!eclipseProcess.isTerminated())
            }
lbl38:
            // 2 sources

            RefreshUtil.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
        if ((timeout = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_TIMEOUT", -1)) != -1) {
            this.launchSupervisor(configuration, javaProcess, timeout);
        }
    }

    protected void launchSupervisor(ILaunchConfiguration configuration, Process javaProcess, int timeout) {
        try {
            javaProcess.waitFor(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (javaProcess.isAlive()) {
            try {
                IPath fStopavmLocation = this.getCurrentProject(configuration).getLocation().append("Output/log/stop.avm");
                BufferedWriter stopavm = new BufferedWriter(new FileWriter(fStopavmLocation.toFile()));
                stopavm.write("");
                stopavm.close();
            }
            catch (IOException iOException) {
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            System.out.println("TIMEOUT END");
        }
    }

    private String generateCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command);
                buf.append('\"');
            } else {
                buf.append(command);
            }
            ++i;
        }
        return buf.toString();
    }
}

